/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.listSelect;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.ui.listSelect.HeaderConfig;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class TagNameConfig {
    String file;
    Properties hdrProp = new Properties();
    HeaderConfig[] config;

    public TagNameConfig() {
        this.file = SimpleUtilities.getTempDir() + File.separator + "defaultHeader.properties";
        if (new File(this.file).exists()) {
            try {
                this.parseProperties(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.parseProperties(this.getClass().getResourceAsStream("defaultHeader.properties"));
        }
    }

    public TagNameConfig(String file) throws FileNotFoundException {
        this.parseProperties(new FileInputStream(file));
        this.file = file;
    }

    public HeaderConfig getHeaderFor(DMObject o) {
        if (o == null) {
            return null;
        }
        for (int i = 0; i < this.config.length; ++i) {
            DMQuery q;
            if (!this.config[i].level.equalsIgnoreCase(o.getType()) || !(q = new DMQuery(this.config[i].query)).valid(o)) continue;
            return this.config[i];
        }
        return null;
    }

    public int getLength() {
        return this.config.length;
    }

    public HeaderConfig[] getConfig() {
        return this.config;
    }

    public String[] getTagFormat(String[] grp, String[] elem) {
        String[] tags = new String[grp.length];
        for (int i = 0; i < grp.length; ++i) {
            tags[i] = "0x" + grp[i] + ", 0x" + elem[i];
        }
        return tags;
    }

    private void parseProperties(InputStream is) {
        try {
            this.hdrProp.load(is);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        String base = this.hdrProp.getProperty("base");
        StringTokenizer st = new StringTokenizer(base, ",");
        int n = st.countTokens();
        this.config = new HeaderConfig[n];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.config[i] = new HeaderConfig();
            this.config[i].name = (String)st.nextElement();
            this.config[i].level = this.hdrProp.getProperty(this.config[i].name + ".level");
            this.config[i].query = this.hdrProp.getProperty(this.config[i].name + ".query");
            this.config[i].title = this.commaToArray(this.hdrProp.getProperty(this.config[i].name + ".title"));
            this.config[i].group = this.commaToArray(this.hdrProp.getProperty(this.config[i].name + ".group"));
            this.config[i].element = this.commaToArray(this.hdrProp.getProperty(this.config[i].name + ".element"));
            this.config[i].formatter = this.commaToArray(this.hdrProp.getProperty(this.config[i].name + ".formatter"));
            if (this.config[i].formatter != null && this.config[i].formatter.length < this.config[i].group.length) {
                String[] temp = new String[this.config[i].group.length];
                for (int j = 0; j < this.config[i].formatter.length; ++j) {
                    StringTokenizer tokenizer = new StringTokenizer(this.config[i].formatter[j], "|");
                    temp[Integer.parseInt((String)tokenizer.nextToken())] = tokenizer.nextToken();
                }
                this.config[i].formatter = temp;
            }
            this.config[i].titleWidth = this.commaToIntArray(this.hdrProp.getProperty(this.config[i].name + ".width"));
            ++i;
        }
    }

    public void save(HeaderConfig hdr) {
        String level = hdr.level;
        this.hdrProp.setProperty(hdr.name + ".level", hdr.level);
        this.hdrProp.setProperty(hdr.name + ".query", hdr.query);
        String title = new String();
        String group = new String();
        String element = new String();
        String formatter = new String();
        String width = new String();
        for (int i = 0; i < hdr.title.length; ++i) {
            title = title + hdr.title[i] + ",";
            if (hdr.group[i] != null) {
                group = group + hdr.group[i] + ",";
            }
            if (hdr.element[i] != null) {
                element = element + hdr.element[i] + ",";
            }
            if (hdr.formatter != null && hdr.formatter[i] != null) {
                formatter = formatter + i + "|" + hdr.formatter[i] + ",";
            }
            width = width + hdr.titleWidth[i] + ",";
        }
        this.hdrProp.setProperty(hdr.name + ".title", title);
        this.hdrProp.setProperty(hdr.name + ".group", group);
        this.hdrProp.setProperty(hdr.name + ".element", element);
        this.hdrProp.setProperty(hdr.name + ".formatter", formatter);
        this.hdrProp.setProperty(hdr.name + ".width", width);
        try {
            FileOutputStream fout = new FileOutputStream(this.file);
            this.hdrProp.store(fout, null);
            fout.close();
            System.out.println("save to=" + this.file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private int[] commaToIntArray(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        int[] ina = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ina[i++] = Integer.parseInt(st.nextToken());
        }
        return ina;
    }

    private String[] commaToArray(String str) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        String[] strs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            strs[i++] = st.nextToken();
        }
        return strs;
    }

    public static void main(String[] args) {
        TagNameConfig config = new TagNameConfig();
        System.out.println("Length= " + config.getLength());
        HeaderConfig[] hconfigs = config.getConfig();
        for (int i = 0; i < hconfigs.length; ++i) {
            int j;
            System.out.println("Level- " + hconfigs[i].level);
            System.out.println("Name - " + hconfigs[i].name);
            System.out.println("Query- " + hconfigs[i].query);
            for (j = 0; j < hconfigs[i].title.length; ++j) {
                System.out.println("Title- " + hconfigs[i].title[j] + " (width= " + hconfigs[i].titleWidth[j] + ")");
            }
            for (j = 0; j < hconfigs[i].group.length; ++j) {
                System.out.println("(" + hconfigs[i].group[j] + ", " + hconfigs[i].element[j] + ")");
            }
            for (j = 0; hconfigs[i].formatter != null && j < hconfigs[i].formatter.length; ++j) {
                System.out.println("Formatter[" + j + "]- " + hconfigs[i].formatter[j]);
            }
        }
    }
}

