/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.wl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowLevelModel {
    protected int minimum_;
    protected int maximum_;
    protected List listeners_ = new ArrayList();

    public int getMinimum() {
        return this.minimum_;
    }

    public void setMinimum(int minimum) {
        this.set(minimum, Math.max(minimum, this.maximum_));
    }

    public int getMaximum() {
        return this.maximum_;
    }

    public void setMaximum(int maximum) {
        this.set(Math.min(maximum, this.minimum_), maximum);
    }

    public int getCenter() {
        return (this.minimum_ + this.maximum_) / 2;
    }

    public void setCenter(int center) {
        this.set(center - this.getWidth() / 2, center - this.getWidth() / 2 + this.getWidth());
    }

    public int getWidth() {
        return this.maximum_ - this.minimum_;
    }

    public void setWidth(int width) {
        this.set(this.getCenter() - Math.max(0, width) / 2, this.getCenter() - Math.max(0, width) / 2 + Math.max(0, width));
    }

    protected void set(int minimum, int maximum) {
        int getMinimum = this.getMinimum();
        int getMaximum = this.getMaximum();
        this.minimum_ = minimum;
        this.maximum_ = maximum;
        if (getMinimum != this.getMinimum() || getMaximum != this.getMaximum()) {
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners_.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners_.remove(l);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator i = this.listeners_.iterator();
        while (i.hasNext()) {
            ((ChangeListener)i.next()).stateChanged(event);
        }
    }
}

