/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.Utils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressedInputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 8192;
    private byte[] inBuf;
    private int inLen;
    private int outLen;
    private byte[] outBuf;
    private byte[] lenBuf;
    private int outOffset;
    private Inflater inflater = new Inflater();

    public CompressedInputStream(InputStream is) throws IOException {
        super(is);
        this.lenBuf = new byte[4];
        this.inBuf = new byte[8192];
        this.outBuf = new byte[8192];
    }

    private void readAndUncompress() throws IOException {
        Utils.readInt(this.in, this.lenBuf);
        this.inLen = Utils.getInt(this.lenBuf, 0);
        Utils.readFully(this.in, this.inBuf, 0, this.inLen);
        this.inflater.setInput(this.inBuf, 0, this.inLen);
        try {
            this.outLen = this.inflater.inflate(this.outBuf);
        }
        catch (DataFormatException ex) {
            throw new IOException("Data format exception - " + ex.getMessage());
        }
        finally {
            this.inflater.reset();
            this.outOffset = 0;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.outOffset >= this.outLen) {
            try {
                this.readAndUncompress();
            }
            catch (EOFException ex) {
                return -1;
            }
        }
        return this.outBuf[this.outOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int toCopy;
        for (count = 0; count < len; count += toCopy) {
            if (this.outOffset >= this.outLen) {
                try {
                    if (count > 0 && this.in.available() == 0) {
                        return count;
                    }
                    this.readAndUncompress();
                }
                catch (EOFException eof) {
                    if (count == 0) {
                        count = -1;
                    }
                    return count;
                }
            }
            toCopy = Math.min(this.outLen - this.outOffset, len - count);
            System.arraycopy(this.outBuf, this.outOffset, b, off + count, toCopy);
            this.outOffset += toCopy;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.outLen - this.outOffset + this.in.available();
    }
}

