/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public abstract class XmBasicService
extends XmServiceAdapter {
    protected static final byte RESPONSE = 3;
    protected static final byte RESPOND = 4;
    protected static final byte EXCEPTION = 5;
    protected static final byte NO_RESPOND = 6;
    protected Method[] methods;
    protected boolean onServer = false;
    private static int tcount = 1234;
    private XmSession xms;
    private XmServiceStatus stat = new XmServiceStatus();
    private Vector que = new Vector();
    private boolean kill = false;
    private Msg SENT = new Msg(-1);
    private Object[] args = new Object[1];
    private Hashtable responseMap = new Hashtable();
    private Thread queMgr = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Vector vector = XmBasicService.this.que;
                synchronized (vector) {
                    while (XmBasicService.this.que.isEmpty()) {
                        try {
                            XmBasicService.this.que.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!XmBasicService.this.kill) continue;
                        return;
                    }
                }
                XmBasicService.this.processValue((Msg)XmBasicService.this.que.remove(0));
            }
        }
    };

    protected XmBasicService() {
        this.queMgr.setDaemon(false);
        this.queMgr.setName(this.getClass().getSimpleName() + " Command Queue Thread");
        this.queMgr.start();
    }

    public void installInto(XmSession xms) {
        this.xms = xms;
        xms.installHandle(this);
    }

    protected XmSession getParent() {
        return this.xms;
    }

    @Override
    public void setParent(XmSession parent) {
        this.xms = parent;
        this.onServer = !parent.isClient();
    }

    public short getParentId() {
        short id = null != this.xms ? (short)this.xms.getId() : (short)-1;
        return id;
    }

    public void close() {
        this.xms.uninstallHandle(this.getID());
    }

    @Override
    public XmServiceStatus getStatus() {
        return this.stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionLost() {
        this.kill = true;
        Vector vector = this.que;
        synchronized (vector) {
            this.que.notifyAll();
        }
    }

    public boolean isClosed() {
        return this.kill;
    }

    protected void setMethods(String[] methodNames) {
        this.methods = new Method[methodNames.length];
        Class<?> c = this.getClass();
        for (int i = 0; i < methodNames.length; ++i) {
            try {
                this.methods[i] = c.getMethod(methodNames[i], byte[].class);
                continue;
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Unable to set methods associated to remote commands: ", ex);
            }
        }
    }

    public static synchronized int newTid() {
        return ++tcount;
    }

    public int call(byte cmd, byte sync, byte[] data) {
        Msg out = new Msg(this.id);
        int tid = XmBasicService.newTid();
        out.setData(cmd, sync, tid, data);
        this.xms.writeMessage(out);
        return tid;
    }

    public byte[] callSync(byte cmd, byte[] data) {
        int tid = this.call(cmd, (byte)4, data);
        return this.waitForRsp(cmd, tid);
    }

    public byte[] callSync(byte cmd, byte[] data, long timeout) throws InterruptedException, TimeoutException {
        int tid = this.call(cmd, (byte)4, data);
        return this.waitForRsp(cmd, tid, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForRsp(byte cmd, int tid) {
        Long msgT = this.computeMessageTag(cmd, tid);
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(msgT)) {
                try {
                    this.responseMap.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            Msg m = (Msg)this.responseMap.remove(msgT);
            if (m.command[1] == 5) {
                throw new RuntimeException((Throwable)Utils.bytesToObject(m.msgBuffer));
            }
            return m.msgBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForRsp(byte cmd, int tid, long timeout) throws InterruptedException, TimeoutException {
        Long msgT = this.computeMessageTag(cmd, tid);
        long start = System.currentTimeMillis();
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(msgT)) {
                this.responseMap.wait(timeout);
                if (System.currentTimeMillis() - start <= timeout) continue;
                throw new TimeoutException("Exceeed timeout " + timeout + " ms");
            }
            Msg m = (Msg)this.responseMap.remove(msgT);
            if (m.command[1] == 5) {
                throw new RuntimeException((Throwable)Utils.bytesToObject(m.msgBuffer));
            }
            return m.msgBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readMessage(InputStream is) throws IOException {
        Msg m = new Msg(this.id);
        int ret = m.readMessage(is);
        this.que.add(m);
        Vector vector = this.que;
        synchronized (vector) {
            this.que.notifyAll();
        }
        return ret;
    }

    @Override
    public int writeMessage(OutputStream os, short mid) throws IOException {
        throw new RuntimeException("This should never be used");
    }

    private void processValue(Msg m) {
        if (m.id == -1) {
            this.messageSent();
            return;
        }
        byte[] ret = null;
        if (m.command[1] == 3 || m.command[1] == 5) {
            this.processResponse(m);
            return;
        }
        if (m.command[1] != 4) {
            m.setTID(0);
        }
        if (this.methods.length <= m.command[0] || this.methods[m.command[0]] == null) {
            Tap.log.log(Level.WARNING, "No such command: {0}", m.command[0]);
            this.sendResponse(m, (byte)5, Utils.objectToBytes(new NoSuchMethodError("No such command: " + m.command[0])));
            return;
        }
        try {
            this.args[0] = m.msgBuffer;
            ret = (byte[])this.methods[m.command[0]].invoke((Object)this, this.args);
            if (m.command[1] == 4) {
                this.sendResponse(m, (byte)3, ret);
            }
        }
        catch (Exception e) {
            this.sendResponse(m, (byte)5, Utils.objectToBytes(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Msg m) {
        int tid = m.getTID();
        if (0 == tid) {
            try {
                this.processAsyncException(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Long msgT = this.computeMessageTag(m.getCommand(), tid);
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            this.responseMap.put(msgT, m);
            this.responseMap.notifyAll();
        }
    }

    protected void messageSent() {
    }

    protected void processAsyncException(Msg errmsg) {
    }

    protected Long computeMessageTag(Msg msg) {
        return this.computeMessageTag(msg.getCommand(), msg.getTID());
    }

    protected Long computeMessageTag(byte cmd, int tid) {
        return new Long((long)cmd << 32 | (long)tid);
    }

    private void sendResponse(Msg m, byte response, byte[] ret) {
        m.command[1] = response;
        m.msgBuffer = ret == null ? new byte[0] : ret;
        m.setLen(m.msgBuffer.length);
        this.xms.writeMessage(m);
    }

    protected class Msg
    extends XmServiceAdapter {
        public static final int CMD = 0;
        public static final int RES = 1;
        public static final int TID = 2;
        public static final int LEN = 6;
        public byte[] command = new byte[10];
        public int len;
        public byte[] msgBuffer;

        Msg(short id) {
            this.id = id;
        }

        protected void setData(byte cmd, byte sync, int tid, byte[] msg) {
            byte[] data = null == msg ? new byte[]{} : msg;
            this.command[0] = cmd;
            this.command[1] = sync;
            Utils.putInt(this.command, 2, tid);
            Utils.putInt(this.command, 6, data.length);
            this.len = data.length;
            this.msgBuffer = data;
        }

        public void setLen(int len) {
            this.len = len;
            Utils.putInt(this.command, 6, len);
        }

        public int getTID() {
            return Utils.getInt(this.command, 2);
        }

        public void setTID(int tid) {
            Utils.putInt(this.command, 2, tid);
        }

        public byte getCommand() {
            return this.command[0];
        }

        @Override
        public int readMessage(InputStream is) throws IOException {
            Utils.readFully(is, this.command);
            this.len = Utils.getInt(this.command, 6);
            this.msgBuffer = new byte[this.len];
            Utils.readFully(is, this.msgBuffer);
            return this.len + this.command.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            os.write(this.command);
            os.write(this.msgBuffer, 0, this.len);
            XmBasicService.this.que.add(XmBasicService.this.SENT);
            Vector vector = XmBasicService.this.que;
            synchronized (vector) {
                XmBasicService.this.que.notifyAll();
            }
            return this.len + this.command.length;
        }

        public String toString() {
            String str = "";
            str = str + "(command=" + this.command[0] + ") ";
            str = str + "(response=" + this.command[1] + ") ";
            str = str + "(length=" + this.len + ")";
            return str;
        }
    }
}

