/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ImageCreator {
    private SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
    private String seed = null;
    DicomComposite comp = new DicomComposite();

    public ImageCreator() throws Exception {
        this(null);
    }

    public ImageCreator(String seed) throws Exception {
        this.seed = seed;
        if (seed == null) {
            this.comp.read(this.getClass().getResourceAsStream("mrseed.dcm"));
        } else {
            FileInputStream in = new FileInputStream(seed);
            this.comp.read(in);
            in.close();
        }
    }

    public void install(int patients, int studies, int series, int images, DMSession dest) throws Exception {
        for (int p = 0; p < patients; ++p) {
            this.comp.setValue(16, 16, "Patient" + (p + 1));
            this.comp.setValue(16, 32, "" + (p + 1));
            this.comp.setValue(16, 48, this.fmt.format(Calendar.getInstance().getTime()));
            for (int e = 0; e < studies; ++e) {
                this.comp.setValue(32, 16, "" + (e + 1));
                this.comp.setValue(32, 13, UidGenerator.newInstanceUID());
                for (int s = 0; s < series; ++s) {
                    this.comp.setValue(32, 14, UidGenerator.newInstanceUID());
                    this.comp.setValue(32, 17, "" + (s + 1));
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < images; ++i) {
                        this.comp.setValue(8, 24, UidGenerator.newInstanceUID());
                        this.comp.setValue(32, 19, "" + (i + 1));
                        dest.send(DMUtils.MSG_RESERVE_SPACE + "=8000");
                        dest.install(this.comp.getInputStream());
                        dest.send(DMUtils.MSG_RELEASE_SPACE);
                    }
                    System.out.println("Series installed in " + (System.currentTimeMillis() - start) + " ms");
                }
            }
        }
    }

    public static void usage() {
        System.out.println("java com.ge.med.terra.tap.util.dicom.ImageCreator");
        System.out.println("\t[-seed /path/to/seed/file]");
        System.out.println("\t[-dir /paths/to/dicom/files]");
        System.out.print("\t[-p numPatients");
        System.out.print(" -e numExams");
        System.out.print(" -s numSeries");
        System.out.println(" -i numImages]");
        System.out.println("\t-ses <session args>");
        System.exit(1);
    }

    public static void main(String[] args) {
        int i;
        if (args.length == 0) {
            ImageCreator.usage();
        }
        String seed = null;
        String dir = null;
        int p = 1;
        int e = 1;
        int s = 4;
        int im = 10;
        String[] sesArgs = new String[]{"pesi", "C:/dev/images/test"};
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-seed")) {
                seed = args[++i];
                continue;
            }
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                p = Integer.parseInt(args[++i]);
                e = Integer.parseInt(args[i += 2]);
                s = Integer.parseInt(args[i += 2]);
                im = Integer.parseInt(args[i += 2]);
                continue;
            }
            if (!args[i].equals("-ses")) continue;
            sesArgs = new String[args.length - i - 1];
            System.arraycopy(args, i + 1, sesArgs, 0, sesArgs.length);
        }
        System.out.print("Session args= ");
        for (i = 0; i < sesArgs.length; ++i) {
            System.out.print("\"" + sesArgs[i] + "\" ");
        }
        System.out.println("");
        DMSession ses = new DMSession(sesArgs);
        try {
            long elapsed;
            if (dir == null) {
                ImageCreator ic = new ImageCreator(seed);
                System.out.println("Installing: P=" + p + ", E=" + e + ", S=" + s + ", I= " + im);
                System.out.println("Seed File= " + (seed == null ? "default" : seed));
                long start = System.currentTimeMillis();
                ic.install(p, e, s, im, ses);
                elapsed = System.currentTimeMillis() - start;
            } else {
                System.out.println("Installing all files under " + dir);
                File[] f = SimpleUtilities.getFilesRecursively(new File(dir));
                System.out.println("" + f.length + " files found");
                long start = System.currentTimeMillis();
                ses.installFiles(f, true);
                elapsed = System.currentTimeMillis() - start;
            }
            System.out.println("Time Taken= " + elapsed + " ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

