/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.UUIDUtil;

public class UidGenerator {
    public static final String GSPS_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.11.1";
    public static final String KOS_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.88.59";
    public static final String MODALITY_PPS_SOP_CLASS_UID = "1.2.840.10008.3.1.2.3.3";
    public static final String MEDIA_STORAGE_DIRECTORY_SOP_CLASS = "1.2.840.10008.1.3.10";
    public static final String EBE_XFER_SYNTAX = "1.2.840.10008.1.2.2";
    public static final String ELE_XFER_SYNTAX = "1.2.840.10008.1.2.1";
    public static final String ILE_XFER_SYNTAX = "1.2.840.10008.1.2";
    public static final String GEBE_XFER_SYNTAX = "1.2.840.113619.5.2";
    public static final String IMPL_CLASS_UID = "1.2.840.113619.6.311";
    public static final String BH = "1.2.840.113619.2.311";
    public static final int MAX_UID_LEN = 64;
    public static final int MAX_BH_LEN = 24;
    private static final char SEP = '.';
    private static final String UID_REGEX = "(0|([1-9]\\d*))(\\.(0|([1-9]\\d*)))*\\.?";
    private String implClassUID = "1.2.840.113619.6.311";
    private String bh = "1.2.840.113619.2.311";

    public static synchronized String newInstanceUID() {
        return UidGenerator.generateUID(BH);
    }

    public synchronized String newUID() {
        return UidGenerator.generateUID(this.bh);
    }

    private static String generateUID(String prefix) {
        String uuid = UUIDUtil.randomUUIDAsInteger();
        StringBuffer sb = new StringBuffer(prefix);
        sb.append('.');
        sb.append(uuid);
        return sb.toString();
    }

    public String getBH() {
        return this.bh;
    }

    public void setBH(String bh) {
        if (!UidGenerator.isValidDicomUidFormat(bh)) {
            throw new IllegalArgumentException("Basic Header should follow the DICOM UID format rules");
        }
        if (UidGenerator.hasTrailingPeriod(bh)) {
            throw new IllegalArgumentException("Basic Header should not contain a trailing period");
        }
        if (bh.length() > 24) {
            throw new IllegalArgumentException("Basic Header must be <= 24 characters long ");
        }
        this.bh = bh;
    }

    public String getIMPL_CLASS_UID() {
        return this.implClassUID;
    }

    public void setIMPL_CLASS_UID(String implClassUID) {
        if (!UidGenerator.isValidDicomUidFormat(implClassUID)) {
            throw new IllegalArgumentException("Implementation Class UID should follow the DICOM UID format rules");
        }
        if (UidGenerator.hasTrailingPeriod(implClassUID)) {
            throw new IllegalArgumentException("Implementation Class UID should not contain a trailing period");
        }
        if (implClassUID.length() > 64) {
            throw new IllegalArgumentException("Implementation Class UID must be <= 64 characters long ");
        }
        this.implClassUID = implClassUID;
    }

    private static boolean isValidDicomUidFormat(String value) {
        return value != null && value.matches(UID_REGEX);
    }

    private static boolean hasTrailingPeriod(String value) {
        return value.charAt(value.length() - 1) == '.';
    }

    @Deprecated
    public String getCPUID() {
        return "";
    }

    @Deprecated
    public void setCPUID(String notused) {
    }

    @Deprecated
    public String getHSN() {
        return "";
    }

    @Deprecated
    public void setHSN(String notused) {
    }

    public static void main(String[] args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String uid = null;
                for (int i = 0; i < 5; ++i) {
                    uid = UidGenerator.newInstanceUID();
                    System.out.println(uid + " (size = " + uid.length() + ")");
                }
            }
        };
        Thread th1 = new Thread(runnable);
        Thread th2 = new Thread(runnable);
        th1.start();
        th2.start();
        while (th1.isAlive() || th2.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }
}

