/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.util.dicom.UsesJdt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class WrapperStream
extends InputStream
implements UsesJdt {
    String transferSynax = null;
    private DicomObject dicomObj;
    private InputStream is = null;
    private boolean loaded = false;

    public WrapperStream(DicomObject obj) {
        this.dicomObj = obj;
    }

    public WrapperStream(DicomObject obj, String transferSyntaxHint) {
        this.dicomObj = obj;
        this.transferSynax = transferSyntaxHint;
    }

    public WrapperStream(InputStream in) {
        this.is = in;
        this.loaded = true;
    }

    @Override
    public int read() throws IOException {
        if (!this.loaded) {
            this.load();
        }
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.loaded) {
            this.load();
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.loaded) {
            this.load();
        }
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (!this.loaded) {
            this.load();
        }
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (!this.loaded) {
            this.load();
        }
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.loaded) {
            this.load();
        }
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        if (!this.loaded) {
            this.load();
        }
        return this.is.markSupported();
    }

    @Override
    public DicomObject getDicomObject() {
        if (this.transferSynax != null) {
            try {
                DicomObject meta = this.dicomObj.getFileMetaInformation();
                meta.set(131088, this.transferSynax);
                meta.set(131094, InetAddress.getLocalHost().getHostName());
                this.dicomObj.setFileMetaInformation(meta);
            }
            catch (DicomException ex) {
                ex.printStackTrace();
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
        }
        return this.dicomObj;
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DicomObject meta = this.dicomObj.getFileMetaInformation();
            if (this.transferSynax != null && meta != null) {
                meta.set(131088, this.transferSynax);
                this.dicomObj.setFileMetaInformation(meta);
            }
            this.dicomObj.write(bout, true);
            byte[] data = bout.toByteArray();
            this.is = new ByteArrayInputStream(data);
            this.loaded = true;
        }
        catch (IOException bout) {
        }
        catch (DicomException ex) {
            ex.printStackTrace();
        }
    }
}

