/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.er;

import com.ge.med.terra.tap.util.er.EREvent;
import com.ge.med.terra.tap.util.er.EREventListener;
import java.lang.reflect.Constructor;

public abstract class EventRouter {
    static String client = "com.ge.med.terra.tap.util.er.ErClient";
    static String server = "com.ge.med.terra.tap.util.er.ErServer";

    public static EventRouter createClient() {
        try {
            String str = System.getProperty("Router", client);
            Class<?> c = Class.forName(str);
            EventRouter er = (EventRouter)c.newInstance();
            return er;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void startServer(int port) {
        try {
            String str = System.getProperty("RouterServer", server);
            Class<?> c = Class.forName(str);
            Constructor<?> con = c.getConstructor(Integer.TYPE);
            con.newInstance(new Integer(port));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) {
        EventRouter.startServer(args.length == 1 ? Integer.parseInt(args[0]) : 5123);
    }

    public abstract void connect(String var1, int var2);

    public abstract void sendEvent(String var1, String var2);

    public abstract void sendEvent(String var1, byte[] var2);

    public abstract void sendEvent(EREvent var1);

    public abstract void addEREventListener(String var1, int var2, EREventListener var3);

    public abstract void removeEREventListener(String var1, EREventListener var2);
}

