/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.Tap;
import java.security.SecureRandom;
import java.util.WeakHashMap;

public class Tid {
    private static WeakHashMap map = new WeakHashMap();

    public static long createNewTID() {
        return Math.abs(new UID().hashCode());
    }

    public static long pushTID(long tid) {
        long[] tab;
        Object o = map.get(Thread.currentThread());
        if (o == null) {
            tab = new long[100];
            map.put(Thread.currentThread(), tab);
        } else {
            tab = (long[])o;
        }
        tab[0] = tab[0] + 1L;
        tab[(int)tab[0]] = tid;
        return tid;
    }

    public static long popTID() {
        Object o = map.get(Thread.currentThread());
        if (o == null) {
            return -1L;
        }
        long[] tab = (long[])o;
        if (tab[0] == 0L) {
            return -1L;
        }
        long l = tab[0];
        tab[0] = l - 1L;
        return tab[(int)l];
    }

    public static long getTID() {
        Object o = map.get(Thread.currentThread());
        if (o == null) {
            return -1L;
        }
        long[] tab = (long[])o;
        if (tab[0] == 0L) {
            return -1L;
        }
        return tab[(int)tab[0]];
    }

    public static String newTid() {
        long otid = Tid.getTID();
        long newtid = Tid.pushTID(Tid.createNewTID());
        return otid + "->" + newtid;
    }

    public static void logNewTask(String transName) {
        long otid = Tid.getTID();
        Tid.pushTID(Tid.createNewTID());
        Tap.log.fine(transName + "(oldtid=" + otid + ")");
    }

    public static void logEndOfTask(String transName) {
        Tap.log.fine(transName);
        Tid.popTID();
    }

    private static class UID {
        private static int hostUnique;
        private static boolean hostUniqueSet;
        private static final Object lock;
        private static long lastTime;
        private static short lastCount;
        private final int unique;
        private final long time;
        private final short count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UID() {
            Object object = lock;
            synchronized (object) {
                if (!hostUniqueSet) {
                    hostUnique = new SecureRandom().nextInt();
                    hostUniqueSet = true;
                }
                this.unique = hostUnique;
                if (lastCount == Short.MAX_VALUE) {
                    boolean interrupted = Thread.interrupted();
                    boolean done = false;
                    while (!done) {
                        long now = System.currentTimeMillis();
                        if (now <= lastTime) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            continue;
                        }
                        lastTime = now;
                        lastCount = Short.MIN_VALUE;
                        done = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.time = lastTime;
                short s = lastCount;
                lastCount = (short)(s + 1);
                this.count = s;
            }
        }

        public int hashCode() {
            return (int)this.time + this.count;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UID) {
                UID uid = (UID)obj;
                return this.unique == uid.unique && this.count == uid.count && this.time == uid.time;
            }
            return false;
        }

        public String toString() {
            return Integer.toString(this.unique, 16) + ":" + Long.toString(this.time, 16) + ":" + Integer.toString(this.count, 16);
        }

        static {
            hostUniqueSet = false;
            lock = new Object();
            lastTime = System.currentTimeMillis();
            lastCount = Short.MIN_VALUE;
        }
    }
}

