/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import com.ge.med.terra.tap.util.socket.LoadTLSConfigurationsUtil;
import com.ge.med.terra.tap.util.socket.TrustManagerComposite;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory internalSSLSocketFactory;
    private static Properties tlsConfigProps = new Properties();
    private static final Logger logger = Logger.getLogger(CustomSSLSocketFactory.class.getName());
    private SSLSocketFactory sslClientSocketFactory = null;
    private static final int ARRAY_INITIAL_INDEX = 0;
    SSLContext context = SSLContext.getInstance("TLS");

    public CustomSSLSocketFactory(KeyManager[] customizedKeyManager, TrustManagerComposite[] customizedTrustManager, SecureRandom random) throws KeyManagementException, NoSuchAlgorithmException {
        LoadTLSConfigurationsUtil.getInstance();
        tlsConfigProps = LoadTLSConfigurationsUtil.loadTLSConfigurations();
        this.context.init(customizedKeyManager, customizedTrustManager, random);
        this.internalSSLSocketFactory = this.context.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        String configuredClientCipherSuites = tlsConfigProps.getProperty("tls.client.ciphersuites");
        this.sslClientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        String[] tlsConfiguredClientCipherSuites = configuredClientCipherSuites != null ? configuredClientCipherSuites.trim().split("\\s*,\\s*") : this.sslClientSocketFactory.getDefaultCipherSuites();
        return tlsConfiguredClientCipherSuites;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket());
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        throw new UnsupportedOperationException("Method not supported for the class CustomSSLSocketFactory ");
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String clientCipherSuites = tlsConfigProps.getProperty("tls.client.ciphersuites");
        this.sslClientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        String[] tlsClientCipherSuites = clientCipherSuites != null ? clientCipherSuites.trim().split("\\s*,\\s*") : this.sslClientSocketFactory.getDefaultCipherSuites();
        return tlsClientCipherSuites;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException("Method not supported for the class CustomSSLSocketFactory ");
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Method not supported for the class CustomSSLSocketFactory ");
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException("Method not supported for the class CustomSSLSocketFactory ");
    }

    private Socket enableTLSOnSocket(Socket socket) {
        if (socket != null && socket instanceof SSLSocket) {
            String clientVersions = tlsConfigProps.getProperty("tls.client.versions");
            try {
                if (clientVersions != null) {
                    String[] tlsClientVersions = clientVersions.trim().split("\\s*,\\s*");
                    ArrayList<String> filterVersionList = new ArrayList<String>();
                    List<String> supportedVersionList = Arrays.asList(((SSLSocket)socket).getSupportedProtocols());
                    if (tlsClientVersions != null && tlsClientVersions.length > 0) {
                        for (String versionsConfigured : tlsClientVersions) {
                            if (supportedVersionList.contains(versionsConfigured.trim())) {
                                filterVersionList.add(versionsConfigured.trim());
                                continue;
                            }
                            logger.log(Level.WARNING, "Configured TLS client version " + versionsConfigured + " is invalid");
                        }
                        if (filterVersionList.isEmpty()) {
                            logger.log(Level.WARNING, "None of the Configured TLS client versions are supported by jdk");
                            throw new IOException("Unable to set Configured TLS versions in SSL client socket");
                        }
                        ((SSLSocket)socket).setEnabledProtocols(filterVersionList.toArray(new String[0]));
                        logger.log(Level.INFO, "Configured TLS client versions are " + ((Object)filterVersionList).toString());
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception", e);
            }
        }
        return socket;
    }
}

