/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class LoadTLSConfigurationsUtil {
    private static final Logger logger = Logger.getLogger(LoadTLSConfigurationsUtil.class.getName());
    private static String decryptedKeystorePassword = "";
    private static String decryptedTruststorePassword = "";
    private static Properties tlsConfigProps = null;
    private static boolean isKeyAndTrustStoreSet = false;

    private LoadTLSConfigurationsUtil() {
    }

    public static LoadTLSConfigurationsUtil getInstance() {
        return LoadTLSConfigurationsLoader.fileLoadInstance;
    }

    public static Properties loadTLSConfigurations() {
        if (tlsConfigProps == null) {
            String tlsConfigPath = System.getProperty("TLS_CONFIG_FILE_PATH", LoadTLSConfigurationsUtil.getTLSDefaultFilePath("TLS_CONFIG_FILE_PATH"));
            logger.info("TLS Config path is : " + tlsConfigPath);
            tlsConfigProps = new Properties();
            tlsConfigProps = LoadTLSConfigurationsUtil.loadProp(tlsConfigPath);
        }
        return tlsConfigProps;
    }

    private static String getTLSDefaultFilePath(String tlsFilepath) {
        String defaultfilePath = System.getenv("SEC_HOME");
        if (defaultfilePath == null) {
            defaultfilePath = "/usr/share/gehc_security";
        }
        defaultfilePath = defaultfilePath + File.separator + "certs" + File.separator;
        if ("TLS_CONFIG_FILE_PATH".equalsIgnoreCase(tlsFilepath)) {
            defaultfilePath = defaultfilePath + "tls_config.properties";
        } else if (tlsFilepath.equalsIgnoreCase("TLS_KEY_FILE_PATH")) {
            defaultfilePath = defaultfilePath + ".key.properties";
        } else {
            logger.log(Level.INFO, "Invalid file mentioned");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "TLS Config File Path is : " + defaultfilePath);
        }
        return defaultfilePath;
    }

    private static Properties loadProp(String configPath) {
        Properties prop = new Properties();
        File filePath = new File(configPath.trim());
        if (filePath.exists() && filePath.isFile()) {
            try {
                FileInputStream fin = new FileInputStream(configPath);
                prop.load(fin);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Can't load [" + filePath.getAbsolutePath() + "] + properties file, FileNotFoundException", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can't load [" + filePath.getAbsolutePath() + "] + properties file, IOException", e);
            }
        } else {
            logger.log(Level.WARNING, "TLS properties Path [" + filePath.getAbsolutePath() + "] not found.");
        }
        return prop;
    }

    public static void setKeyAndTrustStore() {
        if (tlsConfigProps != null && !tlsConfigProps.isEmpty() && !isKeyAndTrustStoreSet) {
            LoadTLSConfigurationsUtil.setKeyAndTrustStoresAsSystemProperties(tlsConfigProps);
            isKeyAndTrustStoreSet = true;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("keyStore : " + System.getProperty("javax.net.ssl.keyStore"));
                logger.finest("TrustStore : " + System.getProperty("javax.net.ssl.trustStore"));
            }
            logger.log(Level.INFO, "Finished loading TLS Configurations");
        }
    }

    private static void setKeyAndTrustStoresAsSystemProperties(Properties tlsProps) {
        String trustStore = tlsProps.getProperty("tls.truststore");
        String keyStore = tlsProps.getProperty("tls.keystore");
        String keyStorePassword = tlsProps.getProperty("tls.keystore.password");
        String trustStorePassword = tlsProps.getProperty("tls.truststore.password");
        String passwordEncryption = tlsProps.getProperty("tls.password.encryption");
        String tlsStoreType = tlsProps.getProperty("tls.store.type");
        if (tlsStoreType != null && !"".equalsIgnoreCase(tlsStoreType)) {
            System.setProperty("javax.net.ssl.keyStoreType", tlsStoreType.trim());
            System.setProperty("javax.net.ssl.trustStoreType", tlsStoreType.trim());
        }
        LoadTLSConfigurationsUtil.setSSLTrustStore(trustStore, trustStorePassword, passwordEncryption);
        LoadTLSConfigurationsUtil.setSSLKeyStore(keyStore, keyStorePassword, passwordEncryption);
    }

    private static void setSSLTrustStore(String trustStore, String trustStorePassword, String passwordEncryption) {
        if (trustStore == null || trustStore.isEmpty()) {
            logger.log(Level.SEVERE, "TrustStore is not defined.");
            return;
        }
        File filePath = new File(trustStore.trim());
        if (!filePath.exists() || !filePath.isFile()) {
            logger.log(Level.SEVERE, "TrustStore defined " + trustStore + " does not exists");
            return;
        }
        System.setProperty("javax.net.ssl.trustStore", trustStore);
        if (trustStorePassword == null || trustStorePassword.isEmpty()) {
            logger.log(Level.SEVERE, "TrustStore password is not defined.");
            return;
        }
        if (LoadTLSConfigurationsUtil.isPasswordEncryptionOn(passwordEncryption)) {
            String decryptedTruststorePassword = LoadTLSConfigurationsUtil.getDecryptedPassword(trustStorePassword);
            if (decryptedTruststorePassword == null) {
                logger.log(Level.SEVERE, "Truststore password is not defined.");
                return;
            }
            LoadTLSConfigurationsUtil.setDecryptedTruststorePassword(decryptedTruststorePassword.trim());
            System.setProperty("javax.net.ssl.trustStorePassword", decryptedTruststorePassword.trim());
        } else {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
    }

    private static void setSSLKeyStore(String keyStore, String keyStorePassword, String passwordEncryption) {
        if (keyStore == null || keyStore.isEmpty()) {
            logger.log(Level.SEVERE, "Key store is not defined.");
            return;
        }
        File filePath = new File(keyStore.trim());
        if (!filePath.exists() || !filePath.isFile()) {
            logger.log(Level.SEVERE, "Keystore defined " + keyStore + " does not exists");
            return;
        }
        System.setProperty("javax.net.ssl.keyStore", keyStore);
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            logger.log(Level.SEVERE, "Keystore password is not defined.");
            return;
        }
        if (LoadTLSConfigurationsUtil.isPasswordEncryptionOn(passwordEncryption)) {
            String decryptedKeystorePassword = LoadTLSConfigurationsUtil.getDecryptedPassword(keyStorePassword);
            if (decryptedKeystorePassword == null) {
                logger.log(Level.SEVERE, "Keystore password is not defined.");
                return;
            }
            LoadTLSConfigurationsUtil.setDecryptedKeystorePassword(decryptedKeystorePassword.trim());
            System.setProperty("javax.net.ssl.keyStorePassword", decryptedKeystorePassword.trim());
        } else {
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
    }

    private static boolean isPasswordEncryptionOn(String passwordEncryption) {
        return !"off".equalsIgnoreCase(passwordEncryption) && !"false".equalsIgnoreCase(passwordEncryption);
    }

    private static String getDecryptedPassword(String password) {
        byte[] cipherKey;
        String decryptedPassword = null;
        Properties keyProps = LoadTLSConfigurationsUtil.loadTLSKeyFilePath();
        if (!keyProps.isEmpty() && (decryptedPassword = LoadTLSConfigurationsUtil.decryptPassword(password, cipherKey = LoadTLSConfigurationsUtil.decryptKey(keyProps.getProperty("key")))) == null) {
            logger.log(Level.SEVERE, "unable to decrypt Key store password or key.properties ");
        }
        return decryptedPassword;
    }

    private static Properties loadTLSKeyFilePath() {
        String tlsKeyPath = System.getProperty("TLS_KEY_FILE_PATH", LoadTLSConfigurationsUtil.getTLSDefaultFilePath("TLS_KEY_FILE_PATH"));
        logger.info("TLS Key path is : " + tlsKeyPath);
        return LoadTLSConfigurationsUtil.loadProp(tlsKeyPath);
    }

    private static byte[] decryptKey(String bytesEncoded) {
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)bytesEncoded);
        try {
            return DatatypeConverter.parseHexBinary((String)new String(decoded, "UTF-8"));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "Hexadecimal key provided cannot be parsed.");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, " new String(decoded,\"UTF-8\") charset is not supported ");
        }
        return decoded;
    }

    private static String decryptPassword(String encryptedPassword, byte[] cipherKey) {
        if (cipherKey != null && cipherKey.length > 0) {
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                SecretKeySpec secretKey = new SecretKeySpec(cipherKey, "AES");
                cipher.init(2, secretKey);
                byte[] decryptedStringBytes = DatatypeConverter.parseBase64Binary((String)encryptedPassword);
                return new String(cipher.doFinal(decryptedStringBytes));
            }
            catch (Exception e) {
                logger.severe("Unable to decrypt password " + e.getMessage());
            }
        }
        return null;
    }

    protected static String getDecryptedKeystorePassword() {
        return decryptedKeystorePassword;
    }

    protected static void setDecryptedKeystorePassword(String decryptedkeystorepassword) {
        decryptedKeystorePassword = decryptedkeystorepassword;
    }

    protected static String getDecryptedTruststorePassword() {
        return decryptedTruststorePassword;
    }

    protected static void setDecryptedTruststorePassword(String decryptedtruststorepasswd) {
        decryptedTruststorePassword = decryptedtruststorepasswd;
    }

    private static class LoadTLSConfigurationsLoader {
        static final LoadTLSConfigurationsUtil fileLoadInstance = new LoadTLSConfigurationsUtil();

        private LoadTLSConfigurationsLoader() {
        }
    }
}

