/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.testTools;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class testTools {
    int steps = 10;
    int stepSleep = 10;
    Robot r;

    public testTools() {
        try {
            this.r = new Robot();
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
    }

    public void pressButton(Component c) {
        this.pressButton(c, 0);
    }

    public void pressButton(Component c, int button) {
        button = this.getButton(button);
        this.moveMouseOver(c);
        this.r.mousePress(button);
    }

    public BufferedImage picture(Component c) {
        return this.r.createScreenCapture(new Rectangle(c.getLocationOnScreen(), c.getSize()));
    }

    public void moveMouseOver(Component c) {
        Point p = c.getLocationOnScreen();
        int y = c.getHeight() / 2 + p.y;
        int x = c.getWidth() / 2 + p.y;
        this.r.mouseMove(x, y);
    }

    private void wrtiePPM(BufferedImage img, String file) throws FileNotFoundException, IOException {
        int[] pixels = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        BufferedOutputStream b = new BufferedOutputStream(new FileOutputStream(file));
        b.write("P6\n".getBytes());
        String str = "" + img.getWidth() + " " + img.getHeight() + "\n";
        b.write(str.getBytes(), 0, str.length());
        b.write("255\n".getBytes());
        byte[] bpix = new byte[pixels.length * 3];
        for (int i = 0; i < pixels.length; ++i) {
            int k = i * 3;
            int n = k++;
            bpix[n] = (byte)(bpix[n] | pixels[i] & 0xFF);
            int n2 = k++;
            bpix[n2] = (byte)(bpix[n2] | pixels[i] >> 8 & 0xFF);
            int n3 = k;
            bpix[n3] = (byte)(bpix[n3] | pixels[i] >> 16 & 0xFF);
        }
        b.write(bpix);
    }

    private int getButton(int button) {
        switch (button) {
            case 0: {
                return 16;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        return 16;
    }

    public Component findComponent(Container cont, Class cl) {
        Component[] comp = cont.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            Component ret;
            if (comp[i].getClass() == cl) {
                return comp[i];
            }
            if (!(comp[i] instanceof Container) || (ret = this.findComponent((Container)comp[i], cl)) == null) continue;
            return ret;
        }
        return null;
    }

    public void mousDrag(Component c, int x1, int y1, int x2, int y2, int button) {
        Point p = c.getLocationOnScreen();
        button = this.getButton(button);
        x2 += p.x;
        y2 += p.y;
        this.r.mouseMove(x1 += p.x, y1 += p.y);
        this.r.mousePress(button);
        for (int t = 0; t <= this.steps; ++t) {
            int x = (x1 * (this.steps - t) + x2 * t) / this.steps;
            int y = (y1 * (this.steps - t) + y2 * t) / this.steps;
            this.r.waitForIdle();
            testTools.sleep(this.stepSleep);
            this.r.mouseMove(x, y);
        }
        this.r.mouseRelease(button);
    }

    public static void sleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

