/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tgraph;

import com.ge.med.terra.tap.util.tgraph.TGraph;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class TGraphCursor
extends JComponent
implements MouseListener,
MouseMotionListener {
    Point2D p = new Point2D.Double(0.0, 0.0);
    Point2D sp = new Point2D.Double(0.0, 0.0);
    public final int VERTICAL_MODE = 1;
    public final int HORIZONTAL_MODE = 2;
    public final int XY_MODE = 0;
    int mode = 1;
    private final double dist_error = 10.0;
    private boolean drag = false;
    DecimalFormat numf = new DecimalFormat();

    public void calcClosestPoint(TGraph jg) {
        if (jg.pts == null) {
            return;
        }
        block0 : switch (this.mode) {
            case 0: {
                double min_d = Double.MAX_VALUE;
                int min_i = 0;
                for (int i = 0; i < jg.pts.length - 1; ++i) {
                    double d = Line2D.ptLineDistSq(jg.pts[i].getX(), jg.pts[i].getY(), jg.pts[i + 1].getX(), jg.pts[i + 1].getY(), this.p.getX(), this.p.getY());
                    if (!(min_d > d)) continue;
                    min_d = d;
                    min_i = i;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < jg.pts.length - 1; ++i) {
                    if (!(jg.pts[i].getX() >= this.p.getX())) continue;
                    this.p.setLocation(jg.pts[i]);
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < jg.pts.length - 1; ++i) {
                    if (!(jg.pts[i].getY() >= this.p.getY())) continue;
                    this.p.setLocation(jg.pts[i]);
                    break block0;
                }
                break;
            }
        }
    }

    public void paint(Graphics g, TGraph jg) {
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        jg.at.transform(this.p, this.sp);
        int x = (int)this.sp.getX();
        int y = (int)this.sp.getY();
        this.calcClosestPoint(jg);
        this.numf.setMaximumFractionDigits(3);
        String s = "(" + this.numf.format(this.p.getX()) + "," + this.numf.format(this.p.getY()) + ")";
        jg.getClass();
        g.drawString(s, 4 + x, 20);
        g.setColor(this.getBackground());
        switch (this.mode) {
            case 0: {
                g.drawLine(x - 10, y - 10, x + 10, y + 10);
                g.drawLine(x + 10, y - 10, x - 10, y + 10);
                return;
            }
            case 1: {
                g.drawRect(x, 0, 1, jg.getHeight());
                return;
            }
            case 2: {
                g.drawRect(0, y, jg.getWidth(), 1);
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        System.out.println("mouse pressed");
        switch (this.mode) {
            case 0: {
                if (this.sp.distance(e.getX(), e.getY()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
            case 1: {
                if ((double)Math.abs((int)this.sp.getX() - e.getX()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
            case 2: {
                if ((double)Math.abs((int)this.sp.getY() - e.getY()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.drag) {
            return;
        }
        if (!(e.getSource() instanceof TGraph)) {
            return;
        }
        TGraph jg = (TGraph)e.getSource();
        Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
        try {
            jg.at.inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.p.setLocation(p);
        jg.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

