/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap;

import com.archimed.dicom.Jdt;
import java.util.Properties;

public final class version {
    private static version singleton = null;
    private static Properties prop = new Properties();

    private version() {
        this.loadPropertyValues("version.properties");
    }

    private void loadPropertyValues(String propertyFile) {
        try {
            prop.load(this.getClass().getResourceAsStream(propertyFile));
        }
        catch (Exception ex) {
            System.err.println("This is not an official TAP build: version.properties not found.");
        }
    }

    public static final version getVersion() {
        if (singleton == null) {
            singleton = new version();
        }
        return singleton;
    }

    public final String getVersionString() {
        return prop.getProperty("tap.version", "TAP_XXXXXXXX");
    }

    public final String getBuildDate() {
        return prop.getProperty("tap.build_date", "99999999");
    }

    public final String getComponentName() {
        return "TAP";
    }

    public final String getLongComponentName() {
        return "Terra Application Platform";
    }

    public final String getCompanyName() {
        return "GE Healthcare";
    }

    public final void printVersion() {
        System.out.println(this.getComponentName() + " (" + this.getLongComponentName() + ")");
        System.out.println(this.getCompanyName());
        System.out.println("Version : " + this.getVersionString());
        System.out.println("Build Date : " + this.getBuildDate());
        prop.list(System.out);
        try {
            System.out.println("--- dependencies ---");
            System.out.println("JDT Version : " + Jdt.getVersion() + " (build " + Jdt.BUILD + ")");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getVersionString() + " : " + this.getBuildDate();
    }

    public static void main(String[] args) {
        version tapVersion = version.getVersion();
        tapVersion.printVersion();
    }
}

