/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.StandAloneSystem;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.xpv.StandAloneSystem.BrowserPanel;
import com.ge.med.terra.xpv.StandAloneSystem.ConfigurePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StandAloneSystem
extends DMSystem {
    static boolean change = false;
    boolean first = true;
    public static final String OPEN_FILM_COMPOSER = "open_filmComposer";
    public static final String LogOpenMode = "LOG_APPEND";
    protected DMSession dmss = null;
    protected String appname = null;
    protected DMObject dmo = null;
    protected Properties systemProperty = null;
    public static final String VIEWER_PANEL = "viewerPanel";
    public static final String BROWSER_PANEL = "browserPanel";
    public static final String CONFIGURE_PANEL = "configurePanel";
    CardLayout cardLayout = new CardLayout();
    JPanel parentPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    JPanel rightPanel = new JPanel();
    JPanel leftBottomPanel = new JPanel();
    TerraVisionCozyBar1 cozybar;
    JPanel[] displayArea;
    boolean isMulti;
    int current;
    JPanel singleViewPanel;
    BrowserPanel browser;
    ConfigurePanel pConfigure;
    JFrame mainFrame = new JFrame();

    void showViewer() {
        this.cardLayout.show(this.rightPanel, VIEWER_PANEL);
    }

    void showBrowser() {
        this.cardLayout.show(this.rightPanel, BROWSER_PANEL);
    }

    @Override
    public Properties getDMSystemProperties() {
        return this.systemProperty;
    }

    @Override
    public DMSession getLocalDB() {
        DMObject[] exams = this.browser.getSelectedStudies();
        if (exams != null) {
            return exams[0].getSession();
        }
        return null;
    }

    @Override
    public DMObject getNextInBrowser(DMObject dMObject, boolean _boolean) {
        return this.browser.getNextInBrowser(dMObject, _boolean);
    }

    @Override
    public PrintService getPrintService() {
        DocFlavor flavor = new DocFlavor("application/x-java-" + this.getSystemName() + "-printable-print-service", "java.awt.print.Printable");
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        if (services.length > 0) {
            return services[0];
        }
        Tap.log.log(Level.WARNING, "No PrintService available");
        return null;
    }

    @Override
    public DMObject getRepresentativeDMObjet() {
        return this.dmo;
    }

    @Override
    public DMObject[] getSelection() {
        return this.browser.getSelectedStudies();
    }

    @Override
    public String getSystemName() {
        return "TerraVisionSystem";
    }

    @Override
    public void init(String appname, Properties prop, String[] args) {
        if (appname == null) {
            throw new RuntimeException("Application name should be supplied");
        }
        this.appname = appname;
        this.systemProperty = prop == null ? new Properties() : prop;
        this.systemProperty.setProperty("gspsCapable", "true");
        this.systemProperty.setProperty("screenSaveCapable", "true");
        this.systemProperty.setProperty("printServiceCapable", "true");
        this.systemProperty.setProperty("getBrowserSelectionCapable", "true");
        this.systemProperty.setProperty("setBrowserSelectionCapable", "true");
        this.systemProperty.setProperty("dbObjectLockUnlockCapable", "false");
        this.systemProperty.setProperty("systemLoggingCapable", "true");
        this.systemProperty.setProperty("manageDeskTopCapable", "false");
        this.systemProperty.setProperty("layoutControlAreaCapable", "true");
        this.systemProperty.setProperty("layoutDisplayAreaCapable", "true");
        this.systemProperty.setProperty("installWatchDogCapable", "true");
        this.systemProperty.setProperty("enableAppShowHideCapable", "false");
        this.createLogHandler();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        this.cozybar = new TerraVisionCozyBar1();
        this.browser = new BrowserPanel(this);
        this.pConfigure = new ConfigurePanel(this);
        this.pConfigure.setBrowser(this.browser);
        this.browser.startCursor();
        this.parentPanel.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add((Component)this.cozybar, "North");
        this.leftPanel.add((Component)this.leftBottomPanel, "Center");
        this.leftBottomPanel.setLayout(new BorderLayout());
        this.cozybar.setPreferredSize(new Dimension(256, 90));
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)this.browser, BROWSER_PANEL);
        this.rightPanel.add((Component)this.pConfigure, CONFIGURE_PANEL);
        this.parentPanel.add((Component)this.rightPanel, "Center");
        this.parentPanel.add((Component)this.leftPanel, "West");
        this.leftPanel.setPreferredSize(new Dimension(256, height));
        this.mainFrame.setContentPane(this.parentPanel);
        this.mainFrame.setBounds(0, 0, width, height);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setTitle(appname + " on TerraVisionSystem");
    }

    private void createLogHandler() {
        Logger appLogger = Logger.getLogger(this.appname);
        String userHome = System.getProperty("user.home");
        String logHandler = null;
        boolean appendMode = true;
        if (this.systemProperty != null) {
            String openMode = this.systemProperty.getProperty(LogOpenMode, "YES");
            if (!openMode.equals("YES")) {
                appendMode = false;
            }
            logHandler = this.systemProperty.getProperty("Log_Handler");
        }
        if (userHome != null) {
            userHome = userHome + File.separator;
            userHome = userHome + this.appname + ".xml";
        } else {
            userHome = this.appname + ".xml";
        }
        File logFile = new File(userHome);
        if (logFile.exists()) {
            try {
                if (new FileOutputStream(userHome).getChannel().tryLock() == null) {
                    throw new RuntimeException("LogFile is Locked");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            FileHandler file = new FileHandler(userHome, appendMode);
            appLogger.addHandler(file);
            appLogger.setUseParentHandlers(false);
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Could not create application logFile", ex);
            appLogger.setUseParentHandlers(true);
        }
        if (logHandler != null) {
            try {
                Class<?> cl = null;
                cl = Class.forName(logHandler);
                appLogger.addHandler((Handler)cl.newInstance());
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Could not create application Log via " + logHandler);
            }
        }
    }

    @Override
    public void installWatchDog(int _int) {
        throw new RuntimeException("installWatchDog(int) not supported");
    }

    @Override
    public boolean isSupportedSystem() {
        return true;
    }

    @Override
    public String send(String string) {
        try {
            if (string.equals(OPEN_FILM_COMPOSER)) {
                System.err.println("in openFilmComposer");
                return "OK";
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "send command failed", ex);
            throw new RuntimeException(ex);
        }
        return "Unkown Command";
    }

    @Override
    public void positionSplashScreen(Component splashScreen) {
        Dimension screenS = splashScreen.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        if (width > 2000) {
            width /= 2;
        }
        splashScreen.setBounds(width / 2 - screenS.width / 2, height / 2 - screenS.height / 2, screenS.width, screenS.height);
        splashScreen.setBackground(new Color(186, 190, 204));
    }

    @Override
    public void setControlAndDisplayAreaBounds(JPanel controlArea, JPanel[] displayArea) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        this.parentPanel.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.setBackground(null);
        this.leftPanel.add((Component)this.cozybar, "North");
        this.leftPanel.add((Component)this.leftBottomPanel, "Center");
        this.leftBottomPanel.setLayout(new BorderLayout());
        this.cozybar.setPreferredSize(new Dimension(256, 60));
        this.rightPanel.setLayout(this.cardLayout);
        this.displayArea = displayArea;
        if (this.displayArea.length > 1) {
            int i;
            String screenMode = this.systemProperty.getProperty("ScreenMode");
            if (screenMode != null && screenMode.equalsIgnoreCase("Single")) {
                this.singleViewPanel = new JPanel();
                this.singleViewPanel.setLayout(new GridLayout(1, displayArea.length));
                for (i = 0; i < displayArea.length; ++i) {
                    this.singleViewPanel.add(displayArea[i]);
                }
                this.rightPanel.add((Component)this.singleViewPanel, VIEWER_PANEL);
            } else {
                this.isMulti = true;
                this.current = -1;
                for (i = 0; i < displayArea.length; ++i) {
                    this.rightPanel.add((Component)displayArea[i], Integer.toString(i));
                }
            }
        } else if (this.displayArea.length == 1) {
            this.rightPanel.add((Component)displayArea[0], VIEWER_PANEL);
        }
        if (this.isMulti) {
            this.cozybar.setMulti();
        }
        this.rightPanel.add((Component)this.browser, BROWSER_PANEL);
        this.rightPanel.add((Component)this.pConfigure, CONFIGURE_PANEL);
        this.parentPanel.add((Component)this.rightPanel, "Center");
        this.parentPanel.add((Component)this.leftPanel, "West");
        this.leftPanel.setPreferredSize(new Dimension(256, height));
        this.mainFrame.setContentPane(this.parentPanel);
        this.mainFrame.setBounds(0, 0, width, height);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setTitle(this.appname + " on StandAloneSystem");
        this.leftBottomPanel.add((Component)controlArea, "Center");
        if (this.pConfigure.isConfigFileExist()) {
            this.cardLayout.show(this.rightPanel, BROWSER_PANEL);
            if (this.first) {
                this.browser.startCursor();
                this.first = false;
            }
        } else {
            this.cardLayout.show(this.rightPanel, CONFIGURE_PANEL);
        }
        this.mainFrame.setVisible(true);
        final Integer port = new Integer((1000 + Math.abs(this.appname.hashCode())) % 10000);
        try {
            Socket pi = new Socket("127.0.0.1", (int)port);
            DataOutputStream oss = new DataOutputStream(pi.getOutputStream());
            oss.writeBytes("show\n");
            oss.close();
            System.err.println("show message sent");
            System.exit(0);
        }
        catch (IOException ex1) {
            Tap.log.log(Level.INFO, "No Hide registered", ex1);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        ServerSocket listen = new ServerSocket(port);
                        System.err.println("server started");
                        block2: while (true) {
                            Socket s = listen.accept();
                            System.err.println("accepted....");
                            BufferedReader is = new BufferedReader(new InputStreamReader(s.getInputStream()));
                            DataOutputStream os = new DataOutputStream(s.getOutputStream());
                            while (true) {
                                String request;
                                if ((request = is.readLine()) == null) continue block2;
                                if (request.equals("show")) {
                                    StandAloneSystem.this.mainFrame.setVisible(true);
                                    continue;
                                }
                                if (!request.equals("hide")) continue;
                                StandAloneSystem.this.mainFrame.setVisible(false);
                            }
                            break;
                        }
                    }
                    catch (IOException ex) {
                        Tap.log.log(Level.WARNING, "Hide|Show server exception", ex);
                        return;
                    }
                }
            };
            t.start();
            Tap.log.log(Level.INFO, "Hide|Show server started");
        }
    }

    @Override
    public void setRepresentativeDMObjet(DMObject dMObject) {
        this.dmo = dMObject;
    }

    @Override
    public void setSelection(DMObject[] dMObjectArray) {
        this.browser.setSelection(dMObjectArray);
    }

    @Override
    public void spaceRelease(int _int) {
        throw new RuntimeException("Method spaceRelease(int handle) not supported");
    }

    @Override
    public int spaceReserve(long _long) {
        throw new RuntimeException("Method spaceReserve(long space) not supported");
    }

    private class TerraVisionCozyBar1
    extends JPanel {
        JButton next = new JButton();
        boolean isMulti = false;
        JPanel up = new JPanel();
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        JPanel jPanel1 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JButton btBrowser = new JButton();
        JButton btViewer = new JButton();
        JButton btConfig = new JButton();

        public void setMulti() {
            this.isMulti = true;
            this.next.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/StandAloneSystem/icons/nextScreen16.PNG")));
            this.jPanel1.add((Component)this.next, null);
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (StandAloneSystem.this.current < 0) {
                        return;
                    }
                    ++StandAloneSystem.this.current;
                    StandAloneSystem.this.current %= StandAloneSystem.this.displayArea.length;
                    StandAloneSystem.this.cardLayout.show(StandAloneSystem.this.rightPanel, new Integer(StandAloneSystem.this.current).toString());
                }
            });
            this.repaint();
        }

        public TerraVisionCozyBar1() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.borderLayout1);
            this.btViewer.setFocusPainted(false);
            this.btBrowser.setFocusPainted(false);
            this.next.setFocusPainted(false);
            this.btConfig.setFocusPainted(false);
            this.btBrowser.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/StandAloneSystem/icons/browser.png")));
            this.btBrowser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TerraVisionCozyBar1.this.btBrowser_actionPerformed(e);
                }
            });
            this.btViewer.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/StandAloneSystem/icons/viewer.PNG")));
            this.btViewer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TerraVisionCozyBar1.this.btViewer_actionPerformed(e);
                }
            });
            this.btConfig.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/StandAloneSystem/icons/config.png")));
            this.btConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TerraVisionCozyBar1.this.btConfig_actionPerformed(e);
                }
            });
            this.jPanel1.setLayout(new GridLayout(1, 4));
            this.add((Component)this.jPanel1, "Center");
            this.jPanel1.add(this.btViewer);
            this.jPanel1.add(this.btBrowser);
            this.jPanel1.add(this.btConfig);
            this.up.setSize(5, 10);
            this.left.setSize(7, 5);
            this.right.setSize(7, 5);
            this.add((Component)this.up, "North");
            this.add((Component)this.left, "West");
            this.add((Component)this.right, "East");
            this.setBackground(new Color(186, 193, 218));
            this.up.setBackground(null);
            this.left.setBackground(null);
            this.right.setBackground(null);
            this.jPanel1.setBackground(null);
        }

        public void btBrowser_actionPerformed(ActionEvent e) {
            StandAloneSystem.this.cardLayout.show(StandAloneSystem.this.rightPanel, StandAloneSystem.BROWSER_PANEL);
            if (this.isMulti) {
                StandAloneSystem.this.current = -1;
            }
        }

        public void btViewer_actionPerformed(ActionEvent e) {
            if (this.isMulti) {
                StandAloneSystem.this.cardLayout.show(StandAloneSystem.this.rightPanel, new Integer(0).toString());
                StandAloneSystem.this.current = 0;
            } else {
                StandAloneSystem.this.cardLayout.show(StandAloneSystem.this.rightPanel, StandAloneSystem.VIEWER_PANEL);
            }
        }

        public void btConfig_actionPerformed(ActionEvent e) {
            StandAloneSystem.this.cardLayout.show(StandAloneSystem.this.rightPanel, StandAloneSystem.CONFIGURE_PANEL);
            if (this.isMulti) {
                StandAloneSystem.this.current = -1;
            }
        }
    }
}

