/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.util.DisplayAnnotPrefUtils;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class XPwAnnotRadioControl
extends JRadioButton
implements CapableListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    XpDicomElement elem = new XpDicomElement(8, 96);
    String modality_ = "mr";
    ActionListener annotLevelChangeList = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            TransactionLogName tln = new TransactionLogName("TID=SD_annotationLevel_" + cmd);
            XPutil.getLogger().log(Level.FINEST, "{0} begin", tln);
            AnnotCapable annotPort = (AnnotCapable)XPwAnnotRadioControl.this.screen.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
            if (annotPort == null) {
                XPutil.getLogger().log(Level.SEVERE, "{0} SEV5 Not AnnotCapable", tln);
                return;
            }
            if (!cmd.equals("custom")) {
                FactoryPreferenceCapble.getInstance().updateScreenAnnotationLevel(cmd);
                DisplayAnnotPrefUtils.setAnnotLevel(annotPort, cmd);
                annotPort.repaint();
            } else {
                XPwAnnotRadioControl.this.applyCustomAnnot();
            }
            XPwAnnotRadioControl.this.screen.putClientProperty("screen_annotation_level", cmd);
            XPutil.getLogger().log(Level.FINEST, "{0} end", tln);
        }
    };

    public XPwAnnotRadioControl(String name) {
        super(name);
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.addActionListener(this.annotLevelChangeList);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    public void applyCustomAnnot() {
        TransactionLogName tln = new TransactionLogName("TID=SD_annotationLevel_custom");
        XPutil.getLogger().log(Level.FINEST, "{0} begin", tln);
        AnnotCapable annotPort = (AnnotCapable)this.screen.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
        if (this.screen.getSelectedPort() instanceof XpCompositePort) {
            XpCompositePort disp = (XpCompositePort)this.screen.getSelectedPort();
            XpFrameVisualizer vis = disp.getPort(0);
            vis.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        } else if (this.screen.getSelectedPort() instanceof XpSingularPort) {
            XpSingularPort disp = (XpSingularPort)this.screen.getSelectedPort();
            disp.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        }
        if (annotPort != null) {
            FactoryPreferenceCapble.getInstance().updateScreenAnnotationLevel("custom");
            DisplayAnnotPrefUtils.setCustomAnnotItems(annotPort, this.modality_, FactoryPreferenceCapble.getInstance().getScreenCustomAnnotationLevel());
            annotPort.repaint();
            XPutil.getLogger().log(Level.FINEST, "{0} end", tln);
        } else {
            XPutil.getLogger().log(Level.SEVERE, "{0} SEV5 Not AnnotCapable", tln);
        }
    }
}

