/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.print.PrintablePort;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.DicomPrintablePort;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.swing.JButton;
import javax.swing.JComponent;

public class XPwFilmImage
extends JButton
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = new AutoControlPanelSeek(this);
    String docFlavor;
    Properties prop;

    public XPwFilmImage() {
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    private void jbInit() throws Exception {
        this.setFont(new Font("SansSerif", 1, 11));
        this.setToolTipText(res.getString("Film_Selected_Image_"));
        this.setText(res.getString("IMAGE"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPwFilmImage.this.this_actionPerformed(e);
            }
        });
    }

    @Override
    public void setProperties(Properties properties) {
        this.prop = properties;
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    void this_actionPerformed(ActionEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwFilmImage>  " + Tid.newTid());
        try {
            Class.forName("com.ge.med.terra.xpv.print.JavaPrintService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DocPrintJob job = null;
        DMSystem dmSystem = (DMSystem)this.screen.getClientProperty("dmSystem");
        if (dmSystem != null) {
            System.err.println("XPwFilmImage.this_actionPerformed(), dmsystem = " + dmSystem);
            String printAble = dmSystem.getDMSystemProperties().getProperty("printServiceCapable");
            if (printAble != null && printAble.equalsIgnoreCase("true")) {
                job = dmSystem.getPrintService().createPrintJob();
            }
        } else {
            System.err.println("++_+_+_+_XPwFilmImage.this_actionPerformed(): dmsystem null!!");
        }
        if (job == null) {
            String docFlavor = this.prop.getProperty("DOC_FLAVOR", "IOS");
            if (docFlavor == null) {
                XPutil.getLogger().log(Level.FINEST, "End <XPwFilmImage>");
                Tid.popTID();
                return;
            }
            DocFlavor flavor = new DocFlavor("application/x-java-" + docFlavor + "-printable-print-service", "java.awt.print.Printable");
            PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
            if (services.length == 0) {
                XPutil.getLogger().log(Level.WARNING, "no print service available");
                XPutil.getLogger().log(Level.FINEST, "End <XPwFilmImage>");
                Tid.popTID();
                return;
            }
            job = services[0].createPrintJob();
        }
        if (job == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwFilmImage>");
            Tid.popTID();
            return;
        }
        JComponent port = this.screen.getSelectedPort();
        SimpleDoc doc = null;
        if (port instanceof XpMultiImageViewport || port instanceof XpSeriesDisplayer) {
            DicomPrintablePort savedScreen = new DicomPrintablePort();
            int currentImageIndex = ((SelectionCapable)((Object)port)).getComponentSelection();
            if (currentImageIndex < 0) {
                return;
            }
            savedScreen.setImages(new XpMedicalImage[]{(XpMedicalImage)((XpSingularPort)((SelectionCapable)((Object)port)).getViewportComponent(currentImageIndex)).getFrame()});
            savedScreen.getScene(0).setImageRenderAttributes(((XpCompositePort)port).getScene(currentImageIndex).getImageRenderAttributes());
            savedScreen.setRowCol(1, 1);
            savedScreen.setAnnotationVisible(Boolean.getBoolean("XPwFilm.showAnnotation"));
            savedScreen.setPrimaryBorder(null);
            doc = new SimpleDoc(savedScreen, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        } else {
            doc = new SimpleDoc(new PrintablePort(port), DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        }
        try {
            job.print(doc, null);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
            XPutil.getLogger().log(Level.WARNING, "Print Image Failed", pe);
            Tid.popTID();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwFilmImage>");
        Tid.popTID();
    }
}

