/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class XPwPanXTextField
extends JTextField
implements CapableListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    double currentPanX;
    DecimalFormat panFormat = new DecimalFormat("00");
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "pan") {
                XPwPanXTextField.this.updatePanSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                XPwPanXTextField.this.updatePanSetting();
            }
        }
    };

    public XPwPanXTextField() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            return;
        }
        this.setText(this.panFormat.format(pzPort.getPanX()));
        this.currentPanX = pzPort.getPanX();
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    private void updatePanSetting() {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (XPutil.compareCallBack(this.currentPanX, pzPort.getPanX())) {
            this.setText(this.panFormat.format(pzPort.getPanX()));
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.setFont(new Font("Dialog", 0, 12));
        this.setMinimumSize(new Dimension(30, 23));
        this.setPreferredSize(new Dimension(30, 30));
        this.setToolTipText("X-Coordinate Value");
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setText("0");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPwPanXTextField.this.this_actionPerformed(e);
            }
        });
    }

    void this_actionPerformed(ActionEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwPanXTextField> " + Tid.newTid());
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwPanXTextField>");
            Tid.popTID();
            return;
        }
        try {
            pzPort.setPanX(Double.parseDouble(this.getText()));
            this.currentPanX = pzPort.getPanX();
        }
        catch (NumberFormatException ex) {
            XPutil.getLogger().log(Level.WARNING, "", ex);
            this.setText(this.panFormat.format(pzPort.getPanX()));
            this.currentPanX = pzPort.getPanX();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwPanXTextField>");
        Tid.popTID();
    }

    public Double getPanX() {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            return null;
        }
        return new Double(pzPort.getPanX());
    }
}

