/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.Messages;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class XPwSliceScrollBar
extends JScrollBar
implements CapableListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    int currentIndex;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FramePositioningCapable fp;
            if (evt.getPropertyName() == "data_changed") {
                XPwSliceScrollBar.this.updateScrollBar();
            } else if (evt.getPropertyName() == "RowColumnProperty") {
                XPwSliceScrollBar.this.updateScrollBar();
            } else if (evt.getPropertyName() == "FrameIndex" && (fp = (FramePositioningCapable)XPwSliceScrollBar.this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable")) != null) {
                if (fp.getFrameIndex() == XPwSliceScrollBar.this.currentIndex) {
                    return;
                }
                XPwSliceScrollBar.this.updateScrollBar();
            }
        }
    };

    public XPwSliceScrollBar() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setBackground(null);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        this.updateScrollBar();
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        this.screen.addPropertyChangeListener(this.viewPortListener);
        this.updateScrollBar();
    }

    private void updateScrollBar() {
        FramePositioningCapable fp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (fp == null) {
            return;
        }
        RowColCapable rc = (RowColCapable)this.panelSeek.getCapable("com.ge.med.idc.RowColCapable");
        this.currentIndex = fp.getFrameIndex();
        if (this.getMaximum() != fp.getFrameIndex() + 1) {
            int thisFrameNum = fp.getFrameIndex() + 1;
            if (rc == null) {
                this.setMaximum(fp.getNumFrames() + 1);
            } else {
                this.setMaximum(fp.getNumFrames() + rc.getRows() * rc.getCols());
            }
            if (this.getValue() != thisFrameNum) {
                this.setValue(thisFrameNum);
            }
        } else if (this.getValue() != fp.getFrameIndex() + 1) {
            this.setValue(fp.getFrameIndex() + 1);
        }
        if (rc != null) {
            int mt = rc.getRows() * rc.getCols();
            if (this.getVisibleAmount() != mt) {
                this.setVisibleAmount(mt);
            }
        } else if (this.getVisibleAmount() != fp.getFrameIndex()) {
            this.setVisibleAmount(fp.getFrameIndex());
        }
        this.repaint();
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.setMinimum(1);
        this.setOrientation(0);
        this.setToolTipText(Messages.getString("XPwSliceScrollBar.SelectFrame"));
        this.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                XPwSliceScrollBar.this.this_adjustmentValueChanged(e);
            }
        });
    }

    void this_adjustmentValueChanged(AdjustmentEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwSliceScrollBar> " + Tid.newTid());
        CineCapable cp = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cp != null && cp.getCine()) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwSliceScrollBar> ");
            Tid.popTID();
            return;
        }
        FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (dp != null) {
            dp.setFrameIndex(this.getValue() - 1);
            this.currentIndex = dp.getFrameIndex();
            ((JComponent)((Object)dp)).repaint();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwSliceScrollBar> ");
        Tid.popTID();
    }

    public Integer getCurrentFrameNo() {
        FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (dp == null) {
            return null;
        }
        return new Integer(dp.getFrameIndex());
    }
}

