/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.terra.xpv.base.AnnotationSystem;
import com.ge.med.terra.xpv.onport.XPportAnnotation;
import java.util.Properties;
import java.util.StringTokenizer;

public class BasicAnnotation
implements AnnotationSystem {
    Properties props = null;
    private static XPportAnnotation defAnnot = null;
    private static XPportAnnotation noneAnnot = null;
    private static XPportAnnotation partialAnnot = null;
    private static XPportAnnotation fullAnnot = null;

    @Override
    public void setProperties(Properties prop) {
        this.props = prop;
    }

    @Override
    public XPportAnnotation getAnnot(int level) {
        if (this.props == null) {
            if (defAnnot == null) {
                defAnnot = new XPportAnnotation();
                defAnnot.setNWTags(new String[]{"16,16"});
                defAnnot.setSW(new String[]{"Im:", "Se:"});
                defAnnot.setSWTags(new String[]{"32,19", "32,17"});
            }
            return defAnnot;
        }
        switch (level) {
            case 2: {
                if (noneAnnot == null) {
                    noneAnnot = new XPportAnnotation();
                    this.fillAnnotation(noneAnnot, "NONE");
                }
                return noneAnnot;
            }
            case 1: {
                if (partialAnnot == null) {
                    partialAnnot = new XPportAnnotation();
                    this.fillAnnotation(partialAnnot, "PARTIAL");
                }
                return partialAnnot;
            }
            case 0: {
                if (fullAnnot == null) {
                    fullAnnot = new XPportAnnotation();
                    this.fillAnnotation(fullAnnot, "FULL");
                }
                return fullAnnot;
            }
        }
        if (defAnnot == null) {
            defAnnot = new XPportAnnotation();
            defAnnot.setNWTags(new String[]{"16,16"});
            defAnnot.setSW(new String[]{"Im:", "Se:"});
            defAnnot.setSWTags(new String[]{"32,19", "32,17"});
        }
        return defAnnot;
    }

    private void fillAnnotation(XPportAnnotation annot, String name) {
        String label;
        String tags = (String)this.props.get("ANNOT." + name + ".NWTags");
        if (tags != null) {
            annot.setNWTags(this.parseStrings(tags));
        }
        if ((label = (String)this.props.get("ANNOT." + name + ".NW")) != null) {
            annot.setNW(this.parseStrings(label));
        }
        if ((tags = (String)this.props.get("ANNOT." + name + ".SWTags")) != null) {
            annot.setSWTags(this.parseStrings(tags));
        }
        if ((label = (String)this.props.get("ANNOT." + name + ".SW")) != null) {
            annot.setSW(this.parseStrings(label));
        }
        if ((tags = (String)this.props.get("ANNOT." + name + ".SETags")) != null) {
            annot.setSETags(this.parseStrings(tags));
        }
        if ((label = (String)this.props.get("ANNOT." + name + ".SE")) != null) {
            annot.setSE(this.parseStrings(label));
        }
        if ((tags = (String)this.props.get("ANNOT." + name + ".NETags")) != null) {
            annot.setNETags(this.parseStrings(tags));
        }
        if ((label = (String)this.props.get("ANNOT." + name + ".NE")) != null) {
            annot.setNE(this.parseStrings(label));
        }
    }

    private String[] parseStrings(String str) {
        StringTokenizer st = new StringTokenizer(str, "^");
        String[] strs = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            strs[count++] = st.nextToken();
        }
        return strs;
    }
}

