/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XpSelector;
import com.ge.med.terra.xpv.ui.XPui;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class XPcomboPanel
extends JPanel {
    JPanel toolPanel = new JPanel();
    JPanel controlPanels = new JPanel();
    JPanel selectorPanel = new JPanel();
    XpSelector selector = new SimpleSelector();
    int numPanels;
    CardLayout controlPanelCards = new CardLayout(0, 0);
    String first = null;
    HashMap map = new HashMap();
    XPcaPanel shownPanel;

    public XPcomboPanel() {
        this(null, null);
    }

    public XPcomboPanel(Properties prop, XPcaPanel[] ctlPanels) {
        try {
            String sel = prop.getProperty("ctl.selector");
            if (sel != null) {
                Class<?> cl = Class.forName(sel);
                Constructor<?> ctor = cl.getConstructor(ctlPanels.getClass());
                if (ctor != null) {
                    this.selector = (XpSelector)ctor.newInstance(new Object[]{ctlPanels});
                } else {
                    this.getClass();
                    this.selector = (XpSelector)Class.forName(sel).newInstance();
                }
                this.selector.setProperties(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPcomboPanel.this.changeControlView();
            }
        });
        this.toolPanel.setBorder(PtkBorderFactory.createRaisedBorder());
        this.setBackground(XPui.p8());
        this.toolPanel.setBackground(null);
        this.controlPanels.setBackground(null);
        this.selectorPanel.setBackground(null);
        this.selector.setBackground(null);
        this.selector.setForeground(Color.white);
    }

    public void showPanel(String panelName) {
        this.selector.setSelectedItem(panelName);
    }

    private void changeControlView() {
        if (this.shownPanel != null) {
            this.shownPanel.panelStop();
        }
        String s = this.selector.getSelectedItem();
        this.controlPanelCards.show(this.controlPanels, s);
        this.shownPanel = (XPcaPanel)this.map.get(s);
        if (this.shownPanel == null) {
            return;
        }
        this.shownPanel.panelStart();
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(10, 10));
        this.toolPanel.setLayout(new BorderLayout());
        this.selectorPanel.setLayout(new BorderLayout());
        this.controlPanels.setLayout(this.controlPanelCards);
        this.selectorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.controlPanels.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.add((Component)this.toolPanel, "Center");
        this.toolPanel.add((Component)this.selectorPanel, "North");
        this.selectorPanel.add((Component)this.selector, "Center");
        this.toolPanel.add((Component)this.controlPanels, "Center");
    }

    public void addPanel(String title, XPcaPanel pan, Icon icon, String desc) {
        if (this.first == null) {
            this.first = pan.getClass().getName();
            this.controlPanelCards.show(this.controlPanels, this.first);
        }
        this.selector.addElement(pan, title, icon, desc);
        this.controlPanels.add((Component)pan, pan.getClass().getName());
        this.map.put(pan.getClass().getName(), pan);
    }

    public void setScreen(XPscreen screen) {
        this.selector.setScreen(screen);
    }

    static class SimpleSelector
    extends XpSelector {
        JComboBox cb = new JComboBox();
        DefaultComboBoxModel cbm = new DefaultComboBoxModel();
        Map nameMap = new HashMap();

        @Override
        public void setProperties(Properties prop) {
        }

        public SimpleSelector() {
            this.setLayout(new BorderLayout());
            this.add(this.cb);
            this.cb.setModel(this.cbm);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.cb.addActionListener(l);
        }

        @Override
        public void setSelectedItem(String name) {
            this.cbm.setSelectedItem(name);
        }

        @Override
        public String getSelectedItem() {
            return (String)this.nameMap.get(this.cb.getSelectedItem());
        }

        @Override
        public void addElement(XPcaPanel pan, String name, Icon icon, String desc) {
            this.cbm.addElement(name);
            this.nameMap.put(name, pan.getClass().getName());
        }

        @Override
        public void setSelectedApplication(String appName) {
        }
    }
}

