/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;

public class XPscreenLayout
implements Icon,
LayoutManager {
    private int noOfPorts;
    private Rectangle[] portDim;
    private String layout;
    public static final String _1X1LAYOUT = "[0,0,10000,10000]";
    public static final String _2X2LAYOUT = "[0,0,5000,5000][5000,0,5000,5000][0,5000,5000,5000][5000,5000,5000,5000]";
    public static final String _13LAYOUT = "[0,0,6666,9999][6667,0,3333,3333][6667,3334,3333,3333][6667,6667,3333,3333]";
    public static final String _31LAYOUT = "[3334,0,6666,9999][0,0,3333,3333][0,3334,3333,3333][0,6667,3333,3333]";
    public static final String _1X2LAYOUT = "[0,0,10000,5000][0,5000,10000,5000]";
    public static final String _1X3LAYOUT = "[0,0,10000,3333][0,3333,10000,3333][0,6666,10000,3333]";
    public static final String _2X1LAYOUT = "[0,0,5000,10000][5000,0,5000,10000]";
    public static final String _2X3LAYOUT = "[0,0,5000,3333][0,3333,5000,3333][0,6666,5000,3333][5000,0,5000,3333][5000,3333,5000,3333][5000,6666,5000,3333]";
    public static final String _3X1LAYOUT = "[0,0,3333,10000][3333,0,3333,10000][6666,0,3333,10000]";
    public static final String _3X2LAYOUT = "[0,0,3333,5000][3333,0,3333,5000][6666,0,3333,5000][0,5000,3333,5000][3333,5000,3333,5000][6666,5000,3333,5000]";
    public static final String _3X3LAYOUT = "[0,0,3333,3333][3333,0,3333,3333][6666,0,3333,3333][0,3333,3333,3333][3333,3333,3333,3333][6666,3333,3333,3333][0,6666,3333,3333][3333,6666,3333,3333][6666,6666,3333,3333]";
    public static final int SCALE = 10000;
    private int hgap_ = 0;
    private int vgap_ = 0;
    final int iconSize = 16;
    private String layoutString_;
    public static final String SPLIT_HORIZONTAL = "split_horizontal";
    public static final String SPLIT_VERTICAL = "split_vertical";
    public static final String MERGE_UP = "merge_up";
    public static final String MERGE_DOWN = "merge_down";
    public static final String MERGE_LEFT = "merge_left";
    public static final String MERGE_RIGHT = "merge_right";
    String layoutName_ = this.layoutString_;

    protected XPscreenLayout() {
        this(0, 0);
    }

    protected XPscreenLayout(int hgap, int vgap) {
        this(hgap, vgap, _1X1LAYOUT);
    }

    protected XPscreenLayout(int hgap, int vgap, String layoutString) {
        this.hgap_ = hgap;
        this.vgap_ = vgap;
        StringTokenizer st = new StringTokenizer(layoutString, ",][");
        this.portDim = new Rectangle[st.countTokens() / 4];
        int i = 0;
        while (st.hasMoreElements()) {
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int w = Integer.parseInt(st.nextToken());
            int h = Integer.parseInt(st.nextToken());
            this.portDim[i] = new Rectangle(x, y, w, h);
            ++i;
        }
        this.noOfPorts = i;
        this.layoutString_ = layoutString;
        this.setLayoutName(layoutString);
    }

    public XPscreenLayout(String str) {
        this(0, 0, str);
    }

    public static final XPscreenLayout layout1x1() {
        return new XPscreenLayout(_1X1LAYOUT);
    }

    public static final XPscreenLayout layout2x2() {
        return new XPscreenLayout(_2X2LAYOUT);
    }

    public static final XPscreenLayout layout1x2() {
        return new XPscreenLayout(_1X2LAYOUT);
    }

    public static final XPscreenLayout layout1x3() {
        return new XPscreenLayout(_1X3LAYOUT);
    }

    public static final XPscreenLayout layout13() {
        return new XPscreenLayout(_13LAYOUT);
    }

    public static final XPscreenLayout layout31() {
        return new XPscreenLayout(_31LAYOUT);
    }

    public static final XPscreenLayout layout2x1() {
        return new XPscreenLayout(_2X1LAYOUT);
    }

    public static final XPscreenLayout layout2x3() {
        return new XPscreenLayout(_2X3LAYOUT);
    }

    public static final XPscreenLayout layout3x1() {
        return new XPscreenLayout(_3X1LAYOUT);
    }

    public static final XPscreenLayout layout3x2() {
        return new XPscreenLayout(_3X2LAYOUT);
    }

    public static final XPscreenLayout layout3x3() {
        return new XPscreenLayout(_3X3LAYOUT);
    }

    public int getNoOfPorts() {
        return this.noOfPorts;
    }

    public void paintIcon(int w, int h, Graphics g, int offx, int offy) {
        g.setColor(Color.black);
        g.fillRect(offx, offy, w, h);
        g.setColor(Color.white);
        for (int i = 0; i < this.portDim.length; ++i) {
            g.drawRect(offx + this.portDim[i].x * w / 10000, offy + this.portDim[i].y * h / 10000, this.portDim[i].width * w / 10000, this.portDim[i].height * h / 10000);
        }
    }

    public void paintIcon(int w, int h, Graphics g, int offx, int offy, int num) {
        g.setColor(Color.black);
        g.fillRect(offx, offy, w, h);
        for (int i = 0; i < this.portDim.length; ++i) {
            if (i == num) {
                g.setColor(UIManager.getColor("P9"));
                g.fillRect(offx + this.portDim[i].x * w / 10000, offy + this.portDim[i].y * h / 10000, this.portDim[i].width * w / 10000, this.portDim[i].height * h / 10000);
                continue;
            }
            g.setColor(Color.white);
            g.drawRect(offx + this.portDim[i].x * w / 10000, offy + this.portDim[i].y * h / 10000, this.portDim[i].width * w / 10000, this.portDim[i].height * h / 10000);
        }
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintIcon(16, 16, g, x, y);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(1024, 1024);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            Component[] children = null;
            children = parent.getComponents();
            for (int i = 0; i < children.length; ++i) {
                children[i].setVisible(i < this.portDim.length);
                if (i >= this.portDim.length) continue;
                int qx = this.portDim[i].x * size.width;
                int qy = this.portDim[i].y * size.height;
                int qw = this.portDim[i].width * size.width;
                int qh = this.portDim[i].height * size.height;
                qw = (qw + qx) / 10000;
                qh = (qh + qy) / 10000;
                children[i].setBounds(new Rectangle(qx += insets.left, qy += insets.top, qw -= (qx /= 10000), qh -= (qy /= 10000)));
            }
        }
    }

    public String toString() {
        return XPscreenLayout.getLayoutName(this.layoutString_);
    }

    public String getLayout() {
        return this.getLayoutString();
    }

    public static String getLayoutName(String layoutString) {
        if (_1X1LAYOUT.equals(layoutString)) {
            return "1x1";
        }
        if (_1X2LAYOUT.equals(layoutString)) {
            return "1x2";
        }
        if (_2X1LAYOUT.equals(layoutString)) {
            return "2x1";
        }
        if (_2X2LAYOUT.equals(layoutString)) {
            return "2x2";
        }
        if (_13LAYOUT.equals(layoutString)) {
            return "1-3";
        }
        if (_31LAYOUT.equals(layoutString)) {
            return "3-1";
        }
        return "Custom";
    }

    public String getLayoutString() {
        return this.layoutString_;
    }

    public XPscreenLayout derive(String type, int portNo) {
        Vector neighbors = this.deriveNeighbor(type, portNo);
        if (neighbors.size() == 0) {
            return null;
        }
        if (SPLIT_HORIZONTAL.equals(type) || SPLIT_VERTICAL.equals(type)) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.noOfPorts; ++i) {
                if (portNo != i) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width + "," + this.portDim[i].height + "]");
                    continue;
                }
                if (SPLIT_HORIZONTAL.equals(type)) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width / 2 + "," + this.portDim[i].height + "][" + (this.portDim[i].x + this.portDim[i].width / 2) + "," + this.portDim[i].y + "," + (this.portDim[i].width - this.portDim[i].width / 2) + "," + this.portDim[i].height + "]");
                    continue;
                }
                if (!SPLIT_VERTICAL.equals(type)) continue;
                buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width + "," + this.portDim[i].height / 2 + "][" + this.portDim[i].x + "," + (this.portDim[i].y + this.portDim[i].height / 2) + "," + this.portDim[i].width + "," + (this.portDim[i].height - this.portDim[i].height / 2) + "]");
            }
            return new XPscreenLayout(this.hgap_, this.vgap_, buf.toString());
        }
        StringBuffer buf = new StringBuffer();
        int first = (Integer)neighbors.get(0);
        for (int i = 0; i < this.noOfPorts; ++i) {
            if (i == first) {
                if (SPLIT_HORIZONTAL.equals(type)) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width / 2 + "," + this.portDim[i].height + "][" + (this.portDim[i].x + this.portDim[i].width / 2) + "," + this.portDim[i].y + "," + (this.portDim[i].width - this.portDim[i].width / 2) + "," + this.portDim[i].height + "]");
                    continue;
                }
                if (SPLIT_VERTICAL.equals(type)) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width + "," + this.portDim[i].height / 2 + "][" + this.portDim[i].x + "," + (this.portDim[i].y + this.portDim[i].height / 2) + "," + this.portDim[i].width + "," + (this.portDim[i].height - this.portDim[i].height / 2) + "]");
                    continue;
                }
                if (MERGE_LEFT.equals(type)) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + (this.portDim[portNo].x - this.portDim[i].x + this.portDim[portNo].width) + "," + this.portDim[portNo].height + "]");
                    continue;
                }
                if (MERGE_RIGHT.equals(type)) {
                    buf.append("[" + this.portDim[portNo].x + "," + this.portDim[portNo].y + "," + (this.portDim[i].width + this.portDim[i].x - this.portDim[portNo].x) + "," + this.portDim[portNo].height + "]");
                    continue;
                }
                if (MERGE_UP.equals(type)) {
                    buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[portNo].width + "," + (this.portDim[i].height + this.portDim[portNo].height) + "]");
                    continue;
                }
                if (!MERGE_DOWN.equals(type)) continue;
                buf.append("[" + this.portDim[portNo].x + "," + this.portDim[portNo].y + "," + this.portDim[portNo].width + "," + (this.portDim[i].height + this.portDim[portNo].height) + "]");
                continue;
            }
            if (i == portNo || neighbors.contains(new Integer(i))) continue;
            buf.append("[" + this.portDim[i].x + "," + this.portDim[i].y + "," + this.portDim[i].width + "," + this.portDim[i].height + "]");
        }
        return new XPscreenLayout(this.hgap_, this.vgap_, buf.toString());
    }

    public final Vector deriveNeighbor(String type, int portNo) {
        int h;
        if (portNo < 0 || portNo >= this.noOfPorts) {
            throw new IllegalArgumentException("portNo must be between 0 and " + (this.noOfPorts - 1) + ": " + portNo);
        }
        Vector<Integer> v = new Vector<Integer>();
        if (SPLIT_HORIZONTAL.equals(type) || SPLIT_VERTICAL.equals(type)) {
            v.add(new Integer(portNo));
            return v;
        }
        System.out.println("XPscreenLayout.deriveNeighbor()" + this.portDim[portNo]);
        if (this.portDim[portNo].y == 0 && MERGE_UP.equals(type)) {
            System.err.println("nothing on top to merge");
            return v;
        }
        if (this.portDim[portNo].x == 0 && MERGE_LEFT.equals(type)) {
            System.err.println("nothing at left to merge");
            return v;
        }
        if (this.portDim[portNo].y + this.portDim[portNo].height >= 9999 && MERGE_DOWN.equals(type)) {
            System.err.println("nothing below to merge");
            return v;
        }
        if (this.portDim[portNo].x + this.portDim[portNo].width >= 9999 && MERGE_RIGHT.equals(type)) {
            System.err.println("nothing at right to merge");
            return v;
        }
        for (int i = 0; i < this.noOfPorts; ++i) {
            if (portNo == i) continue;
            if (MERGE_LEFT.equals(type)) {
                System.err.println("iiiii = " + i + ":" + this.portDim[i]);
                System.err.println("portno = " + portNo + ":" + this.portDim[portNo]);
            }
            if (MERGE_LEFT.equals(type) && this.portDim[i].y >= this.portDim[portNo].y && this.portDim[i].y + this.portDim[i].height <= this.portDim[portNo].y + this.portDim[portNo].height && this.portDim[i].x + this.portDim[i].width == this.portDim[portNo].x || this.portDim[i].x + this.portDim[i].width + 1 == this.portDim[portNo].x) {
                v.add(new Integer(i));
                continue;
            }
            if (MERGE_RIGHT.equals(type) && this.portDim[i].y >= this.portDim[portNo].y && this.portDim[i].y + this.portDim[i].height <= this.portDim[portNo].y + this.portDim[portNo].height && (this.portDim[portNo].x + this.portDim[portNo].width == this.portDim[i].x || this.portDim[portNo].x + this.portDim[portNo].width + 1 == this.portDim[i].x)) {
                v.add(new Integer(i));
                continue;
            }
            if (MERGE_UP.equals(type) && this.portDim[i].x >= this.portDim[portNo].x && this.portDim[i].x + this.portDim[i].width <= this.portDim[portNo].x + this.portDim[portNo].width && (this.portDim[i].y + this.portDim[i].height == this.portDim[portNo].y || this.portDim[i].y + this.portDim[i].height + 1 == this.portDim[portNo].y)) {
                v.add(new Integer(i));
                continue;
            }
            if (!MERGE_DOWN.equals(type) || this.portDim[i].x < this.portDim[portNo].x || this.portDim[i].x + this.portDim[i].width > this.portDim[portNo].x + this.portDim[portNo].width || this.portDim[portNo].y + this.portDim[portNo].height != this.portDim[i].y && this.portDim[portNo].y + this.portDim[portNo].height + 1 != this.portDim[i].y) continue;
            v.add(new Integer(i));
        }
        if (v.size() == 0) {
            System.err.println("nothing found for " + type);
            return v;
        }
        if (MERGE_LEFT.equals(type) || MERGE_RIGHT.equals(type)) {
            h = this.portDim[((Integer)v.get((int)0)).intValue()].height;
            int w = this.portDim[((Integer)v.get((int)0)).intValue()].width;
            for (int i = 1; i < v.size(); ++i) {
                if (w != this.portDim[((Integer)v.get((int)i)).intValue()].width) {
                    v.clear();
                    break;
                }
                h += this.portDim[((Integer)v.get((int)i)).intValue()].height;
            }
            if (v.size() > 0 && h != this.portDim[portNo].height) {
                v.clear();
            }
        } else if (MERGE_UP.equals(type) || MERGE_DOWN.equals(type)) {
            h = this.portDim[((Integer)v.get((int)0)).intValue()].height;
            int w = this.portDim[((Integer)v.get((int)0)).intValue()].width;
            for (int i = 1; i < v.size(); ++i) {
                if (h != this.portDim[((Integer)v.get((int)i)).intValue()].height) {
                    v.clear();
                    break;
                }
                w += this.portDim[((Integer)v.get((int)i)).intValue()].width;
            }
            if (v.size() > 0 && w != this.portDim[portNo].width) {
                v.clear();
            }
        }
        return v;
    }

    public final String getLayoutName() {
        return this.layoutName_;
    }

    public final void setLayoutName(String name) {
        this.layoutName_ = name;
    }
}

