/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.beanbox;

import com.ge.med.terra.xpv.beanbox.XPBeanBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class BeanWrapper
extends JPanel
implements MouseListener,
MouseMotionListener {
    private JComponent child;
    private Object bean;
    private transient Cursor cursor = XPBeanBox.defaultCursor;
    public Rectangle rect;
    private static final int borderWidth = 5;
    private static final int resizeDelta = 8;

    public JComponent getChild() {
        return this.child;
    }

    public BeanWrapper(Object bean) {
        this.bean = bean;
        this.setLayout(null);
        if (Beans.isInstanceOf(bean, Component.class)) {
            this.child = (JComponent)Beans.getInstanceOf(bean, Component.class);
        }
        this.add(this.child);
        this.child.setLocation(5, 5);
        this.attachListeners();
        this.setBackground(null);
    }

    private void disableChild(JComponent child) {
        if (child.getComponentCount() == 0) {
            child.setEnabled(false);
        } else if (child instanceof JList) {
            child.setEnabled(false);
        } else if (child instanceof JComboBox) {
            child.setEnabled(false);
        } else if (child instanceof JSlider) {
            child.setEnabled(false);
        } else if (child instanceof JScrollBar) {
            child.setEnabled(false);
        } else if (child instanceof JTextField) {
            child.setEnabled(false);
        } else {
            for (int i = 0; i < child.getComponentCount(); ++i) {
                this.disableChild((JComponent)child.getComponent(i));
            }
        }
    }

    private void enableChild(JComponent child) {
        if (child.getComponentCount() == 0) {
            child.setEnabled(true);
        } else if (child instanceof JList) {
            child.setEnabled(true);
        } else if (child instanceof JComboBox) {
            child.setEnabled(true);
        } else if (child instanceof JSlider) {
            child.setEnabled(true);
        } else if (child instanceof JScrollBar) {
            child.setEnabled(true);
        } else if (child instanceof JTextField) {
            child.setEnabled(true);
        } else {
            for (int i = 0; i < child.getComponentCount(); ++i) {
                this.enableChild((JComponent)child.getComponent(i));
            }
        }
    }

    void listenForMice(boolean enable) {
        if (enable) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.child.addMouseListener(this);
            this.child.addMouseMotionListener(this);
            this.disableChild(this.child);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.child.removeMouseListener(this);
            this.child.removeMouseMotionListener(this);
            this.enableChild(this.child);
        }
    }

    void removeListeners() {
        this.listenForMice(false);
    }

    void attachListeners() {
        this.listenForMice(true);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        width -= 10;
        Dimension minSize = this.child.getMinimumSize();
        if (minSize.height > (height -= 10)) {
            height = minSize.height;
        }
        if (minSize.width > width) {
            width = minSize.width;
        }
        Dimension maxSize = this.child.getMaximumSize();
        if (height > maxSize.height) {
            height = maxSize.height;
        }
        if (width > maxSize.width) {
            width = maxSize.width;
        }
        this.child.setBounds(5, 5, width, height);
        super.setBounds(x, y, width += 10, height += 10);
        this.child.validate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.doMouseStuff(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.doMouseStuff(e);
        this.getBeanBox().mouseMoved(e);
    }

    public synchronized void doMouseStuff(MouseEvent evt) {
        Container parent = this.getParent();
        int x = evt.getX();
        int y = evt.getY();
        int id = evt.getID();
        int lowX = 5;
        int highX = this.getSize().width - 5;
        int lowY = 5;
        int highY = this.getSize().height - 5;
        boolean control = 0 != (evt.getModifiers() & 2);
        boolean onTheBorder = evt.getSource() == this && (x < lowX || x > highX || y < lowY || y > highY);
        int centerX1 = this.getSize().width / 2 - 10;
        int centerX2 = this.getSize().width / 2 + 10;
        int centerY1 = this.getSize().height / 2 - 10;
        int centerY2 = this.getSize().height / 2 + 10;
        boolean onTheCenter = evt.getSource() == this.child && x < highX && x > lowX && y < highY && y > lowY;
        Cursor newCursor = XPBeanBox.defaultCursor;
        if (onTheBorder) {
            if (id == 501) {
                if (this.cursor == XPBeanBox.nwResizeCursor || this.cursor == XPBeanBox.swResizeCursor || this.cursor == XPBeanBox.neResizeCursor || this.cursor == XPBeanBox.seResizeCursor) {
                    this.getBeanBox().startResize(this, x, y, this.cursor);
                }
            } else if ((id == 504 || id == 503) && this.getBeanBox().selectedBeans.size() == 1) {
                highX -= 8;
                highY -= 8;
                if (x < (lowX += 8) && y < (lowY += 8)) {
                    newCursor = XPBeanBox.nwResizeCursor;
                } else if (x < lowX && y > highY) {
                    newCursor = XPBeanBox.swResizeCursor;
                } else if (x > highX && y < lowY) {
                    newCursor = XPBeanBox.neResizeCursor;
                } else if (x > highX && y > highY) {
                    newCursor = XPBeanBox.seResizeCursor;
                }
            }
        } else if (this.getBeanBox().selectedBeans.contains(this)) {
            if (id == 501) {
                newCursor = XPBeanBox.moveCursor;
                this.getBeanBox().startMove(this, x, y);
            } else if (id == 500 && control && this.getBeanBox().selectedBeans.size() > 0 && this.getBeanBox().selectedBeans.remove(this)) {
                this.repaint();
            }
        } else if (onTheCenter && id == 500) {
            if (control) {
                if (!this.getBeanBox().selectedBeans.remove(this)) {
                    this.getBeanBox().selectedBeans.add(this);
                }
            } else {
                this.getBeanBox().selectedBeans.clear();
                this.getBeanBox().repaint();
                this.getBeanBox().selectedBeans.add(this);
            }
            this.repaint();
        }
        if (newCursor != this.cursor) {
            this.cursor = newCursor;
            this.setCursor(this.cursor);
        }
    }

    public void paintEdges() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, 6, 6);
        g.fillRect(0, this.getHeight() - 6, 6, 6);
        g.fillRect(this.getWidth() - 6, this.getHeight() - 6, 6, 6);
        g.fillRect(this.getWidth() - 6, 0, 6, 6);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.getBeanBox().selectedBeans.contains(this)) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 6, 6);
            g.fillRect(0, this.getHeight() - 6, 6, 6);
            g.fillRect(this.getWidth() - 6, this.getHeight() - 6, 6, 6);
            g.fillRect(this.getWidth() - 6, 0, 6, 6);
        }
    }

    private XPBeanBox getBeanBox() {
        Container parent = this.getParent();
        if (parent instanceof XPBeanBox) {
            return (XPBeanBox)parent;
        }
        return null;
    }

    @Override
    public void doLayout() {
        Dimension d = this.getSize();
        Dimension cd = this.child.getMinimumSize();
        if (cd.width > d.width - 10 || cd.height > d.height - 10) {
            int width = d.width;
            if (cd.width > d.width - 10) {
                width = cd.width + 10;
            }
            int height = d.height;
            if (cd.height > d.height - 10) {
                height = cd.height + 10;
            }
            this.setSize(width, height);
        }
    }
}

