/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwAnnotRadioControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CustomAnnotationPanel;
import com.ge.med.terra.xpv.cuiPanels.LargeFontPanel;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.util.DisplayAnnotPrefUtils;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AnnotationPanel
extends XPcaAutoControlPanel {
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    private boolean dev_env = false;
    ActionListener customizeAnnot = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase(AnnotationPanel.CUSTOMIZE)) {
                AnnotationPanel.this.mainPanel.removeAll();
                AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.customPane, "Center");
                AnnotationPanel.this.customPane.setScreen(AnnotationPanel.this.screen_);
                AnnotationPanel.this.mainPanel.updateUI();
            }
        }
    };
    ActionListener largeFontListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase(AnnotationPanel.LARGE_FONT)) {
                AnnotationPanel.this.mainPanel.removeAll();
                AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.largeFontPane, "Center");
                AnnotationPanel.this.largeFontPane.setScreen(AnnotationPanel.this.screen_);
                AnnotationPanel.this.mainPanel.updateUI();
            }
        }
    };
    private PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("screen_annotation_level")) {
                String annotLevel = (String)evt.getNewValue();
                if (annotLevel == null) {
                    return;
                }
                if (annotLevel.equals("all")) {
                    AnnotationPanel.this.fullAnnot.setSelected(true);
                } else if (annotLevel.equals("partial")) {
                    AnnotationPanel.this.partialAnnot.setSelected(true);
                } else if (annotLevel.equals("custom")) {
                    AnnotationPanel.this.customAnnot.setSelected(true);
                } else {
                    AnnotationPanel.this.noAnnot.setSelected(true);
                }
            }
        }
    };
    XpDicomElement elem = new XpDicomElement(8, 96);
    String modality_ = "mr";
    ActionListener annotLevelChangeList = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            TransactionLogName tln = new TransactionLogName("TID=SD_annotationLevel_" + cmd);
            AnnotationPanel.this.logger.log(Level.FINEST, "{0} begin", tln);
            AnnotCapable annotPort = (AnnotCapable)AnnotationPanel.this.screen_.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
            if (annotPort == null) {
                AnnotationPanel.this.logger.log(Level.SEVERE, "{0} SEV5 Not AnnotCapable", tln);
                return;
            }
            if (!cmd.equals("custom")) {
                FactoryPreferenceCapble.getInstance().updateScreenAnnotationLevel(cmd);
                DisplayAnnotPrefUtils.setAnnotLevel(annotPort, cmd);
                annotPort.repaint();
            } else {
                AnnotationPanel.this.applyCustomAnnot();
            }
            AnnotationPanel.this.screen_.putClientProperty("screen_annotation_level", cmd);
            AnnotationPanel.this.logger.log(Level.FINEST, "{0} end", tln);
        }
    };
    ActionListener savePreference = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase(AnnotationPanel.SAVE)) {
                FactoryPreferenceCapble.getInstance().updatePrefs();
            }
        }
    };
    JPanel mainPanel = new JPanel(new BorderLayout());
    JPanel annotPane = new JPanel();
    XPwAnnotRadioControl noAnnot = new XPwAnnotRadioControl(res.getString("AnnotationPanel.NO_ANNOT_BUTTON"));
    XPwAnnotRadioControl fullAnnot = new XPwAnnotRadioControl(res.getString("AnnotationPanel.FULL_ANNOT_BUTTON"));
    XPwAnnotRadioControl partialAnnot = new XPwAnnotRadioControl(res.getString("AnnotationPanel.PARTIAL_ANNOT_BUTTON"));
    XPwAnnotRadioControl customAnnot = new XPwAnnotRadioControl(res.getString("AnnotationPanel.CUSTOM_ANNOT_BUTTON"));
    JButton customize = new JButton(res.getString("AnnotationPanel.CUSTOMIZE_BUTTON"));
    JButton largeFonts = new JButton("Large Font...");
    ButtonGroup bg = new ButtonGroup();
    JPanel saveSetting = new JPanel();
    JButton save = new JButton(res.getString("AnnotationPanel.SAVE_DEFAULT_BUTTON"));
    CustomAnnotationPanel customPane = new CustomAnnotationPanel();
    LargeFontPanel largeFontPane = new LargeFontPanel();
    JPanel masterPanel = new JPanel(new BorderLayout());
    private static final String CUSTOMIZE = "customize";
    private static final String SAVE = "save";
    private static final String LARGE_FONT = "large_font";
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public AnnotationPanel() {
        String val = System.getProperty("dev_env");
        if (val != null && val.equalsIgnoreCase("true")) {
            this.dev_env = true;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBackground(null);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.masterPanel, "Center");
        this.masterPanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.annotPane, "North");
        this.mainPanel.add((Component)this.saveSetting, "South");
        this.noAnnot.setFocusPainted(false);
        this.fullAnnot.setFocusPainted(false);
        this.partialAnnot.setFocusPainted(false);
        this.customAnnot.setFocusPainted(false);
        this.noAnnot.setActionCommand("none");
        this.fullAnnot.setActionCommand("all");
        this.partialAnnot.setActionCommand("partial");
        this.customAnnot.setActionCommand("custom");
        this.bg.add(this.noAnnot);
        this.bg.add(this.fullAnnot);
        this.bg.add(this.partialAnnot);
        this.bg.add(this.customAnnot);
        String annotLevel = FactoryPreferenceCapble.getInstance().getScreenAnnotationLevel();
        FactoryPreferenceCapble.getInstance();
        if (annotLevel.equalsIgnoreCase("none")) {
            this.noAnnot.setSelected(true);
        } else {
            FactoryPreferenceCapble.getInstance();
            if (annotLevel.equalsIgnoreCase("all")) {
                this.fullAnnot.setSelected(true);
            } else {
                FactoryPreferenceCapble.getInstance();
                if (annotLevel.equalsIgnoreCase("partial")) {
                    this.partialAnnot.setSelected(true);
                } else {
                    FactoryPreferenceCapble.getInstance();
                    if (annotLevel.equalsIgnoreCase("custom")) {
                        this.customAnnot.setSelected(true);
                    }
                }
            }
        }
        this.annotPane.setLayout(new GridBagLayout());
        this.annotPane.add((Component)this.fullAnnot, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.annotPane.add((Component)this.partialAnnot, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.annotPane.add((Component)this.noAnnot, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.annotPane.add((Component)this.customAnnot, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.annotPane.add((Component)this.customize, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        if (this.dev_env) {
            this.annotPane.add((Component)this.largeFonts, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(25, 3, 0, 3), 0, 0));
        }
        this.save.setActionCommand(SAVE);
        this.save.setPreferredSize(new Dimension(110, 35));
        this.saveSetting.add((Component)this.save, "Center");
        this.save.addActionListener(this.savePreference);
        this.customize.setActionCommand(CUSTOMIZE);
        this.customize.addActionListener(this.customizeAnnot);
        this.customPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("ok") || evt.getPropertyName().equalsIgnoreCase("cancel")) {
                    AnnotationPanel.this.mainPanel.remove(AnnotationPanel.this.customPane);
                    AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.annotPane, "North");
                    AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.saveSetting, "South");
                    AnnotationPanel.this.mainPanel.updateUI();
                }
                if (AnnotationPanel.this.customAnnot.isSelected()) {
                    System.out.println("AnnotationPanel.jbInit()");
                    AnnotationPanel.this.applyCustomAnnot();
                }
            }
        });
        this.largeFonts.setActionCommand(LARGE_FONT);
        this.largeFonts.addActionListener(this.largeFontListener);
        this.largeFontPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("ok") || evt.getPropertyName().equalsIgnoreCase("cancel")) {
                    AnnotationPanel.this.mainPanel.remove(AnnotationPanel.this.largeFontPane);
                    AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.annotPane, "North");
                    AnnotationPanel.this.mainPanel.add((Component)AnnotationPanel.this.saveSetting, "South");
                    AnnotationPanel.this.mainPanel.updateUI();
                }
            }
        });
    }

    @Override
    public void setScreen(XPscreen screen) {
        if (screen == null) {
            return;
        }
        this.screen_ = screen;
        this.screen_.removePropertyChangeListener(this.vpListener);
        this.screen_.addPropertyChangeListener(this.vpListener);
        String annotLevel = FactoryPreferenceCapble.getInstance().getScreenAnnotationLevel();
        if (annotLevel.equalsIgnoreCase("none")) {
            this.noAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("all")) {
            this.fullAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("partial")) {
            this.partialAnnot.setSelected(true);
        } else if (annotLevel.equalsIgnoreCase("custom")) {
            this.customAnnot.setSelected(true);
        }
    }

    public void applyCustomAnnot() {
        TransactionLogName tln = new TransactionLogName("TID=SD_annotationLevel_custom");
        XPutil.getLogger().log(Level.FINEST, "{0} begin", tln);
        AnnotCapable annotPort = (AnnotCapable)this.screen_.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
        if (this.screen_.getSelectedPort() instanceof XpCompositePort) {
            XpCompositePort disp = (XpCompositePort)this.screen_.getSelectedPort();
            XpFrameVisualizer vis = disp.getPort(0);
            vis.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        } else if (this.screen_.getSelectedPort() instanceof XpSingularPort) {
            XpSingularPort disp = (XpSingularPort)this.screen_.getSelectedPort();
            disp.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        }
        if (annotPort != null) {
            FactoryPreferenceCapble.getInstance().updateScreenAnnotationLevel("custom");
            DisplayAnnotPrefUtils.setCustomAnnotItems(annotPort, this.modality_, FactoryPreferenceCapble.getInstance().getScreenCustomAnnotationLevel());
            annotPort.repaint();
            XPutil.getLogger().log(Level.FINEST, "{0} end", tln);
        } else {
            XPutil.getLogger().log(Level.SEVERE, "{0} SEV5 Not AnnotCapable", tln);
        }
    }
}

