/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.FusionCapable;
import com.ge.med.terra.jami.SimpleAlphaCombiner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwColorMapList2;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.cuiPanels.DisplayColorModelUtils;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorMapPanel
extends XPcaAutoControlPanel
implements ChangeListener {
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    private HashMap cmapIndex = new HashMap();
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ColorMapCapable cmc;
            if (evt.getPropertyName().equals("colorMap")) {
                String cmap;
                ColorMapCapable cmc2 = (ColorMapCapable)ColorMapPanel.this.getCapable(ColorMapCapable.class.getName());
                if (!(cmc2 == null || (cmap = (String)((JComponent)((Object)cmc2)).getClientProperty("colorMap")) == null || ColorMapPanel.this.cmapList.getSelectedItem() != null && ((ColorMapLabel)ColorMapPanel.this.cmapList.getSelectedItem()).getColor().equals(cmap))) {
                    ColorMapPanel.this.cmapList.setSelectedItem(ColorMapPanel.this.cmapIndex.get(cmap));
                }
            } else if (evt.getPropertyName().equals("parent_port_changed") && (cmc = (ColorMapCapable)ColorMapPanel.this.getCapable(ColorMapCapable.class.getName())) != null) {
                ColorMapPanel.this.cmapList.removeActionListener(ColorMapPanel.this.cmapSelectionListener);
                String cmap = (String)((JComponent)((Object)cmc)).getClientProperty("colorMap");
                if (!(cmap == null || ColorMapPanel.this.cmapList.getSelectedItem() != null && ((ColorMapLabel)ColorMapPanel.this.cmapList.getSelectedItem()).getColor().equals(cmap))) {
                    ColorMapPanel.this.cmapList.setSelectedItem(ColorMapPanel.this.cmapIndex.get(cmap));
                } else if (cmap == null) {
                    ColorMapPanel.this.cmapList.setSelectedItem(ColorMapPanel.this.cmapIndex.get("none"));
                }
                ColorMapPanel.this.cmapList.addActionListener(ColorMapPanel.this.cmapSelectionListener);
            }
        }
    };
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    JPanel panel = new JPanel();
    JPanel subPanel = new JPanel();
    JLabel label = new JLabel();
    JComboBox cmapList = new JComboBox();
    Border border = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    JPanel alphaPanel = new JPanel();
    JSlider jsAlphaVal = new JSlider();
    Hashtable htLabel = new Hashtable();
    ActionListener cmapSelectionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object obj = ((JComboBox)ae.getSource()).getSelectedItem();
            if (obj instanceof ColorMapLabel) {
                String color = ((ColorMapLabel)obj).getColor();
                ColorMapPanel.this.applyColorMap(color);
            } else {
                ColorMapPanel.this.clearColorMap();
            }
        }
    };
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ColorMapPanel() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                System.out.println(".ancestorAdded()");
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                System.out.println(".ancestorRemoved()");
            }
        });
        this.setBackground(null);
        this.subTitlePanel.setTitle(res.getString("ColorMapPanel.title"));
        super.setTitle(res.getString("ColorMapPanel.title"));
        this.cmapList.setRenderer(new ComboBoxRenderer());
        this.cmapIndex.put("none", new ColorMapLabel("none"));
        this.cmapIndex.put("blue", new ColorMapLabel("blue"));
        this.cmapIndex.put("colder", new ColorMapLabel("colder"));
        this.cmapIndex.put("cool", new ColorMapLabel("cool"));
        this.cmapIndex.put("gray", new ColorMapLabel("gray"));
        this.cmapIndex.put("hot", new ColorMapLabel("hot"));
        this.cmapIndex.put("hotter", new ColorMapLabel("hotter"));
        this.cmapIndex.put("isocontour", new ColorMapLabel("isocontour"));
        this.cmapIndex.put("prism", new ColorMapLabel("prism"));
        this.cmapIndex.put("rainbow", new ColorMapLabel("rainbow"));
        this.cmapIndex.put("thermal", new ColorMapLabel("thermal"));
        this.cmapList.addItem(this.cmapIndex.get("none"));
        this.cmapList.addItem(this.cmapIndex.get("blue"));
        this.cmapList.addItem(this.cmapIndex.get("colder"));
        this.cmapList.addItem(this.cmapIndex.get("cool"));
        this.cmapList.addItem(this.cmapIndex.get("gray"));
        this.cmapList.addItem(this.cmapIndex.get("hot"));
        this.cmapList.addItem(this.cmapIndex.get("hotter"));
        this.cmapList.addItem(this.cmapIndex.get("isocontour"));
        this.cmapList.addItem(this.cmapIndex.get("prism"));
        this.cmapList.addItem(this.cmapIndex.get("rainbow"));
        this.cmapList.addItem(this.cmapIndex.get("thermal"));
        this.cmapList.setInputMap(1, new InputMap());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setIcon(CuiPanelUtils.getIcon("COLORMAP_ICO"));
        this.panel.setLayout(new BorderLayout());
        this.subPanel.setLayout(new BorderLayout());
        this.label.setBorder(this.border);
        this.label.setText(res.getString("ColorMapPanel.colormap_text"));
        this.subTitlePanel.setLayout(new GridBagLayout());
        this.cmapList.setPreferredSize(new Dimension(24, 28));
        this.panel.add((Component)this.subPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.subTitlePanel, "Center");
        this.subPanel.add((Component)this.label, "Center");
        this.subPanel.add((Component)this.cmapList, "South");
        this.subTitlePanel.add(new XPwColorMapList2());
        this.cmapList.addActionListener(this.cmapSelectionListener);
        this.htLabel.put(new Integer(0), new JLabel("Anatomy"));
        this.htLabel.put(new Integer(100), new JLabel("Processed"));
        this.jsAlphaVal.setLabelTable(this.htLabel);
        this.jsAlphaVal.setPaintLabels(true);
        this.alphaPanel.add(this.jsAlphaVal);
        this.jsAlphaVal.addChangeListener(this);
        this.jsAlphaVal.setVisible(false);
        FusionCapable fc = (FusionCapable)this.getCapable(FusionCapable.class.getName());
        if (fc == null) {
            return;
        }
        this.jsAlphaVal.setVisible(fc.getPixelCombiner() instanceof SimpleAlphaCombiner);
    }

    @Override
    public void setScreen(XPscreen screen) {
        if (screen == null) {
            return;
        }
        super.setScreen(screen);
        this.getScreen().removePropertyChangeListener(this.viewPortListener);
        this.getScreen().addPropertyChangeListener(this.viewPortListener);
        this.cmapList.removeActionListener(this.cmapSelectionListener);
        JComponent selectedPort = this.screen_.getSelectedPort();
        if (selectedPort != null && selectedPort.getClientProperty("colorMap") != null) {
            this.cmapList.setSelectedItem(this.cmapIndex.get(selectedPort.getClientProperty("colorMap")));
        }
        this.cmapList.addActionListener(this.cmapSelectionListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        FusionCapable fc = (FusionCapable)this.getCapable(FusionCapable.class.getName());
        if (fc == null) {
            return;
        }
        this.jsAlphaVal.setVisible(fc.getPixelCombiner() instanceof SimpleAlphaCombiner);
    }

    private void applyColorMap(String color) {
        TransactionLogName tln = new TransactionLogName("TID=SD_colorMap_" + color);
        this.logger.log(Level.FINEST, "{0} begin", tln);
        ColorMapCapable cmc = (ColorMapCapable)this.getCapable(ColorMapCapable.class.getName());
        if (cmc != null) {
            ((JComponent)((Object)cmc)).putClientProperty("colorMap", color);
            DisplayColorModelUtils.applyColorMap(cmc, color);
            this.logger.log(Level.FINEST, "{0} end", tln);
        } else {
            this.logger.log(Level.SEVERE, "{0} SEV5 Not ColorMapCapable", tln);
        }
    }

    private void clearColorMap() {
        TransactionLogName tln = new TransactionLogName("TID=SD_colorMap_None");
        this.logger.log(Level.FINEST, "{0} begin", tln);
        ColorMapCapable cmc = (ColorMapCapable)this.getCapable(ColorMapCapable.class.getName());
        if (cmc != null) {
            ((JComponent)((Object)cmc)).putClientProperty("colorMap", "none");
            DisplayColorModelUtils.unapplyColorMap(cmc);
            this.logger.log(Level.FINEST, "{0} end", tln);
        } else {
            this.logger.log(Level.SEVERE, "{0} SEV5 Not ColorMapCapable", tln);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        FusionCapable fc = (FusionCapable)this.getCapable(FusionCapable.class.getName());
        if (fc != null && fc.getPixelCombiner() instanceof SimpleAlphaCombiner) {
            int val = this.jsAlphaVal.getValue();
            double dval = (double)val / (double)this.jsAlphaVal.getMaximum();
            ((SimpleAlphaCombiner)fc.getPixelCombiner()).setAlpha(dval);
            fc.repaint();
        }
    }

    public class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(10);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(UIManager.getColor("P8"));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(UIManager.getColor("P7"));
                this.setForeground(list.getForeground());
            }
            if (value instanceof ColorMapLabel) {
                ColorMapLabel label = (ColorMapLabel)value;
                this.setText(label.getColor());
                this.setIcon(label);
            } else if (value instanceof String) {
                this.setText((String)value);
                this.setIcon(null);
            }
            return this;
        }
    }

    public class ColorMapLabel
    implements Icon,
    SwingConstants {
        int[] cmap;
        String color;

        public ColorMapLabel(String color) {
            this.cmap = XPutil.getColorTable(color);
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        @Override
        public int getIconWidth() {
            return 50;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.cmap == null || this.cmap.length == 0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.black);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.translate(x + 5, y);
            int w = this.getIconWidth();
            int h = this.getIconHeight() - 7;
            for (int i = 0; i < w; ++i) {
                int cc = 1000 * (w - i - 1) / w;
                g.setColor(new Color(this.cmap[this.cmap.length * cc / 1000]));
                g.fillRect(i, 3, 1, h);
            }
        }
    }
}

