/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.ui.PaletteComboButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;

public class CuiControlPanel
extends JPanel {
    Properties uiProperties = new Properties();
    static final String CONTROL_TAB_PROPERTY = "controltabs";
    static final String SEPARATOR = ".";
    static final String COUNT_PROPERTY = "count";
    int numTabs = 0;
    JPanel[] cardPanels;
    private CardLayout[] cardLayouts;

    public CuiControlPanel() {
        try {
            this.uiProperties.load(this.getClass().getResourceAsStream("SampleCuiTabs.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.load(this.uiProperties);
    }

    private void load(Properties p) {
        this.numTabs = Integer.parseInt(p.getProperty("controltabs.count"));
        this.setBackground(UIManager.getColor("P10"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setPreferredSize(new Dimension(378, 400));
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBackground(UIManager.getColor("P9"));
        tabs.setForeground(Color.WHITE);
        tabs.setOpaque(false);
        this.cardPanels = new JPanel[this.numTabs];
        this.cardLayouts = new CardLayout[this.numTabs];
        for (int i = 0; i < this.numTabs; ++i) {
            final int tabIndex = i;
            ButtonGroup bg = new ButtonGroup();
            this.cardLayouts[i] = new CardLayout();
            this.cardPanels[i] = new JPanel(this.cardLayouts[i]);
            this.cardPanels[i].add((Component)new JPanel(), "dummy");
            JPanel ctrl = new JPanel(new BorderLayout());
            tabs.addTab(p.getProperty("controltabs." + i + SEPARATOR + "name"), ctrl);
            tabs.setForegroundAt(i, UIManager.getColor("P5"));
            String buttonDimString = p.getProperty("controltabs." + i + SEPARATOR + "dimension");
            String[] dims = buttonDimString.trim().split("x");
            int dx = Integer.parseInt(dims[0]);
            int dy = Integer.parseInt(dims[1]);
            JPanel buttonPanel = new JPanel(new GridLayout(dy, dx));
            System.out.println("CuiControlPanel.load(): dx = " + dx + ", dy = " + dy);
            for (int row = 0; row < dy; ++row) {
                for (int col = 0; col < dx; ++col) {
                    final String prefix = "controltabs." + i + SEPARATOR + col + SEPARATOR + row;
                    String cellCountString = p.getProperty(prefix + SEPARATOR + COUNT_PROPERTY);
                    if (cellCountString != null) {
                        System.out.println("cell count for tab " + i + " @(" + col + ", " + row + ") = " + cellCountString);
                        int cellCount = Integer.parseInt(cellCountString.trim());
                        Object[] buttons = new AbstractButton[cellCount];
                        for (int itemIndex = 0; itemIndex < cellCount; ++itemIndex) {
                            String cellComponentString = p.getProperty(prefix + SEPARATOR + itemIndex);
                            System.out.println(prefix + SEPARATOR + itemIndex + " = " + cellComponentString);
                            try {
                                Class<?> cl = Class.forName(cellComponentString);
                                Object o = cl.newInstance();
                                if (o instanceof AbstractAction) {
                                    JButton ab = new JButton((AbstractAction)o);
                                    if (ab.getIcon() != null) {
                                        ab.setText("");
                                        ab.setPressedIcon(ab.getIcon());
                                    }
                                    buttons[itemIndex] = ab;
                                } else {
                                    buttons[itemIndex] = new JButton();
                                }
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                            catch (InstantiationException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            if (buttons[itemIndex] != null) continue;
                            buttons[itemIndex] = new JButton();
                        }
                        PaletteComboButton combo = new PaletteComboButton(buttons);
                        buttonPanel.add(combo);
                        continue;
                    }
                    final String componentString = p.getProperty(prefix);
                    if (componentString != null) {
                        System.out.println(prefix + " = " + componentString);
                        try {
                            Class<?> cl = Class.forName(componentString);
                            Object o = cl.newInstance();
                            if (o instanceof AbstractAction) {
                                JButton b = new JButton((Action)o);
                                b.setText("");
                                buttonPanel.add(b);
                                continue;
                            }
                            if (!(o instanceof XPcaPanel)) continue;
                            XPcaPanel cap = (XPcaPanel)o;
                            Icon ico = cap.getIcon();
                            String text = cap.getName();
                            JToggleButton trigger = ico != null ? new JToggleButton(cap.getIcon()) : new JToggleButton(text);
                            buttonPanel.add(trigger);
                            bg.add(trigger);
                            this.cardPanels[i].add((Component)cap, prefix + "-" + componentString);
                            trigger.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CuiControlPanel.this.cardLayouts[tabIndex].show(CuiControlPanel.this.cardPanels[tabIndex], prefix + "-" + componentString);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            buttonPanel.add(new JLabel());
                        }
                        continue;
                    }
                    buttonPanel.add(new JLabel());
                }
            }
            ctrl.add((Component)buttonPanel, "North");
            ctrl.add((Component)this.cardPanels[i], "Center");
            this.cardLayouts[i].show(this.cardPanels[i], "dummy");
        }
        this.add(tabs);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        UIManager.getLookAndFeelDefaults().put("PaletteComboBoxUI", "com.ge.med.terra.xpv.ui.CuiPaletteComboBoxUI");
        JFrame f = new JFrame();
        f.setContentPane(new CuiControlPanel());
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    class ControlPane
    extends JPanel {
        JPanel buttonPanel = new JPanel(new GridLayout());

        public ControlPane() {
            this.setLayout(new BorderLayout());
        }
    }
}

