/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.filter.XpImageLut;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.image.IndexColorModel;

public class DisplayColorModelUtils {
    public static final String BLUE = "blue";
    public static final String COLDER = "colder";
    public static final String COOL = "cool";
    public static final String GRAY = "gray";
    public static final String HOT = "hot";
    public static final String HOTTER = "hotter";
    public static final String ISOCONTOUR = "isocontour";
    public static final String PRISM = "prism";
    public static final String RAINBOW = "rainbow";
    public static final String THERMAL = "thermal";
    public static final String NONE = "none";
    public static final String G1 = "g1";
    public static final String G2 = "g2";
    public static final String G3 = "g3";

    public static boolean applyGSE_G1(XpImageRenderAttributesOwner irao) {
        IndexColorModel indexModel = XpImageLut.g1().getLUT();
        if (irao == null || indexModel == null) {
            return false;
        }
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        ira.setColormap(indexModel);
        irao.setImageRenderAttributes(ira);
        return true;
    }

    public static boolean applyGSE_G2(XpImageRenderAttributesOwner irao) {
        IndexColorModel indexModel = XpImageLut.g2().getLUT();
        if (irao == null || indexModel == null) {
            return false;
        }
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        ira.setColormap(indexModel);
        irao.setImageRenderAttributes(ira);
        return true;
    }

    public static boolean applyGSE_G3(XpImageRenderAttributesOwner irao) {
        IndexColorModel indexModel = XpImageLut.g3().getLUT();
        if (irao == null || indexModel == null) {
            return false;
        }
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        ira.setColormap(indexModel);
        irao.setImageRenderAttributes(ira);
        return true;
    }

    public static boolean unapplyGSE(XpImageRenderAttributesOwner irao) {
        if (irao == null) {
            return false;
        }
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        ira.clearColorMap();
        irao.setImageRenderAttributes(ira);
        return true;
    }

    public static boolean applyColorMap(XpImageRenderAttributesOwner irao, String cMapName) {
        int[] cMap = XPutil.getColorTable(cMapName);
        if (irao == null || cMap == null) {
            return false;
        }
        LutIndexColorModel indexModel = new LutIndexColorModel(cMapName, cMap);
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        ira.setColormap(indexModel);
        irao.setImageRenderAttributes(ira);
        return true;
    }

    public static boolean applyColorMap(ColorMapCapable colorMapCapable, String cMapName) {
        if (colorMapCapable == null || cMapName == null) {
            return false;
        }
        if (NONE.equalsIgnoreCase(cMapName)) {
            return DisplayColorModelUtils.unapplyColorMap(colorMapCapable);
        }
        int[] colorMap = XPutil.getColorTable(cMapName);
        if (colorMap == null) {
            return false;
        }
        colorMapCapable.setColorMap(XPutil.getColorTable(cMapName));
        return true;
    }

    public static boolean unapplyColorMap(ColorMapCapable colorMapCapable) {
        if (colorMapCapable == null) {
            return false;
        }
        colorMapCapable.setColorMap(null);
        return true;
    }

    public static boolean setInverseVideo(WindowLevelCapable wlc, boolean isInverted) {
        if (wlc == null) {
            return false;
        }
        wlc.setVideoInverted(isInverted);
        return true;
    }

    private static class LutIndexColorModel
    extends IndexColorModel {
        private String lutName = "";
        private int hash = 0;

        public LutIndexColorModel(String lutName, int[] rgbs) {
            super(16, rgbs.length, rgbs, 0, false, -1, 1);
            this.lutName = lutName;
            this.hash = rgbs.hashCode();
        }

        @Override
        public final String toString() {
            return this.lutName;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }
    }
}

