/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.xpv.jfc.FilmPage;
import com.ge.med.terra.xpv.jfc.JavaFilmComposer;
import com.ge.med.terra.xpv.jfc.JavaFilmPage;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFCFilm {
    JavaFilmComposer filmComposer;
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();
    private final int ImageSize = 512;
    File filmDir = null;

    public JFCFilm(JavaFilmComposer fc) {
        this.filmComposer = fc;
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            this.filmDir = new File(userHome + File.separator + "film");
            if (!this.filmDir.exists()) {
                this.filmDir.mkdir();
            }
        }
    }

    public void film() {
        if (this.filmDir == null || this.filmComposer.defaultPrinterSetting == null) {
            return;
        }
        LinkedList pageList = this.filmComposer.pageList;
        Iterator it = pageList.iterator();
        final Vector<String> filmJobs = new Vector<String>();
        while (it.hasNext()) {
            File jobDir = null;
            try {
                jobDir = File.createTempFile("job", "", this.filmDir);
                jobDir.delete();
                jobDir.mkdir();
                filmJobs.add(jobDir.getAbsolutePath());
                JavaFilmPage cPage = this.filmComposer.getJavaFilmPage((FilmPage)it.next());
                Vector vec = cPage.getImages();
                System.err.println("making directory===" + jobDir.getAbsolutePath() + "numImages===" + vec.size());
                for (int i = 0; i < vec.size(); ++i) {
                    JavaFilmPage singlePage = new JavaFilmPage(this.filmComposer, 1, 1);
                    BufferedImage img = (BufferedImage)vec.get(i);
                    if (img == null) continue;
                    singlePage.addImage(img, null, 0, 0);
                    singlePage.setPreferredSize(new Dimension(this.ImageSize, 512));
                    this.jf.setContentPane(singlePage);
                    this.jf.pack();
                    BufferedImage bi = new BufferedImage(512, 512, 5);
                    Paper pp = new Paper();
                    pp.setSize(512.0, 512.0);
                    pp.setImageableArea(0.0, 0.0, 512.0, 512.0);
                    PageFormat pf = new PageFormat();
                    pf.setPaper(pp);
                    singlePage.print(bi.getGraphics(), pf, 0);
                    this.writeImageFiles(jobDir + File.separator + "FCImage" + Integer.toString(i), bi);
                    this.jf.setContentPane(this.jp);
                }
                this.writeJobFile(jobDir.getAbsolutePath(), cPage.getRow(), cPage.getCol());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        new Thread(){

            @Override
            public void run() {
                Iterator it = filmJobs.iterator();
                while (it.hasNext()) {
                    JFCFilm.this.filmComposer.filmJob.put((String)it.next());
                }
            }
        }.start();
    }

    private void writeJobFile(String directory, int row, int col) {
        try {
            File dir = new File(directory);
            File[] list = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".r");
                }
            });
            File jobFile = new File(directory + File.separator + "jobFile");
            if (jobFile.exists()) {
                jobFile.delete();
            }
            jobFile.createNewFile();
            PrintStream pw = new PrintStream(new FileOutputStream(jobFile));
            pw.println("DESTINATION " + this.filmComposer.defaultPrinterSetting.getAbsolutePath());
            pw.println("ICOUNT " + list.length);
            pw.println("COPIES 1");
            pw.println("WIDTH 512");
            pw.println("HEIGHT 512");
            pw.println("DEPTH 8");
            pw.println("ZOOM 0.000000");
            pw.println("SLIDE OFF");
            pw.println("GREYSCALE OFF");
            for (int i = 0; i < list.length; ++i) {
                pw.println("IMAGE " + list[i].getAbsolutePath());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.filmComposer.defaultPrinterSetting)));
            String line = br.readLine();
            String AEtitle = null;
            String hostName = null;
            while (line != null) {
                if (line.startsWith("#")) continue;
                if (line.indexOf("AppTitle") >= 0) {
                    AEtitle = line.substring(line.indexOf(34), line.lastIndexOf(34));
                } else if (line.indexOf("HostName") >= 0) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    hostName = st.nextToken();
                }
                pw.println(line);
                line = br.readLine();
            }
            br.close();
            pw.println("FORMAT " + Integer.toString(row) + "x" + Integer.toString(col) + "_fid");
            if (AEtitle != null) {
                pw.println("AET " + AEtitle);
            }
            if (hostName != null) {
                pw.println("HOST " + hostName);
            }
            pw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeImageFiles(String fileName, BufferedImage image) {
        switch (image.getType()) {
            case 10: {
                this.writeByteImage(fileName, image);
                break;
            }
            case 1: 
            case 2: {
                this.writeIntImage(fileName, image);
                break;
            }
            case 5: {
                this.write3ByteBGR(fileName, image);
                break;
            }
        }
    }

    private void writeByteImage(String fileName, BufferedImage bi) {
        DataBufferByte dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] data = dbb.getData();
        this.writeBytes(fileName, data);
    }

    private void writeIntImage(String fileName, BufferedImage bi) {
        DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        int[] data = dbi.getData();
        this.writeRGB(fileName, data);
    }

    private void write3ByteBGR(String fileName, BufferedImage bi) {
        DataBufferByte dbi = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] bb = dbi.getData();
        for (int i = 0; i < bb.length; i += 3) {
            byte t = bb[i];
            bb[i] = bb[i + 2];
            bb[i + 2] = t;
        }
        this.writeRGB(fileName, bb);
    }

    private void writeRGB(String fileName, byte[] data) {
        try {
            int val;
            int i;
            byte[] idata = new byte[data.length / 3];
            File file = new File(fileName + ".r");
            FileImageOutputStream fos = new FileImageOutputStream(file);
            int count = 0;
            for (i = 0; i < data.length; i += 3) {
                val = data[i] & 0xFF;
                idata[count] = (byte)val;
                ++count;
            }
            fos.write(idata);
            fos.close();
            file = new File(fileName + ".g");
            fos = new FileImageOutputStream(file);
            count = 0;
            for (i = 0; i < data.length; i += 3) {
                val = data[i + 1] & 0xFF;
                idata[count++] = (byte)val;
            }
            fos.write(idata);
            fos.close();
            file = new File(fileName + ".b");
            fos = new FileImageOutputStream(file);
            count = 0;
            for (i = 0; i < data.length; i += 3) {
                val = data[i] + 2 & 0xFF;
                idata[count] = (byte)val;
                ++count;
            }
            fos.write(idata);
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeRGB(String fileName, int[] data) {
        try {
            int val;
            int i;
            byte[] idata = new byte[data.length];
            File file = new File(fileName + ".r");
            FileImageOutputStream fos = new FileImageOutputStream(file);
            for (i = 0; i < data.length; ++i) {
                val = data[i] >> 16 & 0xFF;
                idata[i] = (byte)val;
            }
            fos.write(idata);
            fos.close();
            file = new File(fileName + ".g");
            fos = new FileImageOutputStream(file);
            for (i = 0; i < data.length; ++i) {
                val = data[i] >> 8 & 0xFF;
                idata[i] = (byte)val;
            }
            fos.write(idata);
            fos.close();
            file = new File(fileName + ".b");
            fos = new FileImageOutputStream(file);
            for (i = 0; i < data.length; ++i) {
                val = data[i] & 0xFF;
                idata[i] = (byte)val;
            }
            fos.write(idata);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeBytes(String fileName, byte[] data) {
        try {
            if (fileName.trim().length() == 0) {
                return;
            }
            File file = new File(fileName);
            FileImageOutputStream fos = new FileImageOutputStream(file);
            fos.write(data);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

