/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.er.EREvent;
import com.ge.med.terra.tap.util.er.EREventListener;
import com.ge.med.terra.tap.util.er.EventRouter;
import com.ge.med.terra.xpv.jfc.FilmPage;
import com.ge.med.terra.xpv.jfc.JFCCameraConfig;
import com.ge.med.terra.xpv.jfc.JFCCameraPreConfig;
import com.ge.med.terra.xpv.jfc.JFCFTPpanel;
import com.ge.med.terra.xpv.jfc.JFCFilm;
import com.ge.med.terra.xpv.jfc.JFCFilmQueue;
import com.ge.med.terra.xpv.jfc.JFCImageQualityParam;
import com.ge.med.terra.xpv.jfc.JFCPrinter;
import com.ge.med.terra.xpv.jfc.JavaFilmPage;
import com.ge.med.terra.xpv.ui.XPui;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JavaFilmComposer
extends JPanel {
    LinkedList pageList = new LinkedList();
    static EventRouter er;
    FileOutputStream pageOutputStream;
    FileInputStream pageInputStream;
    dicomParser dp = new dicomParser();
    JavaFilmPage currentPage;
    JFrame parent;
    public JFCPrinter printer;
    public JFCCameraPreConfig preConfig;
    public JFCCameraConfig cameraConfig;
    public JFCImageQualityParam advConfig;
    public JFCFTPpanel ftpConfig;
    public JFCFilmQueue filmQueue;
    public File defaultPrinterSetting = null;
    XpComponentSave sv = new XpComponentSave();
    DefaultListModel listModel = new DefaultListModel();
    public FilmJob filmJob = new FilmJob();
    public static Border selectedBorder;
    public static final String MAIN_PANEL = "mainPanel";
    public static final String REMOTE_PRINTERS = "remotePrinters";
    public static final String PRE_CONFIGURE = "preConfigure";
    public static final String PRINTER_SETTING = "printerSetting";
    public static final String ADVANCED_SETTING = "advancedSetting";
    public static final String Export_SETTING = "exportSetting";
    public static final String FILM_QUEUE = "filmQueue";
    public String activeFilmJob = null;
    File pageFile;
    File tempPageFile;
    boolean changeList = true;
    FilmPage currentFilmPage;
    JPanel jPanel11 = new JPanel();
    JButton jBFilmQueue = new JButton();
    JPanel jPanel4 = new JPanel();
    JButton jBSave = new JButton();
    JComboBox jcomboLayout = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JButton jBFullScreen = new JButton();
    GridLayout gridLayout4 = new GridLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton jBPrintSetting = new JButton();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel10 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JButton jB2x2 = new JButton();
    JButton jbHide = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel5 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton jB3x3 = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JavaFilmPage newPage;
    JButton jB1x1 = new JButton();
    JButton jB4x4 = new JButton();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel1 = new JPanel();
    JButton jBDeletePage = new JButton();
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JButton jBDeleteAll = new JButton();
    JButton jBExportData = new JButton();
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    CardLayout cardLayout1 = new CardLayout();
    DefaultComboBoxModel cbModel = new DefaultComboBoxModel();
    JButton jBPrint = new JButton();
    JTextField jTextField1 = new JTextField();
    JPanel jPanel12 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    DroppableList jList1 = new DroppableList();
    public boolean rowColChange = true;

    public JavaFilmComposer(JFrame parent) {
        this.parent = parent;
        this.init();
    }

    public JavaFilmComposer() {
        this.init();
        this.jbHide.setEnabled(false);
        this.jBFullScreen.setEnabled(false);
    }

    public void setFrame(JFrame parent) {
        this.parent = parent;
        this.jbHide.setEnabled(true);
        this.jBFullScreen.setEnabled(true);
    }

    private void init() {
        File FilmDir;
        this.newPage = new JavaFilmPage(this);
        this.printer = new JFCPrinter(this);
        this.preConfig = new JFCCameraPreConfig(this);
        this.cameraConfig = new JFCCameraConfig(this);
        this.advConfig = new JFCImageQualityParam(this);
        this.ftpConfig = new JFCFTPpanel(this);
        this.filmQueue = new JFCFilmQueue(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jList1.setModel(this.listModel);
        this.jList1.setLayoutOrientation(2);
        this.jList1.setVisibleRowCount(1);
        this.jList1.setCellRenderer(new MyListCellRenderer());
        this.jList1.setSelectionMode(0);
        this.jbHide.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.jBFullScreen.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.jB1x1.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.jB4x4.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.jB2x2.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.jB3x3.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.jBDeleteAll.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.jBDeletePage.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.jTextField1.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.jBPrintSetting.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.jBFilmQueue.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.jBSave.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.jBExportData.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.jBPrint.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.jTextField1.setText("1/1");
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = System.getProperty("user.dir");
        }
        if (!(FilmDir = new File(userHome, "jfc")).exists()) {
            return;
        }
        this.pageFile = new File(FilmDir, "pageFile");
        this.tempPageFile = new File(FilmDir, "tempPageFile");
        this.loadPages();
        this.setupEvents();
        this.jcomboLayout.setRenderer(new MyCellRenderer());
        this.updateRowColButtons();
        this.obtainDefaultPrinterDev();
    }

    private void loadPages() {
        int currentPageIndex = this.readPages();
        this.updateCurrentPage(this.currentFilmPage, currentPageIndex);
    }

    private void obtainDefaultPrinterDev() {
        File devDir;
        File appdir;
        String dir = System.getProperty("user.home");
        if (dir != null && (appdir = new File(dir, "app-defaults")).isDirectory() && (devDir = new File(appdir, "devices")).isDirectory()) {
            File[] devList = devDir.listFiles();
            for (int i = 0; i < devList.length; ++i) {
                if (!devList[i].getAbsolutePath().endsWith("dev")) continue;
                this.defaultPrinterSetting = devList[i];
                break;
            }
        }
    }

    private void writePages() {
        try {
            if (this.tempPageFile.exists()) {
                this.tempPageFile.delete();
            }
            this.tempPageFile.createNewFile();
            this.pageOutputStream = new FileOutputStream(this.pageFile);
            PrintStream pw = new PrintStream(this.pageOutputStream);
            pw.println(this.pageList.indexOf(this.currentFilmPage));
            pw.println(this.pageList.size());
            for (int i = 0; i < this.pageList.size(); ++i) {
                ((FilmPage)this.pageList.get(i)).writeThis(pw);
            }
            this.pageOutputStream.close();
            this.tempPageFile.renameTo(this.pageFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updatePageList();
    }

    private void printPages() {
        Iterator it = this.pageList.iterator();
        int pageNum = 0;
        while (it.hasNext()) {
            System.err.println("printing " + pageNum);
            ((FilmPage)it.next()).print();
            ++pageNum;
        }
    }

    private int readPages() {
        int currentPageIndex = -1;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.pageFile)));
            this.pageList.clear();
            currentPageIndex = Integer.parseInt(br.readLine());
            int numPages = Integer.parseInt(br.readLine());
            this.changeList = false;
            this.listModel.clear();
            for (int i = 0; i < numPages; ++i) {
                FilmPage page = new FilmPage();
                page.readThis(br);
                this.pageList.add(page);
                GridIcon gi = new GridIcon(page.getRow(), page.getCol());
                String[][] images = page.getImages();
                this.listModel.add(i, new myLabel(i, new GridIcon(page.getRow(), page.getCol())));
            }
            this.currentFilmPage = (FilmPage)this.pageList.get(currentPageIndex);
            this.jList1.setSelectedIndex(currentPageIndex);
            br.close();
            this.changeList = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return currentPageIndex;
    }

    private void updatePageList() {
        this.changeList = false;
        Iterator it = this.pageList.iterator();
        this.listModel.clear();
        int count = 0;
        while (it.hasNext()) {
            FilmPage page = (FilmPage)it.next();
            this.listModel.add(count, new myLabel(count, new GridIcon(page.getRow(), page.getCol())));
            ++count;
        }
        this.changeList = true;
    }

    public void moveImage(String imageName, int newPage) {
        FilmPage movePage;
        boolean added;
        String[][] images = this.currentFilmPage.getImages();
        boolean found = false;
        int i = 0;
        int j = 0;
        for (i = 0; i < images.length; ++i) {
            for (j = 0; j < images[i].length; ++j) {
                if (images[i][j] == null || !images[i][j].equals(imageName)) continue;
                this.currentFilmPage.remove(i, j);
                found = true;
                break;
            }
            if (found) break;
        }
        if (added = (movePage = (FilmPage)this.pageList.get(newPage)).addImage(imageName)) {
            if (this.currentFilmPage.isEmpty()) {
                int index = this.pageList.indexOf(this.currentFilmPage);
                this.pageList.remove(this.currentFilmPage);
                this.updateCurrentPage((FilmPage)this.pageList.get(index), index);
            } else {
                this.updateCurrentPage(this.currentFilmPage, this.pageList.indexOf(this.currentFilmPage));
            }
            this.writePages();
            er.sendEvent("Reload", "NULL");
        } else {
            this.currentFilmPage.addImage(imageName, i, j);
        }
    }

    private void setupEvents() {
        try {
            EventRouter.startServer(5879);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jcomboLayout.setModel(this.cbModel);
        er = EventRouter.createClient();
        er.connect("127.0.0.1", 5879);
        EREventListener cl = new EREventListener(){

            @Override
            public void event(EREvent[] e) {
                for (int i = 0; i < e.length; ++i) {
                    if (!e[i].getType().equals("Reload")) continue;
                    System.err.println("added_Image...." + e[i].getMessageAsString());
                    JavaFilmComposer.this.readPages();
                    int cIndex = Integer.parseInt(e[i].getMessageAsString());
                    JavaFilmComposer.this.updateCurrentPage((FilmPage)JavaFilmComposer.this.pageList.get(cIndex), cIndex);
                }
            }
        };
        er.addEREventListener("Reload", 0, cl);
    }

    private BufferedImage getImage(String fileName) {
        try {
            this.dp.setFile(new FileInputStream(fileName));
            BufferedImage[] imgs = dicomImageGen.getImages(this.dp, null);
            this.dp.clearFile();
            if (imgs.length > 0) {
                return imgs[0];
            }
            return null;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setTitle("Java Film Composer");
        JavaFilmComposer javaFilmComposer1 = new JavaFilmComposer(frame);
        frame.setSize(400, 600);
        frame.setContentPane(javaFilmComposer1);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout1);
        this.jBFilmQueue.setText("Filming Queue");
        this.cbModel.addElement(new GridIcon("pformat 1x1_fid"));
        this.cbModel.addElement(new GridIcon("pformat 2x2_fid"));
        this.cbModel.addElement(new GridIcon("pformat 3x3_fid"));
        this.cbModel.addElement(new GridIcon("pformat 4x4_fid"));
        this.jBFilmQueue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBFilmQueue_actionPerformed(e);
            }
        });
        this.jPanel4.setLayout(this.borderLayout4);
        this.jBSave.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/jfc/icons/icosave_32_1a.GIF")));
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Java Film Composer");
        this.jBFullScreen.setText("Full Screen");
        this.jBFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBFullScreen_actionPerformed(e);
            }
        });
        this.jBPrintSetting.setText("Print Settings");
        this.jBPrintSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBPrintSetting_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.gridLayout4);
        this.jPanel10.setLayout(this.gridLayout2);
        this.jB2x2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jB2x2_actionPerformed(e);
            }
        });
        this.jbHide.setText("Hide");
        this.jbHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jbHide_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel8.setLayout(this.gridLayout1);
        this.jB3x3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jB3x3_actionPerformed(e);
            }
        });
        this.jB1x1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jB1x1_actionPerformed(e);
            }
        });
        this.jB4x4.setHorizontalTextPosition(11);
        this.jB4x4.setSelected(false);
        this.jB4x4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jB4x4_actionPerformed(e);
            }
        });
        this.jPanel7.setLayout(this.gridBagLayout2);
        this.jPanel1.setLayout(this.gridLayout5);
        this.jBDeletePage.setText("");
        this.jBDeletePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBDeletePage_actionPerformed(e);
            }
        });
        this.jBDeletePage.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/jfc/icons/icoremove1page1a.GIF")));
        this.jPanel6.setLayout(this.borderLayout3);
        this.jBDeleteAll.setText("");
        this.jBDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBDeleteAll_actionPerformed(e);
            }
        });
        this.jBDeleteAll.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/jfc/icons/icoremoveallpagesmall1.gif")));
        this.jBExportData.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/jfc/icons/iconetwork_32_1.gif")));
        this.jBExportData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBExportData_actionPerformed(e);
            }
        });
        this.jBExportData.setEnabled(false);
        this.jBPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/ge/med/terra/xpv/jfc/icons/icoprint1.gif")));
        this.jBPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jBPrint_actionPerformed(e);
            }
        });
        this.jPanel9.setLayout(this.borderLayout2);
        this.jPanel11.setLayout(this.borderLayout6);
        this.jcomboLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFilmComposer.this.jcomboLayout_actionPerformed(e);
            }
        });
        this.jB1x1.setText("");
        this.jB2x2.setText("");
        this.jB3x3.setText("");
        this.jTextField1.setText("jTextField1");
        this.jTextField1.setHorizontalAlignment(0);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jPanel12.setLayout(this.borderLayout1);
        this.jPanel4.setMinimumSize(new Dimension(8, 60));
        this.jPanel4.setPreferredSize(new Dimension(4, 60));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JavaFilmComposer.this.jList1_valueChanged(e);
            }
        });
        this.jPanel8.add((Component)this.jbHide, null);
        this.jPanel8.add((Component)this.jBFullScreen, null);
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(0, 2, 1, 1, 1.0, 70.0, 10, 1, new Insets(5, 10, 0, 10), 0, 300));
        this.jPanel6.add((Component)this.newPage, "Center");
        this.jPanel2.add((Component)this.jPanel5, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.jPanel2.add((Component)this.jPanel7, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.jPanel10.add((Component)this.jB1x1, null);
        this.jPanel10.add((Component)this.jB2x2, null);
        this.jPanel10.add((Component)this.jB3x3, null);
        this.jPanel10.add((Component)this.jB4x4, null);
        this.jPanel2.add((Component)this.jPanel8, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.jPanel7.add((Component)this.jPanel9, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 2, 1, 0), 0, 0));
        this.jPanel9.add((Component)this.jcomboLayout, "Center");
        this.jPanel7.add((Component)this.jPanel10, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jBDeleteAll, null);
        this.jPanel5.add((Component)this.jTextField1, null);
        this.jPanel5.add((Component)this.jBDeletePage, null);
        this.jPanel2.add((Component)this.jPanel4, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.jPanel4.add((Component)this.jPanel12, "Center");
        this.jPanel12.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 0, 10), 0, 7));
        this.jPanel3.add((Component)this.jBPrintSetting, null);
        this.jPanel3.add((Component)this.jBFilmQueue, null);
        this.jPanel2.add((Component)this.jPanel1, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.jPanel1.add((Component)this.jBSave, null);
        this.jPanel1.add((Component)this.jBExportData, null);
        this.jPanel1.add((Component)this.jBPrint, null);
        this.jPanel11.add((Component)this.jLabel1, "North");
        this.jPanel11.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel11, MAIN_PANEL);
        this.add((Component)this.printer, REMOTE_PRINTERS);
        this.add((Component)this.preConfig, PRE_CONFIGURE);
        this.add((Component)this.cameraConfig, PRINTER_SETTING);
        this.add((Component)this.advConfig, ADVANCED_SETTING);
        this.add((Component)this.ftpConfig, Export_SETTING);
        this.add((Component)this.filmQueue, FILM_QUEUE);
        this.cardLayout1.show(this, MAIN_PANEL);
    }

    void jbHide_actionPerformed(ActionEvent e) {
        if (this.parent != null) {
            this.parent.setState(1);
        }
    }

    void jBFullScreen_actionPerformed(ActionEvent e) {
        if (this.parent != null) {
            this.parent.setExtendedState(6);
        }
    }

    void jB1x1_actionPerformed(ActionEvent e) {
        GridIcon icon = (GridIcon)this.jB1x1.getIcon();
        this.changeViewportFormat(icon.getRow(), icon.getCol());
    }

    void jB2x2_actionPerformed(ActionEvent e) {
        GridIcon icon = (GridIcon)this.jB2x2.getIcon();
        this.changeViewportFormat(icon.getRow(), icon.getCol());
    }

    void jB3x3_actionPerformed(ActionEvent e) {
        GridIcon icon = (GridIcon)this.jB3x3.getIcon();
        this.changeViewportFormat(icon.getRow(), icon.getCol());
    }

    private void changeViewportFormat(int row, int col) {
        int newViewportNum = row * col;
        int numViewPortCurrentPage = this.currentPage.numViewports();
        if (newViewportNum == numViewPortCurrentPage) {
            return;
        }
        int cIndex = this.getCurrentPageIndex();
        if (newViewportNum < numViewPortCurrentPage) {
            FilmPage cPage = (FilmPage)this.pageList.get(cIndex);
            Vector leftImages = cPage.setRowCol(row, col);
            if (leftImages != null) {
                int insertIndex = cIndex + 1;
                while (leftImages.size() > 0) {
                    FilmPage newPage = new FilmPage();
                    for (int rowC = 0; rowC < 2; ++rowC) {
                        for (int colC = 0; colC < 2; ++colC) {
                            String imageName = (String)leftImages.remove(0);
                            if (!imageName.equals("null")) {
                                newPage.addImage(imageName, rowC, colC);
                            }
                            if (leftImages.size() == 0) break;
                        }
                        if (leftImages.size() == 0) break;
                    }
                    this.pageList.add(insertIndex, newPage);
                    ++insertIndex;
                }
            }
            if (cPage.isEmpty() && this.pageList.size() > 1) {
                this.pageList.remove(cPage);
            }
        } else {
            ((FilmPage)this.pageList.get(cIndex)).setRowCol(row, col);
        }
        this.updateCurrentPage((FilmPage)this.pageList.get(cIndex), cIndex);
        this.writePages();
        er.sendEvent("Reload", "NULL");
    }

    void jB4x4_actionPerformed(ActionEvent e) {
        GridIcon icon = (GridIcon)this.jB4x4.getIcon();
        this.changeViewportFormat(icon.getRow(), icon.getCol());
    }

    void jcomboLayout_actionPerformed(ActionEvent e) {
        if (this.rowColChange) {
            GridIcon icon = (GridIcon)this.jcomboLayout.getSelectedItem();
            this.changeViewportFormat(icon.getRow(), icon.getCol());
        }
    }

    void jBDeleteAll_actionPerformed(ActionEvent e) {
        Iterator it = this.pageList.iterator();
        while (it.hasNext()) {
            this.removeImages((FilmPage)it.next());
        }
        this.pageList.clear();
        FilmPage fp = new FilmPage();
        this.pageList.add(fp);
        this.updateCurrentPage(fp, 0);
        this.writePages();
        er.sendEvent("Reload", "NULL");
    }

    void jBDeletePage_actionPerformed(ActionEvent e) {
        int lastIndex;
        int cIndex = this.getCurrentPageIndex();
        if (cIndex == (lastIndex = this.pageList.size() - 1)) {
            if (cIndex == 0) {
                this.jBDeleteAll.doClick();
                return;
            }
            this.removePage((FilmPage)this.pageList.getLast());
            this.updateCurrentPage((FilmPage)this.pageList.getFirst(), 0);
        } else {
            this.removePage((FilmPage)this.pageList.get(cIndex));
            this.updateCurrentPage((FilmPage)this.pageList.get(cIndex), cIndex);
        }
        this.updatePageList();
        this.writePages();
        er.sendEvent("Reload", "NULL");
    }

    private void removePage(FilmPage page) {
        this.removeImages(page);
        this.pageList.remove(page);
    }

    private void removeImages(FilmPage page) {
        String[][] images = page.getImages();
        for (int i = 0; i < images.length; ++i) {
            for (int j = 0; j < images[i].length; ++j) {
                if (images[i][j] == null) continue;
                new File(images[i][i]).delete();
            }
        }
    }

    private void updateCurrentPage(FilmPage fp, int index) {
        this.currentFilmPage = fp;
        this.currentPage = new JavaFilmPage(this, fp.getRow(), fp.getCol());
        String[][] images = fp.getImages();
        for (int i = 0; i < images.length; ++i) {
            for (int j = 0; j < images[i].length; ++j) {
                if (images[i][j] == null) continue;
                this.currentPage.addImage(this.getImage(images[i][j]), images[i][j], i, j);
            }
        }
        this.jPanel6.removeAll();
        this.jPanel6.add((Component)this.currentPage, "Center");
        this.jTextField1.setText(Integer.toString(this.pageList.indexOf(fp) + 1) + "/" + Integer.toString(this.pageList.size()));
        this.jPanel6.revalidate();
        this.changeList = false;
        this.jList1.setSelectedIndex(index);
        this.jList1.repaint();
        this.changeList = true;
    }

    private int getCurrentPageIndex() {
        String text = this.jTextField1.getText();
        StringTokenizer st = new StringTokenizer(text, "/");
        return Integer.parseInt(st.nextToken()) - 1;
    }

    void jBPrintSetting_actionPerformed(ActionEvent e) {
        if (this.defaultPrinterSetting == null) {
            this.showRemotePrinters(null);
        } else {
            String pathName = this.defaultPrinterSetting.getAbsolutePath();
            this.showRemotePrinters(pathName.substring(pathName.lastIndexOf(File.separator) + 1, pathName.lastIndexOf(46)));
        }
    }

    public void showMainPanel() {
        if (this.defaultPrinterSetting != null) {
            this.populateLayoutCombo();
        }
        this.cardLayout1.show(this, MAIN_PANEL);
    }

    private void populateLayoutCombo() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.defaultPrinterSetting)));
            String line = null;
            boolean listCounter = false;
            this.cbModel.removeAllElements();
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("pformat")) continue;
                this.cbModel.addElement(new GridIcon(line));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateRowColButtons();
    }

    private void updateRowColButtons() {
        this.jB1x1.setIcon((GridIcon)this.cbModel.getElementAt(0));
        this.jB2x2.setIcon((GridIcon)this.cbModel.getElementAt(1));
        this.jB3x3.setIcon((GridIcon)this.cbModel.getElementAt(2));
        this.jB4x4.setIcon((GridIcon)this.cbModel.getElementAt(3));
    }

    public void showRemotePrinters(String dev) {
        this.printer.populateList();
        this.printer.setSelection(dev);
        this.cardLayout1.show(this, REMOTE_PRINTERS);
    }

    public void showPreConfigurePanel() {
        this.preConfig.populateList();
        this.cardLayout1.show(this, PRE_CONFIGURE);
    }

    public void showPrinterSetting() {
        this.cameraConfig.setSetting(this.preConfig.getSelectedCamera());
        this.cardLayout1.show(this, PRINTER_SETTING);
    }

    public void showPrinterSettingA() {
        this.cardLayout1.show(this, PRINTER_SETTING);
    }

    public void showPrinterSettingDev() {
        this.cardLayout1.show(this, PRINTER_SETTING);
    }

    public void showAdvancedSetting() {
        this.cardLayout1.show(this, ADVANCED_SETTING);
    }

    public void showFTPSetting() {
        this.ftpConfig.setFolderName("kang");
        this.cardLayout1.show(this, Export_SETTING);
    }

    public void showFilmQueue() {
        this.filmQueue.update();
        this.cardLayout1.show(this, FILM_QUEUE);
    }

    public Properties getAdvancedSetting() {
        return this.advConfig.getAdvancedSetting();
    }

    public void addRemotePrinter(String devName) {
        this.printer.addRemotePrinter(devName);
    }

    public void showPrinterSetting(Properties prop) {
        this.cameraConfig.setSetting(this.preConfig.getSelectedCamera());
        this.cardLayout1.show(this, PRINTER_SETTING);
    }

    void jBExportData_actionPerformed(ActionEvent e) {
        this.showFTPSetting();
    }

    public void rearrangePort(int row, int col, String image) {
        int i;
        System.err.println("in rearrangePort...printing currentFilmPage");
        this.currentFilmPage.print();
        String oldImage = this.currentFilmPage.getImage(row, col);
        String[][] images = this.currentFilmPage.getImages();
        int j = 0;
        for (i = 0; i < images.length; ++i) {
            boolean found = false;
            for (j = 0; j < images[i].length; ++j) {
                String imageName = images[i][j];
                if (imageName == null || !imageName.equals(image)) continue;
                this.currentFilmPage.remove(i, j);
                found = true;
                break;
            }
            if (found) break;
        }
        if (oldImage != null) {
            this.currentFilmPage.addImage(oldImage, i, j);
        }
        if (images[row][col] != null) {
            this.currentFilmPage.remove(row, col);
        }
        this.currentFilmPage.addImage(image, row, col);
        this.updateCurrentPage(this.currentFilmPage, this.pageList.indexOf(this.currentFilmPage));
        this.writePages();
        er.sendEvent("Reload", "NULL");
    }

    public JavaFilmPage getJavaFilmPage(FilmPage fp) {
        JavaFilmPage cPage = new JavaFilmPage(this, fp.getRow(), fp.getCol());
        String[][] images = fp.getImages();
        for (int i = 0; i < images.length; ++i) {
            for (int j = 0; j < images[i].length; ++j) {
                if (images[i][j] == null) continue;
                cPage.addImage(this.getImage(images[i][j]), images[i][j], i, j);
            }
        }
        return cPage;
    }

    void jBPrint_actionPerformed(ActionEvent e) {
        JFCFilm print = new JFCFilm(this);
        print.film();
    }

    void jBFilmQueue_actionPerformed(ActionEvent e) {
        this.showFilmQueue();
    }

    void jList1_valueChanged(ListSelectionEvent e) {
        if (this.changeList) {
            myLabel label = (myLabel)this.jList1.getSelectedValue();
            this.updateCurrentPage((FilmPage)this.pageList.get(label.pageNum - 1), label.pageNum - 1);
        }
    }

    static {
        selectedBorder = BorderFactory.createLineBorder(UIManager.getColor("P7"), 2);
    }

    public class GridIcon
    implements Icon {
        int row = 4;
        int col = 4;
        int width = 20;
        int height = 20;

        public GridIcon(String line) {
            String[] s = line.split("[x _]");
            this.row = Integer.parseInt(s[1]);
            this.col = Integer.parseInt(s[2]);
        }

        public GridIcon(int row, int col) {
            this.row = row;
            this.col = col;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int xp, int yp) {
            int dx = (this.width - 1) / this.col;
            int dy = (this.height - 1) / this.row;
            int h = c.getHeight();
            g.setColor(Color.BLACK);
            g.fillRect(xp, yp, this.width, this.height);
            xp += (this.width - dx * this.col) / 2;
            yp += (this.height - dy * this.row) / 2;
            g.setColor(Color.WHITE);
            for (int x = 0; x < this.col + 1; ++x) {
                g.drawLine(xp + x * dx, yp, xp + x * dx, yp + dy * this.row);
            }
            for (int y = 0; y < this.row + 1; ++y) {
                g.drawLine(xp, yp + y * dy, xp + dx * this.col, yp + y * dy);
            }
        }

        public String toString() {
            return Integer.toString(this.row) + "x" + Integer.toString(this.col);
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setIcon(((myLabel)value).getIcon());
            this.setBackground(isSelected ? XPui.p8() : Color.white);
            this.setPreferredSize(new Dimension(65, 30));
            return this;
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setIcon((GridIcon)value);
            this.setText(value.toString());
            this.setBackground(isSelected ? XPui.p8() : Color.white);
            this.setPreferredSize(new Dimension(30, 22));
            return this;
        }
    }

    public class DroppableList
    extends JList
    implements DropTargetListener {
        DropTarget dropTarget = new DropTarget(this, this);

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dte) {
            myLabel label = (myLabel)this.getModel().getElementAt(this.locationToIndex(dte.getLocation()));
            if (((FilmPage)JavaFilmComposer.this.pageList.get(label.pageNum - 1)).isFull()) {
                System.err.println("is full");
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public synchronized void drop(DropTargetDropEvent dte) {
            try {
                System.err.println("in drop");
                int index = this.locationToIndex(dte.getLocation());
                myLabel label = (myLabel)this.getModel().getElementAt(index);
                if (((FilmPage)JavaFilmComposer.this.pageList.get(label.pageNum - 1)).isFull()) {
                    dte.rejectDrop();
                } else {
                    Transferable tr = dte.getTransferable();
                    if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        dte.acceptDrop(3);
                        String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                        JavaFilmComposer.this.moveImage(str, index);
                        System.err.println("str===" + str);
                        dte.getDropTargetContext().dropComplete(true);
                    } else {
                        System.err.println("Rejected");
                        dte.rejectDrop();
                    }
                }
            }
            catch (Exception io) {
                io.printStackTrace();
                dte.rejectDrop();
            }
        }
    }

    class myLabel
    extends JLabel {
        public int pageNum;

        myLabel(int pageNum, Icon icon) {
            super(icon);
            this.pageNum = -1;
            this.setPreferredSize(new Dimension(65, 25));
            this.pageNum = pageNum + 1;
        }
    }

    public class FilmJob {
        private LinkedList filmJob = new LinkedList();

        public synchronized String get() {
            if (this.filmJob.size() > 0) {
                return (String)this.filmJob.removeFirst();
            }
            return null;
        }

        public synchronized void put(String newjob) {
            this.filmJob.addLast(newjob);
        }

        public synchronized Vector getQueue() {
            Vector vt = new Vector();
            Iterator it = this.filmJob.iterator();
            while (it.hasNext()) {
                vt.add(it.next());
            }
            return vt;
        }

        public synchronized boolean remove(String deleteJob) {
            boolean removed = this.filmJob.remove(deleteJob);
            if (removed) {
                File file = new File(deleteJob);
                File[] lists = file.listFiles();
                for (int i = 0; i < lists.length; ++i) {
                    lists[i].delete();
                }
                file.delete();
            }
            return removed;
        }
    }
}

