/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.xpv.jfc.JavaFilmComposer;
import com.ge.med.terra.xpv.jfc.JavaFilmer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JavaFilmPage
extends JPanel
implements Printable {
    JComponent[] pport = new JComponent[0];
    public static Border selectedBorder = BorderFactory.createLineBorder(Color.white, 2);
    int row;
    int col;
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();
    JavaFilmComposer parent;
    int selectedPortNumber;

    public void resetPort(int row, int col) {
        int i;
        super.setLayout(new GridLayout(row, col, 1, 1));
        JComponent[] tmp = new JComponent[row * col];
        if (row * col > this.pport.length) {
            System.arraycopy(this.pport, 0, tmp, 0, this.pport.length);
            for (i = this.pport.length; i < row * col; ++i) {
                tmp[i] = new ImagePort();
            }
        } else {
            for (i = 0; i < tmp.length; ++i) {
                tmp[i] = this.pport[i];
            }
        }
        this.pport = tmp;
        this.removeAll();
        for (i = 0; i < this.pport.length; ++i) {
            this.addPort(this.pport[i]);
        }
        this.row = row;
        this.col = col;
        this.validate();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (((ImagePort)this.pport[i]).getMyImage() == null) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (((ImagePort)this.pport[i]).getMyImage() != null) continue;
            return false;
        }
        return true;
    }

    public JavaFilmPage(JavaFilmComposer parent, int row, int col) {
        this.setSize(150, 150);
        this.setBackground(Color.BLACK);
        this.setLayout(new GridLayout(row, col, 1, 1));
        this.pport = new JComponent[row * col];
        for (int i = 0; i < this.pport.length; ++i) {
            this.pport[i] = new ImagePort();
            this.addPort(this.pport[i]);
        }
        this.row = row;
        this.col = col;
        this.parent = parent;
    }

    public JavaFilmPage(JavaFilmComposer parent) {
        this(parent, 1, 1);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void addPort(Component comp) {
        super.add(comp);
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JavaFilmPage.this.selectionChangeOnChild(e.getSource());
            }
        });
    }

    void selectionChangeOnChild(Object source) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (this.pport[i] == source) {
                this.setSelectedPortNumber(i);
                Dimension dim = this.pport[i].getSize();
                this.pport[i].setBorder(selectedBorder);
                continue;
            }
            this.pport[i].setBorder(null);
        }
        this.revalidate();
    }

    public void setSelectedPortNumber(int selectedPort) {
        int oldSelectedPortNumber = this.selectedPortNumber;
        this.selectedPortNumber = selectedPort;
        for (int i = 0; i < this.pport.length; ++i) {
            if (i == selectedPort) {
                this.pport[i].setBorder(selectedBorder);
                continue;
            }
            this.pport[i].setBorder(null);
        }
        this.repaint();
    }

    public int numViewports() {
        return this.row * this.col;
    }

    public boolean addImage(BufferedImage bi, String fName, int rowC, int colC) {
        boolean status = false;
        if (((ImagePort)this.pport[rowC * this.col + colC]).getMyImage() == null) {
            ((ImagePort)this.pport[rowC * this.col + colC]).setMyImage(bi, fName);
            status = true;
        }
        if (status) {
            for (int i = 0; i < this.pport.length; ++i) {
                if (((ImagePort)this.pport[i]).getMyImage() != null) continue;
                this.setSelectedPortNumber(i);
                break;
            }
        }
        return status;
    }

    public BufferedImage getImage(int index) {
        if (index < this.pport.length) {
            return ((ImagePort)this.pport[index]).getMyImage();
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle dim = this.getBounds();
        g.setColor(Color.white);
        g.fillRect(dim.x, dim.y, (int)dim.getWidth(), (int)dim.getHeight());
        super.paint(g);
    }

    public void clearPort() {
        for (int i = 0; i < this.pport.length; ++i) {
            ((ImagePort)this.pport[i]).setMyImage(null, null);
        }
        this.repaint();
    }

    public Vector getImages() {
        Vector<BufferedImage> vec = new Vector<BufferedImage>();
        for (int i = 0; i < this.pport.length; ++i) {
            vec.add(((ImagePort)this.pport[i]).getMyImage());
        }
        return vec;
    }

    @Override
    public int print(Graphics graphics, PageFormat format, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(Color.white);
        this.setPreferredSize(new Dimension((int)format.getWidth(), (int)format.getHeight()));
        this.jf.setContentPane(this);
        this.jf.pack();
        g2d.fillRect((int)format.getImageableX(), (int)format.getImageableY(), (int)format.getImageableWidth(), (int)format.getImageableHeight());
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.translate(format.getImageableX(), format.getImageableY());
        g2d.scale(sx, sy);
        this.print(g2d);
        this.jf.setContentPane(this.jp);
        return 0;
    }

    public class ImagePort
    extends JPanel
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        BufferedImage myImage = null;
        DropTarget dropTarget = null;
        String fName = null;
        private DragSource dragSource = new DragSource();

        public ImagePort() {
            this.dropTarget = new DropTarget(this, this);
            this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        public ImagePort(BufferedImage image) {
            this.dropTarget = new DropTarget(this, this);
            this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
            this.myImage = image;
        }

        public BufferedImage getMyImage() {
            return this.myImage;
        }

        public void setMyImage(BufferedImage image, String fName) {
            this.myImage = image;
            this.fName = fName;
            this.repaint();
        }

        public String getFilename() {
            return this.fName;
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            System.err.println("dragGestureRecognized");
            StringSelection t = new StringSelection(this.fName);
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, t, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(2);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                int i;
                for (i = 0; i < JavaFilmPage.this.pport.length && !JavaFilmPage.this.pport[i].equals(this); ++i) {
                }
                int rowC = i / JavaFilmPage.this.row;
                int colC = i - rowC * JavaFilmPage.this.row;
                Transferable tr = dtde.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(3);
                    String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    System.err.println("str===" + str);
                    if (str.indexOf("javaFilmDir") >= 0) {
                        JavaFilmer jf = new JavaFilmer();
                        jf.dropImage(str, rowC, colC);
                        jf.closeConnection();
                    } else {
                        JavaFilmPage.this.parent.rearrangePort(rowC, colC, str);
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                }
            }
            catch (Exception exception) {
                dtde.rejectDrop();
                exception.printStackTrace();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle vp = this.getBounds();
            g.fillRect(0, 0, (int)vp.getWidth(), (int)vp.getHeight());
            if (this.myImage == null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, (int)vp.getWidth(), (int)vp.getHeight());
            } else {
                g.setColor(Color.black);
                g.fillRect(0, 0, (int)vp.getWidth(), (int)vp.getHeight());
                Graphics2D g2 = (Graphics2D)g;
                int image1Width = this.myImage.getWidth();
                int image1Height = this.myImage.getHeight();
                double fitToX = vp.getWidth() / (double)image1Width;
                double fitToY = vp.getHeight() / (double)image1Height;
                double zoom = fitToX < fitToY ? fitToX : fitToY;
                double vp_tx = 0.5 * (double)vp.width;
                double vp_ty = 0.5 * (double)vp.height;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.translate(vp_tx, vp_ty);
                g2.scale(zoom, zoom);
                g2.translate(-0.5 * (double)image1Width, -0.5 * (double)image1Height);
                g2.drawImage((Image)this.myImage, 0, 0, null);
                g2.translate(0.5 * (double)image1Width, 0.5 * (double)image1Height);
                g2.scale(1.0 / zoom, 1.0 / zoom);
                g2.translate(-vp_tx, -vp_ty);
            }
        }
    }
}

