/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.tap.print.ImageSource;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.xpv.jfc.JFCUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class JavaFilmer {
    static String host = "127.0.0.1";
    static final int PortNum = 10005;
    ImageSource imageSource;
    static File tempDir;
    dicomParser dp = new dicomParser();
    private Socket pi;
    BufferedReader iss = null;
    DataOutputStream oss = null;

    public JavaFilmer(ImageSource imageSource) throws IOException {
        this.imageSource = imageSource;
        try {
            this.pi = new Socket(host, 10005);
            this.iss = new BufferedReader(new InputStreamReader(this.pi.getInputStream()));
            this.oss = new DataOutputStream(this.pi.getOutputStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public JavaFilmer() throws IOException {
        try {
            this.pi = new Socket(host, 10005);
            this.iss = new BufferedReader(new InputStreamReader(this.pi.getInputStream()));
            this.oss = new DataOutputStream(this.pi.getOutputStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void setFormat(int row, int col) {
        try {
            this.oss.writeBytes("Set_Row_Col|" + Integer.toString(row) + "|" + Integer.toString(col) + "\n");
            String status = this.iss.readLine();
            System.err.println("status===" + status);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void film() {
        for (int i = 0; i < this.imageSource.getNumberOfImages(); ++i) {
            System.err.println("filming image #===" + i);
            this.filmImage(i);
        }
    }

    public void dropImage(String imageName, int row, int col) {
        try {
            this.oss.writeBytes("Drop_Image|" + imageName + "|" + row + "|" + col + "\n");
            String status = this.iss.readLine();
            System.err.println("status====" + status);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            this.iss.close();
            this.oss.close();
            this.pi.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void filmImage(int index) {
        try {
            String fileName = JFCUtil.makeFinalSCImage(this.imageSource.getBufferedImage(index, 1024, 1024));
            this.oss.writeBytes("Print_Image|" + fileName + "\n");
            String status = this.iss.readLine();
            System.err.println("status====" + status);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void showFilmComposer() {
        try {
            this.oss.writeBytes("Show_FilmComposer\n");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

