/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class PanMouseController
extends Xp2DViewerMouseController {
    private XpImageRenderAttributesOwner iraOwner = null;
    private PanZoomCapable vp = null;
    private Point startPoint = null;
    private Point prevPoint = null;
    protected double startPanX = 0.0;
    protected double startPanY = 0.0;
    protected int imgWidth = 0;
    protected int imgHeight = 0;
    protected Dimension dim = new Dimension();
    private boolean mPressed = false;

    @Override
    public void setTarget(JComponent vc) {
        if (vc instanceof XpImageRenderAttributesOwner) {
            this.iraOwner = (XpImageRenderAttributesOwner)((Object)vc);
        }
        if (vc instanceof PanZoomCapable) {
            this.vp = (PanZoomCapable)((Object)vc);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        FrameOwner fo;
        XpImage xi;
        XpSlice slice;
        this.mPressed = true;
        this.prevPoint = this.startPoint = me.getPoint();
        XpImageRenderAttributes ira = this.iraOwner.getImageRenderAttributes();
        this.startPanX = ira.getPanX();
        this.startPanY = ira.getPanY();
        ((JComponent)((Object)this.vp)).getSize(this.dim);
        if (this.vp instanceof FrameOwner && ((FrameOwner)((Object)this.vp)).getFrame() != null && (slice = (xi = (fo = (FrameOwner)((Object)this.vp)).getFrame()).getSlice()) != null) {
            this.imgWidth = slice.width;
            this.imgHeight = slice.height;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.mPressed || this.startPoint == null || this.vp == null) {
            return;
        }
        Point p = me.getPoint();
        double dx = p.getX() - this.startPoint.getX();
        double dy = p.getY() - this.startPoint.getY();
        this.pan(dx, dy);
        this.prevPoint = p;
    }

    private void pan(double dx, double dy) {
        double zoom = this.vp.getZoom();
        ((JComponent)((Object)this.vp)).getSize(this.dim);
        double panx = this.startPanX + (double)this.imgWidth * dx / this.dim.getWidth() / zoom;
        double pany = this.startPanY + (double)this.imgHeight * dy / this.dim.getHeight() / zoom;
        double limPanx = this.imgWidth / 2;
        double limPany = this.imgHeight / 2;
        panx = Math.min(Math.max(panx, -limPanx), limPanx);
        pany = Math.min(Math.max(pany, -limPany), limPany);
        this.vp.setPan(panx, pany);
        this.vp.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mPressed = false;
        this.prevPoint = null;
    }
}

