/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.mouseController.Default2DViewerMouseController;
import com.ge.med.terra.xpv.mouseController.PrintAction;
import com.ge.med.terra.xpv.mouseController.SaveAsAction;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class RightMenuMouseController
extends Xp2DViewerMouseController
implements PropertyChangeListener {
    JRadioButtonMenuItem[] modeMenuItems;
    private Default2DViewerMouseController controller;
    private XPscreen screen;
    private SaveAsAction saveAction;
    private PrintAction printAction;
    ActionListener modeSwitchListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = Integer.parseInt(e.getActionCommand());
            RightMenuMouseController.this.controller.setLeftMouseBinding(index);
        }
    };
    JPopupMenu menu_ = new JPopupMenu();

    public RightMenuMouseController(Default2DViewerMouseController controller, Map[] mouseControllerData) {
        this.saveAction = new SaveAsAction();
        this.menu_.add(this.saveAction);
        this.printAction = new PrintAction();
        this.menu_.add(this.printAction);
        this.menu_.addSeparator();
        ButtonGroup bg = new ButtonGroup();
        if (mouseControllerData != null) {
            this.modeMenuItems = new JRadioButtonMenuItem[mouseControllerData.length];
            for (int i = 0; i < mouseControllerData.length; ++i) {
                Map props = mouseControllerData[i];
                Icon ico = null;
                String name = "";
                if (props != null) {
                    ico = (Icon)props.get("Icon");
                    name = (String)props.get("Name");
                }
                JRadioButtonMenuItem menuI = new JRadioButtonMenuItem(name, ico, i == 0);
                this.menu_.add(menuI);
                menuI.setActionCommand("" + i);
                menuI.addActionListener(this.modeSwitchListener);
                this.modeMenuItems[i] = menuI;
                bg.add(menuI);
            }
        }
        this.controller = controller;
        controller.addPropertyChangeListener("leftMouse", this);
    }

    @Override
    public void setTarget(JComponent jc) {
        while (jc != null && !(jc instanceof XPscreen)) {
            jc = (JComponent)jc.getParent();
        }
        this.screen = (XPscreen)jc;
        if (this.saveAction != null) {
            this.saveAction.setScreen(this.screen);
        }
        if (this.printAction != null) {
            this.printAction.setScreen(this.screen);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.menu_.show((Component)e.getSource(), e.getX(), e.getY());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newIndex = (Integer)evt.getNewValue();
        if (this.modeMenuItems != null && this.modeMenuItems.length > newIndex) {
            this.modeMenuItems[newIndex].setSelected(true);
        }
    }
}

