/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class WLMouseController
extends Xp2DViewerMouseController {
    private XpImageRenderAttributesOwner iraOwner = null;
    private WindowLevelCapable vp = null;
    private Point startPoint = null;
    private Point prevPoint = null;
    private double startWW = 0.0;
    private double startWL = 0.0;
    private double startMax = 0.0;
    private double rescaleSlope = 1.0;
    private double wlRange = 20.0;
    private XpResponseCurve wlResponse = new XpResponseCurve();
    private XpDicomElement modality = new XpDicomElement(8, 96);
    private XpDicomElement units = new XpDicomElement(84, 4097);
    protected Object saveInterpolation = null;
    private boolean mPressed = false;
    private boolean wwwlStyle = true;

    @Override
    public void setTarget(JComponent vc) {
        if (vc instanceof XpImageRenderAttributesOwner) {
            this.iraOwner = (XpImageRenderAttributesOwner)((Object)vc);
        }
        if (vc instanceof WindowLevelCapable) {
            this.vp = (WindowLevelCapable)((Object)vc);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mPressed = true;
        this.prevPoint = this.startPoint = me.getPoint();
        XpImageRenderAttributes ira = this.iraOwner.getImageRenderAttributes();
        if (this.vp != null) {
            double wmax = this.vp.getWinMax();
            double wmin = this.vp.getWinMin();
            this.startWW = wmax - wmin;
            this.startWL = (wmax + wmin) * 0.5;
        } else {
            this.startWW = ira.getWindowWidth();
            this.startWL = ira.getWindowLevel();
        }
        this.startMax = ira.getWindowMax();
        if (this.vp instanceof FrameOwner && ((FrameOwner)((Object)this.vp)).getFrame() != null) {
            FrameOwner fo = (FrameOwner)((Object)this.vp);
            XpImage xi = fo.getFrame();
            this.rescaleSlope = xi.getRescaleSlope();
            this.wwwlStyle = true;
            if (xi instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)xi);
                dobj.getValue(this.modality);
                if (this.modality.value != null && this.modality.value.equals("PT")) {
                    this.wwwlStyle = false;
                    dobj.getValue(this.units);
                }
            }
        }
        if (dragInterpolation != null && this.vp instanceof XpSingularPort) {
            XpSingularPort sp = (XpSingularPort)this.vp;
            this.saveInterpolation = sp.getInterpolationHint();
            sp.setInterpolationHint(dragInterpolation);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.mPressed || this.startPoint == null || this.vp == null) {
            return;
        }
        Point p = me.getPoint();
        double dx = p.getX() - this.startPoint.getX();
        double dy = p.getY() - this.startPoint.getY();
        this.wwwl(dx, dy);
        this.prevPoint = p;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mPressed = false;
        this.prevPoint = null;
        if (dragInterpolation != null && this.vp instanceof XpSingularPort) {
            XpSingularPort sp = (XpSingularPort)this.vp;
            sp.setInterpolationHint(this.saveInterpolation);
            sp.repaint();
        }
    }

    protected void wwwl(double dx, double dy) {
        if (this.wwwlStyle) {
            double max = 0.0;
            double wwdelta = wwSensitivity * dx;
            double wldelta = wlSensitivity * dy;
            double ww = this.wlResponse.response(this.startWW, wwdelta);
            double wl = this.wlResponse.response(this.startWL, wldelta);
            double hww = ww * 0.5;
            double min = wl - hww;
            max = wl + hww;
            this.vp.setWinMinMax(min, max);
        } else {
            double maxdelta = -wlSensitivity * this.wlRange * this.rescaleSlope * dy;
            double max = this.startMax + maxdelta;
            if (max > this.vp.getWinMin()) {
                this.vp.setWinMax(max);
            } else {
                this.vp.setWinMax(this.vp.getWinMin());
            }
        }
        this.vp.repaint();
    }

    public WindowLevelCapable getTarget() {
        return this.vp;
    }
}

