/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.print;

import com.ge.med.terra.tap.print.ColFormat;
import com.ge.med.terra.tap.print.DicomPrintable;
import com.ge.med.terra.tap.print.ImageSource;
import com.ge.med.terra.tap.print.RowFormat;
import com.ge.med.terra.xpv.jfc.JavaFilmer;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.MultiDocPrintService;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobListener;
import javax.print.event.PrintServiceAttributeListener;

public class JavaPrintService
implements PrintService {
    static JavaPrintService me = new JavaPrintService();
    static myPrintServiceLookup mepsl = new myPrintServiceLookup();
    public static DocFlavor JFC_PRINTABLE;
    public static DocFlavor JFC_PAGEABLE;
    static int rows;
    static int cols;
    static Dimension imageSize;

    public static void main(String[] args) {
        JavaPrintService testPrintService1 = new JavaPrintService();
    }

    @Override
    public String getName() {
        return "JFC_PRINT";
    }

    @Override
    public DocPrintJob createPrintJob() {
        XPutil.getLogger().info("createPrintJob");
        return new myjob();
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        XPutil.getLogger().info("PrintServiceAttributeSet");
        return null;
    }

    public PrintServiceAttribute getAttribute(Class category) {
        XPutil.getLogger().info("getAttribute");
        return null;
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        XPutil.getLogger().info("getSupportedDocFlavors");
        return new DocFlavor[]{DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.SERVICE_FORMATTED.PAGEABLE, JFC_PRINTABLE, JFC_PAGEABLE};
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        XPutil.getLogger().info("isDocFlavorSupported");
        if (DocFlavor.SERVICE_FORMATTED.PRINTABLE == flavor) {
            return true;
        }
        if (DocFlavor.SERVICE_FORMATTED.PAGEABLE == flavor) {
            return true;
        }
        return flavor.getMimeType().equals(JFC_PRINTABLE.getMimeType());
    }

    public Class[] getSupportedAttributeCategories() {
        XPutil.getLogger().info("getSupportedAttributeCategories");
        return new Class[]{RowFormat.class, ColFormat.class};
    }

    public boolean isAttributeCategorySupported(Class category) {
        XPutil.getLogger().info("isAttributeCategorySupported");
        return category.equals(RowFormat.class) || category.equals(ColFormat.class);
    }

    public Object getDefaultAttributeValue(Class category) {
        XPutil.getLogger().info("getDefaultAttributeValue");
        if (category.equals(RowFormat.class)) {
            return new Integer(0);
        }
        if (category.equals(ColFormat.class)) {
            return new Integer(0);
        }
        return null;
    }

    public Object getSupportedAttributeValues(Class category, DocFlavor flavor, AttributeSet attributes) {
        XPutil.getLogger().info("getSupportedAttributeValues");
        return "";
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attrval, DocFlavor flavor, AttributeSet attributes) {
        return false;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        return null;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    static {
        boolean ret = PrintServiceLookup.registerServiceProvider(mepsl);
        System.err.println("installing javaPrintService");
        XPutil.getLogger().info("install=" + mepsl + "ret=" + ret);
        JFC_PRINTABLE = new DocFlavor("application/x-java-JFC-printable-print-service", "java.awt.print.Printable");
        JFC_PAGEABLE = new DocFlavor("application/x-java-JFC-pageable-print-service", "java.awt.print.Pageable");
        rows = 1;
        cols = 1;
        imageSize = new Dimension(512, 512);
    }

    public static class myPrintServiceLookup
    extends PrintServiceLookup {
        @Override
        public PrintService getDefaultPrintService() {
            return me;
        }

        @Override
        public PrintService[] getPrintServices() {
            return new PrintService[]{me};
        }

        @Override
        public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
            return null;
        }

        @Override
        public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
            if (DocFlavor.SERVICE_FORMATTED.PRINTABLE == flavor || DocFlavor.SERVICE_FORMATTED.PAGEABLE == flavor || flavor.getMimeType().equals(JFC_PRINTABLE.getMimeType())) {
                try {
                    JavaFilmer jf = new JavaFilmer();
                    jf.closeConnection();
                    return new PrintService[]{me};
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
    }

    public class myjob
    implements DocPrintJob {
        @Override
        public PrintService getPrintService() {
            return me;
        }

        @Override
        public PrintJobAttributeSet getAttributes() {
            return null;
        }

        @Override
        public void addPrintJobListener(PrintJobListener listener) {
        }

        @Override
        public void removePrintJobListener(PrintJobListener listener) {
        }

        @Override
        public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        }

        @Override
        public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        }

        @Override
        public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
            if (attributes != null) {
                ColFormat col;
                RowFormat row = (RowFormat)attributes.get(RowFormat.class);
                if (row != null) {
                    rows = row.getValue();
                }
                if ((col = (ColFormat)attributes.get(ColFormat.class)) != null) {
                    cols = col.getValue();
                }
            }
            try {
                Object obj = doc.getPrintData();
                final UMAIPrinterJob printerJob = new UMAIPrinterJob();
                if (doc.getDocFlavor() == DocFlavor.SERVICE_FORMATTED.PAGEABLE || doc.getDocFlavor() == JFC_PAGEABLE) {
                    printerJob.setPageable((Pageable)doc.getPrintData());
                } else if (doc.getDocFlavor() == DocFlavor.SERVICE_FORMATTED.PRINTABLE || doc.getDocFlavor() == JFC_PRINTABLE) {
                    printerJob.setPrintable((Printable)doc.getPrintData());
                } else if (doc.getPrintData() instanceof Printable) {
                    printerJob.setPrintable((Printable)doc.getPrintData());
                } else if (doc.getPrintData() instanceof Pageable) {
                    printerJob.setPrintable((Printable)doc.getPrintData());
                } else {
                    return;
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            // empty catch block
                        }
                    }
                });
                t.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        class UMAIPrinterJob
        extends PrinterJob {
            int numCopies = 1;
            String jobName = "default";
            Pageable document = null;
            Printable painter = null;
            PageFormat format = null;
            int imageNumSoFar;

            @Override
            public void setCopies(int copies) {
                this.numCopies = copies;
            }

            @Override
            public PageFormat validatePage(PageFormat page) {
                return page;
            }

            @Override
            public void setPageable(Pageable document) {
                this.document = document;
            }

            @Override
            public void setPrintable(Printable painter) {
                this.painter = painter;
            }

            @Override
            public void setPrintable(Printable painter, PageFormat format) {
                this.format = format;
            }

            @Override
            public boolean printDialog() {
                return false;
            }

            @Override
            public void print() throws PrinterException {
                Object imgSrc;
                if (this.painter != null) {
                    imgSrc = new ImageSource(){

                        public BufferedImage getBufferedImage(int id, int width, int height) {
                            BufferedImage bi = new BufferedImage(width, height, 5);
                            PageFormat fmt = new PageFormat();
                            Paper pp = new Paper();
                            pp.setSize(width, height);
                            pp.setImageableArea(0.0, 0.0, width, height);
                            fmt.setPaper(pp);
                            try {
                                UMAIPrinterJob.this.painter.print(bi.getGraphics(), fmt, id);
                            }
                            catch (PrinterException ex) {
                                return null;
                            }
                            return bi;
                        }

                        public int getNumberOfImages() {
                            return 1;
                        }

                        public String getESI(int id) {
                            if (UMAIPrinterJob.this.painter instanceof DicomPrintable) {
                                return ((DicomPrintable)UMAIPrinterJob.this.painter).getESIString();
                            }
                            return null;
                        }

                        public Dimension getImageDimension(int id) {
                            return imageSize;
                        }

                        public String imagePath(int index) {
                            if (UMAIPrinterJob.this.painter instanceof DicomPrintable) {
                                return ((DicomPrintable)UMAIPrinterJob.this.painter).getOriginalImagePath();
                            }
                            return null;
                        }
                    };
                    this.FilmPort((ImageSource)imgSrc);
                }
                if (this.document != null) {
                    imgSrc = new ImageSource(){

                        public BufferedImage getBufferedImage(int id, int width, int height) {
                            BufferedImage bi = new BufferedImage(width, height, 5);
                            Paper pp = new Paper();
                            pp.setSize(width, height);
                            pp.setImageableArea(0.0, 0.0, width, height);
                            PageFormat pf = new PageFormat();
                            pf.setPaper(pp);
                            try {
                                UMAIPrinterJob.this.document.getPrintable(id).print(bi.getGraphics(), pf, 0);
                            }
                            catch (PrinterException ex) {
                                ex.printStackTrace();
                                return null;
                            }
                            return bi;
                        }

                        public int getNumberOfImages() {
                            return UMAIPrinterJob.this.document.getNumberOfPages();
                        }

                        public String getESI(int id) {
                            Printable pt = UMAIPrinterJob.this.document.getPrintable(id);
                            if (pt instanceof DicomPrintable) {
                                return ((DicomPrintable)pt).getESIString();
                            }
                            return null;
                        }

                        public Dimension getImageDimension(int id) {
                            return imageSize;
                        }

                        public String imagePath(int id) {
                            Printable pt = UMAIPrinterJob.this.document.getPrintable(id);
                            if (pt instanceof DicomPrintable) {
                                return ((DicomPrintable)pt).getOriginalImagePath();
                            }
                            return null;
                        }
                    };
                    this.FilmPort((ImageSource)imgSrc);
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public String getJobName() {
                return null;
            }

            @Override
            public void setJobName(String jobName) {
                this.jobName = jobName;
            }

            @Override
            public void cancel() {
            }

            @Override
            public PageFormat defaultPage(PageFormat page) {
                return page;
            }

            @Override
            public int getCopies() {
                return 1;
            }

            @Override
            public String getUserName() {
                return null;
            }

            @Override
            public PageFormat pageDialog(PageFormat page) {
                return page;
            }

            private void FilmPort(ImageSource imgSrc) {
                try {
                    System.err.println("in FilmPort");
                    JavaFilmer filmer = new JavaFilmer(imgSrc);
                    filmer.film();
                    filmer.closeConnection();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

