/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.CuiSliderUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberedThumbSlider
extends JSlider {
    BufferedImage im;

    public NumberedThumbSlider() {
        this.myinit();
    }

    private void myinit() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberedThumbSlider.this.repaint();
            }
        });
    }

    public NumberedThumbSlider(BoundedRangeModel brm) {
        super(brm);
        this.myinit();
    }

    public NumberedThumbSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.myinit();
    }

    public NumberedThumbSlider(int min, int max, int value) {
        super(min, max, value);
        this.myinit();
    }

    public NumberedThumbSlider(int min, int max) {
        super(min, max);
        this.myinit();
    }

    public NumberedThumbSlider(int orientation) {
        super(orientation);
        this.myinit();
    }

    @Override
    public void updateUI() {
        this.setUI(new NumberedThumbSliderUI());
        this.updateLabelUIs();
    }

    public Rectangle getThumbRect() {
        return ((NumberedThumbSliderUI)this.getUI()).getThumbRect();
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.im == null || this.im.getWidth() != w || this.im.getHeight() != h) {
            this.im = new BufferedImage(w, h, 2);
        }
        Graphics2D g2 = this.im.createGraphics();
        super.paint(g2);
        Rectangle rect = this.getThumbRect();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2.getFontMetrics();
        String valString = "" + this.getValue();
        int sw = fm.stringWidth(valString);
        if (this.orientation == 0) {
            g2.drawString(valString, rect.x + (rect.width - sw >> 1) + 1, rect.y);
        } else {
            g2.drawString(valString, rect.x + rect.width + 1, rect.y + rect.height - 1 - (rect.height - fm.getHeight() >> 1));
        }
        g2.dispose();
        g.drawImage(this.im, 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        JLabel l = new JLabel("" + this.getValue());
        dim.height += l.getPreferredSize().height + 5;
        dim.width += l.getPreferredSize().width + 5;
        return dim;
    }

    public Dimension getMininumSize() {
        return this.getPreferredSize();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new CuiLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame();
                f.setContentPane(new NumberedThumbSlider(0));
                f.pack();
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
            }
        });
    }

    class NumberedThumbSliderUI
    extends CuiSliderUI {
        NumberedThumbSliderUI() {
        }

        public Rectangle getThumbRect() {
            return this.thumbRect;
        }
    }
}

