/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.PtkUtilities;
import com.ge.med.terra.xpv.ui.ComboButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class PaletteComboButton
extends ComboButton {
    protected ListCellRenderer defaultRenderer_;
    boolean borderLineShown_ = true;
    protected MouseListener mouseListener_;
    protected FocusListener focusListener_;
    protected Border[] borders_;
    protected static Border[][] staticBorders_;
    static Icon[] icons_;

    public PaletteComboButton() {
        this(new Vector());
    }

    public PaletteComboButton(Object[] buttons) {
        this((Vector)new Vector<Object>(Arrays.asList(buttons)));
    }

    protected void updateBorderLineShown(MouseEvent e) {
        if (!Boolean.getBoolean("PaletteComboButton.rollover")) {
            this.borderLineShown_ = true;
            return;
        }
        boolean mouseIn = e != null ? this.contains(SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this)) : false;
        Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean focusIn = Boolean.getBoolean("PaletteComboButton.focus") && focus != null ? SwingUtilities.isDescendingFrom(focus, this) : false;
        this.borderLineShown_ = mouseIn || focusIn;
    }

    protected MouseListener getMouseListener() {
        return this.mouseListener_ != null ? this.mouseListener_ : (this.mouseListener_ = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PaletteComboButton.this.updateBorderLineShown(e);
                PaletteComboButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PaletteComboButton.this.updateBorderLineShown(e);
                PaletteComboButton.this.repaint();
            }
        });
    }

    protected FocusListener getFocusListener() {
        return this.focusListener_ != null ? this.focusListener_ : (this.focusListener_ = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PaletteComboButton.this.updateBorderLineShown(null);
                PaletteComboButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                PaletteComboButton.this.updateBorderLineShown(null);
                PaletteComboButton.this.repaint();
            }
        });
    }

    protected Border getBorder(final boolean left) {
        boolean cbb = Boolean.getBoolean("PaletteComboButton.comboBorder");
        if (staticBorders_ == null) {
            int cornerMargin = (int)Math.ceil(Math.max(CuiLookAndFeel.getCornerRadius() - CuiLookAndFeel.getInteriorEdge(), 0.0) * (1.0 - Math.sqrt(2.0) / 2.0));
            staticBorders_ = new Border[][]{{new CuiBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, true, true, true}, new boolean[]{cbb, cbb, cbb, false}, new Insets(cornerMargin, cornerMargin, cornerMargin, cornerMargin), 0), new CompoundBorder(new CuiBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, true, true, false}, new boolean[]{cbb, cbb, cbb, false}, new Insets(cornerMargin, cornerMargin, cornerMargin, cornerMargin), 0), new MatteBorder(0, 0, 0, (int)Math.ceil(CuiLookAndFeel.getInteriorEdge()), UIManager.getColor("P8")))}, {new CuiBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, true, true, true}, new boolean[]{cbb, false, cbb, cbb}, new Insets(cornerMargin, cornerMargin, cornerMargin, cornerMargin), 0), new CompoundBorder(new CuiBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{0.0, 0.0, 0.0, 0.0}, new boolean[]{true, false, true, true}, new boolean[]{cbb, false, cbb, cbb}, new Insets(cornerMargin, cornerMargin, cornerMargin, cornerMargin), 0), new MatteBorder(0, (int)Math.ceil(CuiLookAndFeel.getInteriorEdge()), 0, 0, UIManager.getColor("P8")))}};
        }
        if (this.borders_ == null) {
            this.borders_ = new Border[2];
        }
        return this.borders_[left ? 0 : 1] != null ? this.borders_[left ? 0 : 1] : (this.borders_[left ? 0 : 1] = new CuiBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return staticBorders_[left ? 0 : 1][PaletteComboButton.this.borderLineShown_ ? 0 : 1].getBorderInsets(c);
            }

            @Override
            public boolean isBorderOpaque() {
                return staticBorders_[left ? 0 : 1][PaletteComboButton.this.borderLineShown_ ? 0 : 1].isBorderOpaque();
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                staticBorders_[left ? 0 : 1][PaletteComboButton.this.borderLineShown_ ? 0 : 1].paintBorder(c, g, x, y, w, h);
            }

            @Override
            public double getExteriorEdge() {
                return ((CuiBorder)staticBorders_[left ? 0 : 1][PaletteComboButton.this.borderLineShown_ ? 0 : 1]).getExteriorEdge();
            }

            @Override
            public boolean[] getExteriorEdgeVisible() {
                return ((CuiBorder)staticBorders_[left ? 0 : 1][PaletteComboButton.this.borderLineShown_ ? 0 : 1]).getExteriorEdgeVisible();
            }
        });
    }

    public PaletteComboButton(Vector buttons) {
        super(buttons);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractButton)PaletteComboButton.this.getSelectedItem()).doClick();
            }
        });
        this.setExpertMode(true);
        this.defaultRenderer_ = this.getRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                JLabel c = (JLabel)PaletteComboButton.this.defaultRenderer_.getListCellRendererComponent(list, value, index, selected, focus);
                if (!selected) {
                    c.setBorder(PtkBorderFactory.createButtonBorder(false, false, false, false));
                } else {
                    c.setBorder(new EmptyBorder(2, 2, 2, 2));
                }
                c.setBackground(UIManager.getColor(!selected ? "Button.background" : "Button.select"));
                return c;
            }
        });
        ((JButton)this.getClientProperty("ComboBox.button")).setBorder(this.getBorder(false));
        int popupBorder = Integer.getInteger("PaletteComboButton.popupBorder", 0);
        switch (popupBorder) {
            case 0: {
                ((JScrollPane)this.getClientProperty("ComboBox.scrollPane")).setViewportBorder(null);
                ((JPopupMenu)this.getClientProperty("ComboBox.popup")).setBorder(new EmptyBorder(0, 0, 0, 0));
                break;
            }
            case 1: {
                ((JPopupMenu)this.getClientProperty("ComboBox.popup")).setBorder(new EmptyBorder(0, 0, 0, 0));
                break;
            }
        }
        JButton b = (JButton)this.getClientProperty("ComboBox.button");
        b.addMouseListener(this.getMouseListener());
        if (Boolean.getBoolean("PaletteComboButton.focus")) {
            b.addFocusListener(this.getFocusListener());
        }
        this.setExpertMode(false);
        this.updateBorderLineShown(null);
    }

    @Override
    public String getUIClassID() {
        return "PaletteComboBoxUI";
    }

    @Override
    protected AbstractButton addButton(AbstractButton button) {
        super.addButton(button);
        button.setBorder(this.getBorder(true));
        button.addMouseListener(this.getMouseListener());
        if (Boolean.getBoolean("PaletteComboButton.focus")) {
            button.addFocusListener(this.getFocusListener());
        }
        return button;
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(System.getProperty("laf", "com.ge.med.ptk.laf.CuiLookAndFeel"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        UIManager.getLookAndFeelDefaults().put("PaletteComboBoxUI", "com.ge.med.terra.xpv.ui.CuiPaletteComboBoxUI");
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel(new FlowLayout());
        top.setBorder(new EmptyBorder(10, 10, 10, 10));
        Object[] buttons = new AbstractButton[8];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = new JButton("Button" + (i + 1));
            ((AbstractButton)buttons[i]).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(((AbstractButton)e.getSource()).getActionCommand());
                }
            });
        }
        PaletteComboButton combo1 = new PaletteComboButton(buttons);
        top.add(combo1);
        buttons = new AbstractButton[2];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = new JButton();
            ((AbstractButton)buttons[i]).setIcon(icons_[i]);
            ((AbstractButton)buttons[i]).setPressedIcon(icons_[i]);
            ((AbstractButton)buttons[i]).setMargin(new Insets(0, 0, 0, 0));
        }
        PaletteComboButton combo = new PaletteComboButton(buttons);
        top.add(combo);
        frame.getContentPane().add(top);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        icons_ = new Icon[]{new ImageIcon(PtkUtilities.getScaledImage("com/ge/med/terra/xpv/cuiIcons/return_default.gif")), new ImageIcon(PtkUtilities.getScaledImage("com/ge/med/terra/xpv/cuiIcons/dispaly_normal.gif"))};
    }
}

