/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.laf.CuiComboBoxUI;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class RowColumnCombo
extends JComboBox {
    public Dimension getValue() {
        return ((RowColumnComboBoxModel)this.getModel()).getSelected();
    }

    public void setValue(Dimension value) {
        ((RowColumnComboBoxModel)this.getModel()).setSelected(value);
    }

    public RowColumnCombo(Dimension dimension) {
        super(new RowColumnComboBoxModel(dimension));
    }

    public RowColumnCombo() {
        this(new Dimension(1, 1));
        Object obj = this.getClientProperty("ComboBox.button");
        if (obj instanceof JButton) {
            ((JButton)obj).setFocusable(false);
        }
    }

    @Override
    public String getUIClassID() {
        return "RowColumnComboUI";
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EmptyBorder border = new EmptyBorder(8, 8, 8, 8);
        Dimension size = new Dimension(120, 36);
        JFrame f = new JFrame("outside edge only");
        f.setDefaultCloseOperation(3);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(border);
        RowColumnCombo c = new RowColumnCombo();
        c.setPreferredSize(size);
        c.setEditable(false);
        p.add(c);
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
        c.setFocusable(false);
    }

    static {
        UIManager.put("RowColumnComboUI", RowColumnComboUI.class.getName());
        UIManager.put("RowColumnComboListUI", RowColumnComboListUI.class.getName());
    }

    public static class RowColumnComboUI
    extends CuiComboBoxUI {
        public static ComponentUI createUI(JComponent c) {
            return new RowColumnComboUI();
        }

        @Override
        protected ListCellRenderer createRenderer() {
            return new BasicComboBoxRenderer.UIResource(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, index >= 0 && isSelected, cellHasFocus);
                    this.setOpaque(index >= 0);
                    this.setEnabled(comboBox.isEnabled());
                    this.setHorizontalAlignment(0);
                    this.setBorder(new EmptyBorder(0, index >= 0 ? 2 : 0, 0, index >= 0 ? 2 : 0));
                    if (value instanceof Dimension) {
                        this.setText("" + ((Dimension)value).width + " x " + ((Dimension)value).height);
                    }
                    return this;
                }
            };
        }

        @Override
        protected ComboPopup createPopup() {
            return new CuiComboBoxUI.CuiComboPopup(this.comboBox){

                @Override
                protected MouseListener createMouseListener() {
                    return new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (!SwingUtilities.isLeftMouseButton(e) || !comboBox.isEnabled()) {
                                return;
                            }
                            if (comboBox.isEditable()) {
                                Component comp = comboBox.getEditor().getEditorComponent();
                                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                                    comp.requestFocus();
                                }
                            } else if (comboBox.isRequestFocusEnabled()) {
                                comboBox.requestFocus();
                            }
                            this.togglePopup();
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            Component source = (Component)e.getSource();
                            Dimension size = source.getSize();
                            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                            if (!bounds.contains(e.getPoint())) {
                                MouseEvent newEvent = this.convertMouseEvent(e);
                                Point location = newEvent.getPoint();
                                Rectangle r = new Rectangle();
                                list.computeVisibleRect(r);
                                if (r.contains(location)) {
                                    comboBox.setSelectedIndex(list.getSelectedIndex());
                                }
                                comboBox.setPopupVisible(false);
                            }
                            hasEntered = false;
                            this.stopAutoScrolling();
                        }
                    };
                }

                @Override
                protected MouseMotionListener createMouseMotionListener() {
                    return new MouseMotionAdapter(){

                        @Override
                        public void mouseDragged(MouseEvent e) {
                            if (!this.isVisible()) {
                                return;
                            }
                            MouseEvent newEvent = this.convertMouseEvent(e);
                            Rectangle r = new Rectangle();
                            list.computeVisibleRect(r);
                            if (newEvent.getPoint().y >= r.y && newEvent.getPoint().y <= r.y + r.height - 1) {
                                Point location;
                                hasEntered = true;
                                if (isAutoScrolling) {
                                    this.stopAutoScrolling();
                                }
                                if (r.contains(location = newEvent.getPoint())) {
                                    this.updateListBoxSelectionForEvent(newEvent, false);
                                }
                            } else if (hasEntered) {
                                int directionToScroll;
                                int n = directionToScroll = newEvent.getPoint().y < r.y ? 0 : 1;
                                if (isAutoScrolling && scrollDirection != directionToScroll) {
                                    this.stopAutoScrolling();
                                    this.startAutoScrolling(directionToScroll);
                                } else if (!isAutoScrolling) {
                                    this.startAutoScrolling(directionToScroll);
                                }
                            } else if (e.getPoint().y < 0) {
                                hasEntered = true;
                                this.startAutoScrolling(0);
                            }
                        }
                    };
                }

                @Override
                protected void startAutoScrolling(int i) {
                }

                protected JList createList() {
                    return new JList(this.comboBox.getModel()){

                        @Override
                        public String getUIClassID() {
                            return "RowColumnComboListUI";
                        }

                        @Override
                        public void setSelectedIndex(int index) {
                            RowColumnComboBoxModel model = (RowColumnComboBoxModel)this.getModel();
                            Dimension shown = model.getDimension();
                            Dimension actual = (Dimension)model.getElementAt(index);
                            shown = new Dimension(Math.min(8, Math.max(3, actual.width + 1)), Math.min(8, Math.max(3, actual.height + 1)));
                            model.setDimension(shown);
                            index = (actual.height - 1) * shown.width + actual.width - 1;
                            super.setSelectedIndex(index);
                            this.repaint();
                        }
                    };
                }

                @Override
                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 21, 31){};
                }
            };
        }
    }

    public static class RowColumnComboListUI
    extends ListUI {
        public static ComponentUI createUI(JComponent c) {
            return new RowColumnComboListUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(40, 40);
        }

        public Rectangle getCellBounds(JList list, int index1, int index2) {
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
            int index = Math.max(index1, index2);
            int r = index / shown.width;
            int c = index % shown.width;
            return new Rectangle((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
        }

        public Point indexToLocation(JList list, int index) {
            return this.getCellBounds(list, index, index).getLocation();
        }

        public int locationToIndex(JList list, Point location) {
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
            int c = (int)Math.floor((double)(location.x - i.left) / cellSize[0]);
            int r = (int)Math.floor((double)(location.y - i.top) / cellSize[1]);
            return r * shown.width + c;
        }

        @Override
        public void paint(Graphics g, JComponent component) {
            JList list = (JList)component;
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension actual = (Dimension)list.getSelectedValue();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
            for (int r = 0; r < shown.height; ++r) {
                for (int c = 0; c < shown.width; ++c) {
                    g.setColor(UIManager.getColor(r < actual.height && c < actual.width ? "P9" : "P5"));
                    g.fillRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
                    g.setColor(Color.white);
                    g.drawRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
                }
            }
        }
    }

    public static class RowColumnComboBoxModel
    implements ComboBoxModel {
        protected Dimension selected_ = new Dimension(1, 1);
        protected Dimension dimension_ = new Dimension(2, 2);
        protected List listeners_ = new ArrayList();

        public RowColumnComboBoxModel(Dimension dimension) {
            this.selected_ = new Dimension(dimension.width, dimension.height);
            this.dimension_ = new Dimension(dimension.width + 1, dimension.height + 1);
        }

        public RowColumnComboBoxModel() {
            this(new Dimension(1, 1));
        }

        public Dimension getSelected() {
            return this.selected_;
        }

        public void setSelected(Dimension selected) {
            this.selected_ = new Dimension(selected.width, selected.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.dimension_ = new Dimension(Math.max(this.selected_.width, this.dimension_.width), Math.max(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        public Dimension getDimension() {
            return this.dimension_;
        }

        public void setDimension(Dimension dimension) {
            this.dimension_ = new Dimension(dimension.width, dimension.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.selected_ = new Dimension(Math.min(this.selected_.width, this.dimension_.width), Math.min(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof Dimension) {
                this.setSelected((Dimension)anItem);
            }
        }

        @Override
        public int getSize() {
            return this.dimension_.width * this.dimension_.height;
        }

        @Override
        public Object getElementAt(int index) {
            return new Dimension(index % this.dimension_.width + 1, index / this.dimension_.width + 1);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners_.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners_.remove(l);
        }

        protected void fireListDataChanged() {
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            Iterator i = this.listeners_.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(event);
            }
        }
    }
}

