/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class WeakSingletonTaskManager {
    private static Reference ref = new WeakReference<Object>(null);

    public static void submit(Task task) {
        WorkerThread thread = (WorkerThread)ref.get();
        if (thread == null || !thread.isAlive()) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@WeakSingletonTaskManager.submit(): worker thread not found or dead!!!");
            WorkerThread t = new WorkerThread(task);
            ref = new WeakReference<WorkerThread>(t);
        } else {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@WeakSingletonTaskManager.submit(): add task to existing worker thread!!!");
            thread.add(task);
        }
    }

    public static void cancel(Task task) {
        WorkerThread t = (WorkerThread)ref.get();
        if (t != null && t.isAlive()) {
            t.cancel(task);
        }
    }

    public static boolean raisePriority(Task task, int ind, int len) {
        WorkerThread t = (WorkerThread)ref.get();
        if (t == null || !t.isAlive()) {
            return false;
        }
        t.raisePriority(task, ind, len);
        return true;
    }

    public static boolean waitForDone(Task task, int ind, int len) {
        WeakSingletonTaskManager.raisePriority(task, ind, len);
        WorkerThread t = (WorkerThread)ref.get();
        if (t == null || !t.isAlive()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            try {
                task.doStep(ind + i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static class WorkerThread
    extends Thread {
        Vector taskV = new Vector();
        Vector highPriorityTaskSteps = new Vector();
        Vector normalPriorityTaskSteps = new Vector();

        public WorkerThread(Task task) {
            super("WeakSingletonTaskManager");
            this.taskV.add(task);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Task task) {
            Task pp;
            int i;
            Vector vector = this.highPriorityTaskSteps;
            synchronized (vector) {
                i = 0;
                while (i < this.highPriorityTaskSteps.size()) {
                    pp = ((TaskStep)this.highPriorityTaskSteps.get((int)i)).task_;
                    if (pp == task) {
                        this.highPriorityTaskSteps.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            vector = this.normalPriorityTaskSteps;
            synchronized (vector) {
                i = 0;
                while (i < this.normalPriorityTaskSteps.size()) {
                    pp = ((TaskStep)this.normalPriorityTaskSteps.get((int)i)).task_;
                    if (pp == task) {
                        this.normalPriorityTaskSteps.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            if (this.highPriorityTaskSteps.isEmpty() && this.normalPriorityTaskSteps.isEmpty()) {
                this.interrupt();
            }
        }

        public void add(Task task) {
            this.taskV.add(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Task task = null;
                Vector vector = this.taskV;
                synchronized (vector) {
                    if (this.taskV.size() > 0) {
                        task = (Task)this.taskV.remove(0);
                    }
                }
                if (task != null) {
                    task.init();
                    vector = this.normalPriorityTaskSteps;
                    synchronized (vector) {
                        int len = task.getTotalSteps();
                        for (int i = 0; i < len; ++i) {
                            this.normalPriorityTaskSteps.add(new TaskStep(task, i));
                        }
                    }
                }
                TaskStep taskStep = null;
                Vector i = this.highPriorityTaskSteps;
                synchronized (i) {
                    if (this.highPriorityTaskSteps.size() > 0) {
                        taskStep = (TaskStep)this.highPriorityTaskSteps.remove(0);
                    }
                }
                if (taskStep != null) {
                    try {
                        taskStep.task_.doStep(taskStep.step_);
                    }
                    catch (InterruptedException e) {
                        this.cancel(taskStep.task_);
                        e.printStackTrace();
                    }
                    continue;
                }
                Vector e = this.normalPriorityTaskSteps;
                synchronized (e) {
                    if (this.normalPriorityTaskSteps.size() > 0) {
                        taskStep = (TaskStep)this.normalPriorityTaskSteps.remove(0);
                    }
                }
                if (taskStep == null) break;
                try {
                    taskStep.task_.doStep(taskStep.step_);
                }
                catch (InterruptedException e2) {
                    this.cancel(taskStep.task_);
                    e2.printStackTrace();
                }
            }
            System.out.println("WeakSingleton thread to die");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void raisePriority(Task task, int ind, int len) {
            Vector vector = this.highPriorityTaskSteps;
            synchronized (vector) {
                int i = 0;
                while (i < this.highPriorityTaskSteps.size()) {
                    Task t = ((TaskStep)this.highPriorityTaskSteps.get((int)i)).task_;
                    if (t == task) {
                        this.highPriorityTaskSteps.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (Boolean.getBoolean("WeakSingleton.normalOrder")) {
                    for (i = 0; i < len; ++i) {
                        this.highPriorityTaskSteps.add(new TaskStep(task, ind + i));
                    }
                } else {
                    for (i = len - 1; i >= 0; --i) {
                        this.highPriorityTaskSteps.add(new TaskStep(task, ind + i));
                    }
                }
            }
        }
    }

    static class TaskStep {
        Task task_;
        int step_;

        public TaskStep(Task t, int s) {
            this.task_ = t;
            this.step_ = s;
        }
    }

    public static interface Task {
        public static final String TASK_STEP_DONE_PROPERTY = "taskStepDone";

        public void init();

        public void doStep(int var1) throws InterruptedException;

        public int getTotalSteps();
    }
}

