/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import srjdom.SRCommon;

public class DataTagReadListener
implements TagReadListener {
    protected FileOutputStream outputStream;
    protected long tagOffset = 0L;
    protected int tagVRType = 0;
    protected long dataLength = 0L;
    private static final Logger LOGGER = Logger.getLogger(SRCommon.class.getName());

    @Override
    public void afterHeader(TagReadEvent readEvent) {
        if (readEvent.getDicomObject().getParent() == null) {
            LOGGER.log(Level.FINE, "Executing DataTagReadListener .");
            this.tagOffset = readEvent.getOffset();
            this.tagVRType = readEvent.getVRType();
            if (this.tagVRType == 22) {
                this.tagVRType = 24;
            }
            this.dataLength = readEvent.getDataElement().getValueLengthAsLong();
            readEvent.setDataReadStatus(1);
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder logMessage = new StringBuilder("Skipping Tag Data : tagVRType: " + this.tagVRType + ",tagOffset: " + this.tagOffset + ",dataLength: " + this.dataLength);
                LOGGER.log(Level.FINE, logMessage.toString());
            }
        } else {
            LOGGER.log(Level.FINE, "Skipping  DataTagReadListener .");
            readEvent.setDataReadStatus(0);
        }
    }

    public long getOffset() {
        return this.tagOffset;
    }

    public long getLength() {
        return this.dataLength;
    }

    public int getVRType() {
        return this.tagVRType;
    }

    public void setOutputStream(FileOutputStream fout) {
        this.outputStream = fout;
    }
}

