/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TagValue;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import srjdom.SRCommon;

public class DcmDOM {
    protected DicomObject dcmObj = null;
    protected DicomObject metaInfo = null;
    private Document dom = null;
    protected Element root = null;

    public DcmDOM() {
        SRCommon.logger.info("> DcmDOM()");
        this.dom = SRCommon.createDOM();
        if (this.dom != null) {
            this.root = this.dom.getDocumentElement();
        }
        SRCommon.logger.info("< DcmDOM()");
    }

    public DcmDOM(String sopCUID, String sopIUID, String trSyntaxUID, String impCUID) throws DicomException {
        this();
        SRCommon.logger.info("> DcmDOM(): " + sopIUID);
        this.dcmObj = new DicomObject();
        this.metaInfo = new DicomObject();
        this.dcmObj.setFileMetaInformation(this.metaInfo);
        byte[] b = new byte[]{0, 1};
        this.metaInfo.set(131073, b);
        this.metaInfo.set(131074, sopCUID);
        this.metaInfo.set(131075, sopIUID);
        this.metaInfo.set(131088, trSyntaxUID);
        this.metaInfo.set(131090, impCUID);
        this.dcmObj.set(524310, sopCUID);
        this.dcmObj.set(524312, sopIUID);
        SRCommon.logger.info("< DcmDOM()");
    }

    public void readDCM(String fileName) {
        this.readDCM(new File(fileName));
    }

    public void readDCM(File dcmFile) {
        SRCommon.logger.info("> readDCM()\tfile: " + dcmFile);
        this.dcmObj = SRCommon.openDCM(dcmFile);
        if (this.dcmObj != null) {
            this.metaInfo = this.dcmObj.getFileMetaInformation();
            this.buildDOM(this.metaInfo, this.root);
            this.buildDOM(this.dcmObj, this.root);
        }
        SRCommon.logger.info("< readDCM()");
    }

    public void readXML(File xmlFile, DefaultHandler saxHandler) throws IOException, SAXException, ParserConfigurationException {
        SRCommon.logger.info("> readXML()\tfile: " + xmlFile + "\tsaxHandler: " + saxHandler);
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(false);
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(xmlFile, saxHandler);
        SRCommon.logger.info("< readXML()");
    }

    protected void buildDOM(DicomObject dcm, Element rootNode) {
        SRCommon.logger.info("> buildDOM(): " + dcm);
        try {
            Element xmlTag = null;
            Text text = null;
            Enumeration e = dcm.enumerateVRs(true);
            TagValue tagVal = null;
            int gr = 0;
            int el = 0;
            while (e.hasMoreElements()) {
                tagVal = (TagValue)e.nextElement();
                if (tagVal == null) continue;
                gr = tagVal.getGroup();
                el = tagVal.getElement();
                int tagID = DDict.lookupDDict(gr, el);
                String vr2 = DDict.getTypeCodeName(tagID);
                xmlTag = this.createElement(tagID, gr, el, vr2);
                rootNode.appendChild(xmlTag);
                if ("SQ".equalsIgnoreCase(vr2)) {
                    SRCommon.logger.info("\t" + DDict.getDescription(tagID) + " size: " + dcm.getSize(tagID));
                    DicomObject seq = (DicomObject)dcm.get(tagID);
                    if (seq == null) continue;
                    for (int i = 0; i < dcm.getSize(tagID); ++i) {
                        DicomObject item = (DicomObject)dcm.get(tagID, i);
                        if (item == null) continue;
                        Element itemTag = this.dom.createElement(DDict.getDescription(-73728));
                        xmlTag.appendChild(itemTag);
                        this.buildDOM(item, itemTag);
                    }
                    continue;
                }
                String value = SRCommon.getJDTString(dcm, gr, el);
                if (value == null) continue;
                text = this.dom.createTextNode(value);
                xmlTag.appendChild(text);
            }
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< buildDOM()");
    }

    private Element createElement(int tagID, int gr, int el, String vr2) {
        Element xmlTag = null;
        String desc = DDict.getDescription(tagID);
        xmlTag = this.dom.createElement(desc);
        Attr idAttr = this.dom.createAttribute("tag");
        idAttr.setValue(this.padTagValue(Integer.toHexString(gr).toUpperCase()) + "," + this.padTagValue(Integer.toHexString(el).toUpperCase()));
        Attr vrAttr = this.dom.createAttribute("vr");
        vrAttr.setValue(vr2);
        xmlTag.setAttributeNode(idAttr);
        xmlTag.setAttributeNode(vrAttr);
        return xmlTag;
    }

    private String padTagValue(String tag2) {
        StringBuffer sb = new StringBuffer(tag2);
        int i = 0;
        while (sb.length() < 4) {
            sb.insert(0, "0");
            ++i;
        }
        return sb.toString();
    }

    public Document getDOM() {
        return this.dom;
    }

    public DicomObject getDicomObject() {
        return this.dcmObj;
    }

    public void writeXML() {
        SRCommon.logger.info("> writeXML()");
        this.writeDOM(new StreamResult(System.out));
        SRCommon.logger.info("< writeXML()");
    }

    public void writeXML(String fileName) {
        SRCommon.logger.info("> writeXML(): " + fileName);
        this.writeDOM(new StreamResult(fileName));
        SRCommon.logger.info("< writeXML()");
    }

    public void writeXML(File file) {
        SRCommon.logger.info("> writeXML(): " + file);
        if (file != null) {
            this.writeDOM(new StreamResult(file.getPath()));
        }
        SRCommon.logger.info("< writeXML()");
    }

    private void writeDOM(Result res) {
        SRCommon.logger.info("> writeDOM(): " + res.getSystemId());
        DOMSource source = new DOMSource(this.dom);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, res);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< writeDOM()");
    }
}

