/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import java.util.Calendar;
import java.util.Locale;
import srjdom.SRCommon;
import srjdom.SRString;

public class SRDateTime
extends SRString {
    public static final String DATE_SEP = "-";
    public static final String TIME_SEP = ":";
    public static final String DATETIME_SEP = "T";

    public SRDateTime(int tagID) {
        super(tagID);
    }

    public void setValue(int year, int month, int day, int hour, int minute, int second) {
        if (this.strValue != null) {
            this.strValue.setNodeValue(SRDateTime.createXMLDate(year, month, day) + DATETIME_SEP + SRDateTime.createXMLTime(hour, minute, second));
        }
    }

    @Override
    public void setValue(String datetime) {
        SRCommon.logger.info("> setValue(): " + datetime);
        if (datetime == null || datetime.indexOf(DATE_SEP) == 4) {
            super.setValue(datetime);
        } else if (datetime.length() <= 8) {
            super.setValue(SRDateTime.createXMLDate(datetime));
        } else if (datetime.length() > 8) {
            super.setValue(SRDateTime.createXMLDate(datetime.substring(0, 8)) + DATETIME_SEP + SRDateTime.createXMLTime(datetime.substring(8)));
        } else {
            super.setValue(datetime);
        }
    }

    public void setCurrent() {
        Calendar c = Calendar.getInstance();
        this.setValue(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public static String createXMLDate(int year, int month, int day) {
        SRCommon.logger.info("> createXMLDate()\tyear: " + year + "\tmonth: " + month + "\tday: " + day);
        StringBuffer strBuf = new StringBuffer().append(year).append(DATE_SEP).append(SRDateTime.toDoubleDigit(month)).append(DATE_SEP).append(SRDateTime.toDoubleDigit(day));
        if (year < 0 || month < 1 || month > 12 || day < 1) {
            throw new IllegalArgumentException("Illegal date: " + strBuf);
        }
        SRCommon.logger.info("< createXMLDate(): " + strBuf.toString());
        return strBuf.toString();
    }

    public static String createXMLDate(String date) {
        SRCommon.logger.info("> createXMLDate()\tdate: " + date);
        String xmlDate = null;
        if (date == null || date.length() <= 4 || date.indexOf(DATE_SEP) > -1) {
            xmlDate = date;
        } else if (date.length() <= 6) {
            String month = date.substring(4);
            xmlDate = date.substring(0, 4) + DATE_SEP + SRDateTime.toDoubleDigit(Integer.valueOf(month));
        } else if (date.length() <= 8) {
            String day = date.substring(6);
            xmlDate = date.substring(0, 4) + DATE_SEP + date.substring(4, 6) + DATE_SEP + SRDateTime.toDoubleDigit(Integer.valueOf(day));
        }
        SRCommon.logger.info("< createXMLDate(): " + xmlDate);
        return xmlDate;
    }

    public static String createXMLTime(int hour, int minute, int second) {
        StringBuffer strBuf = new StringBuffer(SRDateTime.toDoubleDigit(hour)).append(TIME_SEP).append(SRDateTime.toDoubleDigit(minute)).append(TIME_SEP).append(SRDateTime.toDoubleDigit(second));
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
            throw new IllegalArgumentException("Illegal time: " + strBuf);
        }
        return strBuf.toString();
    }

    public static String createXMLTime(String time) {
        if (time == null || time.length() <= 2 || time.indexOf(TIME_SEP) >= 0) {
            return time;
        }
        String timePart = time;
        String utcOffset = "";
        int utcOffsetIndex = Math.max(timePart.indexOf(DATE_SEP), timePart.indexOf("+"));
        if (utcOffsetIndex > -1) {
            utcOffset = timePart.substring(utcOffsetIndex);
            timePart = timePart.substring(0, utcOffsetIndex);
        }
        StringBuffer strBuf = new StringBuffer(timePart.substring(0, 2));
        if (timePart.length() >= 4) {
            strBuf.append(TIME_SEP);
            strBuf.append(timePart.substring(2, 4));
        }
        if (timePart.length() > 4) {
            strBuf.append(TIME_SEP);
            strBuf.append(timePart.substring(4));
        }
        strBuf.append(utcOffset);
        return strBuf.toString();
    }

    public static String xsDateToDICOM(String date) {
        return date == null ? date : date.replaceAll(DATE_SEP, "");
    }

    public static String xsTimeToDICOM(String time) {
        return time == null ? time : time.replaceAll(TIME_SEP, "");
    }

    public static String xsdDateTimeToDICOM(String datetime) {
        String dt = null;
        if (datetime != null) {
            int sepIndex = datetime.indexOf(DATETIME_SEP);
            if (sepIndex == -1) {
                dt = SRDateTime.xsDateToDICOM(datetime);
            } else {
                String date = datetime.substring(0, sepIndex);
                String time = datetime.substring(sepIndex + 1);
                dt = SRDateTime.xsDateToDICOM(date) + SRDateTime.xsTimeToDICOM(time);
            }
        }
        return dt;
    }

    private static String toDoubleDigit(Object value) {
        return String.format(Locale.US, "%02d", value);
    }
}

