/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import srjdom.IssuerOfPatientIDMacro;
import srjdom.PatientIDsItem;
import srjdom.SRCode;
import srjdom.SRCodeItem;
import srjdom.SRCommon;
import srjdom.SRCompositeItem;
import srjdom.SRContainerItem;
import srjdom.SRContentItem;
import srjdom.SRContentTemplateItem;
import srjdom.SRDOMDoc;
import srjdom.SRDateItem;
import srjdom.SRDateTime;
import srjdom.SRDateTimeItem;
import srjdom.SRGraphicType;
import srjdom.SRImageItem;
import srjdom.SRNumItem;
import srjdom.SRPNameItem;
import srjdom.SRReferencedItem;
import srjdom.SRRelationshipType;
import srjdom.SRSCoordItem;
import srjdom.SRSOPRefItem;
import srjdom.SRSeriesRefItem;
import srjdom.SRString;
import srjdom.SRStudyRefItem;
import srjdom.SRTCoordItem;
import srjdom.SRTemporalRangeType;
import srjdom.SRTextItem;
import srjdom.SRTimeItem;
import srjdom.SRUIDRefItem;
import srjdom.SRValueType;
import srjdom.SRVerifyingObsItem;
import srjdom.SRWaveformItem;

public class SRSAXHandler
extends DefaultHandler {
    private StringBuffer charContent = new StringBuffer();
    private SRDOMDoc srDOMDoc = null;
    private boolean inCodeSeq = false;
    private boolean inMeasuredValueSeq = false;
    private boolean inContentTemplateSeq = false;
    private boolean inVerifObsSeq = false;
    private boolean inVerifObsIdCodeSeq = false;
    private boolean inOtherPatientIDsSeq = false;
    private boolean inReferencedSOPSeq = false;
    private boolean inReferencedSeriesSeq = false;
    private boolean inPredecessorDocSeq = false;
    private boolean inIdenticalDocSeq = false;
    private boolean inCurrentReqProcEvidenceSeq = false;
    private int contentSeqLevel = -1;
    private int itemLevel = 0;
    private String patientID = null;
    private String issuerOfPatientID = null;
    private String typeOfPatientID = null;
    private String codeValue = null;
    private String schemeDesignator = null;
    private String schemeVersion = null;
    private String codeMeaning = null;
    private SRCode conceptName = null;
    private String mappingResource = null;
    private String templateIdentifier = null;
    private SRContentTemplateItem contentTempItem = null;
    private Stack<SRContentItem> contentItemStack = new Stack();
    private SRContentItem topContentItem = null;
    private SRContentItem contentItem = null;
    private SRRelationshipType relationshipType = null;
    private SRValueType valueType = null;
    private SRDateTime obsDateTime = null;
    private String value = null;
    private SRCode conceptCode = null;
    private SRCode unitCode = null;
    private String refSOPClassUID = null;
    private String refSOPInstanceUID = null;
    private String refFrameNumber = null;
    private SRSOPRefItem sopRefItem = null;
    private String verifObsName = null;
    private String verifOrg = null;
    private String verifDateTime = null;
    private SRCode verifObsIdCode = null;
    private SRSeriesRefItem seriesRefItem = null;
    private SRStudyRefItem studyRefItem = null;
    private String seriesInstanceUID = null;
    private String studyInstanceUID = null;
    private SRString referencedContentItemIdentifier = null;
    private String graphData = null;
    private SRGraphicType graphType = null;
    private SRTemporalRangeType temporalRangeType = null;
    private String referencedTimeOffsets = null;

    public SRSAXHandler(SRDOMDoc srDOM) {
        this.srDOMDoc = srDOM;
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: java srjdom.SRSAXHandler [URI]");
            System.exit(0);
        }
        String uri = argv[0];
        SRDOMDoc srDOMDocument = new SRDOMDoc();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setNamespaceAware(false);
            SRSAXHandler srSAXHandler = new SRSAXHandler(srDOMDocument);
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(uri, (DefaultHandler)srSAXHandler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charContent.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("MetaElementGroupLength")) {
            this.srDOMDoc.metaElementGroupLength.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("FileMetaInformationVersion")) {
            this.srDOMDoc.fileMetaInformationVersion.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("MediaStorageSOPClassUID")) {
            this.srDOMDoc.mediaStorageSOPClassUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("MediaStorageSOPInstanceUID")) {
            this.srDOMDoc.mediaStorageSOPInstanceUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("TransferSyntaxUID")) {
            this.srDOMDoc.transferSyntaxUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ImplementationClassUID")) {
            this.srDOMDoc.implementationClassUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ImplementationVersionName")) {
            this.srDOMDoc.implementationVersionName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SourceApplicationEntityTitle")) {
            this.srDOMDoc.sourceApplicationEntityTitle.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SpecificCharacterSet")) {
            this.srDOMDoc.specificCharacterSet.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstanceCreationDate")) {
            this.srDOMDoc.instanceCreationDate.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstanceCreationTime")) {
            this.srDOMDoc.instanceCreationTime.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstanceCreatorUID")) {
            this.srDOMDoc.instanceCreatorUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SOPClassUID")) {
            this.srDOMDoc.sopClassUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SOPInstanceUID")) {
            this.srDOMDoc.sopInstanceUID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("StudyDate")) {
            this.srDOMDoc.studyDate.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ContentDate")) {
            this.srDOMDoc.contentDate.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("StudyTime")) {
            this.srDOMDoc.studyTime.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ContentTime")) {
            this.srDOMDoc.contentTime.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("AccessionNumber")) {
            this.srDOMDoc.accessionNumber.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("Modality")) {
            this.srDOMDoc.modality.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("Manufacturer")) {
            this.srDOMDoc.manufacturer.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstitutionName")) {
            this.srDOMDoc.institutionName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstitutionAddress")) {
            this.srDOMDoc.institutionAddress.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ReferringPhysiciansName")) {
            this.srDOMDoc.referringPhysicianName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("CodeValue")) {
            this.codeValue = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("CodingSchemeDesignator")) {
            this.schemeDesignator = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("CodingSchemeVersion")) {
            this.schemeVersion = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("CodeMeaning")) {
            this.codeMeaning = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("MappingResource")) {
            this.mappingResource = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("StationName")) {
            this.srDOMDoc.stationName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("StudyDescription")) {
            this.srDOMDoc.studyDescription.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SeriesDescription")) {
            this.srDOMDoc.seriesDescription.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstitutionalDepartmentName")) {
            this.srDOMDoc.institutionalDepartmentName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ManufacturerModelName")) {
            this.srDOMDoc.manufacturersModelName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ReferencedSeriesSequence")) {
            this.inReferencedSeriesSeq = false;
        } else if (qName.equalsIgnoreCase("ReferencedSOPClassUID")) {
            this.refSOPClassUID = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ReferencedSOPInstanceUID")) {
            this.refSOPInstanceUID = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ReferencedFrameNumber")) {
            this.refFrameNumber = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ReferencedSOPSequence")) {
            this.inReferencedSOPSeq = false;
        } else if (qName.equalsIgnoreCase("PatientName")) {
            this.srDOMDoc.patientName.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientID")) {
            if (this.inOtherPatientIDsSeq) {
                this.patientID = this.charContent.toString();
            } else {
                this.srDOMDoc.patientID.setValue(this.charContent.toString());
            }
        } else if (qName.equalsIgnoreCase("IssuerOfPatientID")) {
            if (this.inOtherPatientIDsSeq) {
                this.issuerOfPatientID = this.charContent.toString();
            } else {
                this.srDOMDoc.issuerOfPatientIDMacro.setValue(this.charContent.toString());
            }
        } else if (qName.equalsIgnoreCase("TypeOfPatientID")) {
            if (this.inOtherPatientIDsSeq) {
                this.typeOfPatientID = this.charContent.toString();
            }
        } else if (qName.equalsIgnoreCase("PatientBirthDate")) {
            this.srDOMDoc.patientBirthDate.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientBirthTime")) {
            this.srDOMDoc.patientBirthTime.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientSex")) {
            this.srDOMDoc.patientSex.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("OtherPatientID")) {
            this.srDOMDoc.otherPatientIDs.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("OtherPatientIDsSequence")) {
            this.inOtherPatientIDsSeq = false;
        } else if (qName.equalsIgnoreCase("PatientAge")) {
            this.srDOMDoc.patientAge.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientSize")) {
            this.srDOMDoc.patientSize.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientWeight")) {
            this.srDOMDoc.patientWeight.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("EthnicGroup")) {
            this.srDOMDoc.ethnicGroup.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("Occupation")) {
            this.srDOMDoc.occupation.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("AdditionalPatientHistory")) {
            this.srDOMDoc.additionalPatientHistory.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PatientComments")) {
            this.srDOMDoc.patientComments.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("DeviceSerialNumber")) {
            this.srDOMDoc.deviceSerialNumber.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("StudyInstanceUID")) {
            if (this.itemLevel > 0) {
                this.studyInstanceUID = this.charContent.toString();
            } else {
                this.srDOMDoc.studyInstanceUID.setValue(this.charContent.toString());
            }
        } else if (qName.equalsIgnoreCase("SeriesInstanceUID")) {
            if (this.itemLevel > 0) {
                this.seriesInstanceUID = this.charContent.toString();
            } else {
                this.srDOMDoc.seriesInstanceUID.setValue(this.charContent.toString());
            }
        } else if (qName.equalsIgnoreCase("StudyID")) {
            this.srDOMDoc.studyID.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("SeriesNumber")) {
            this.srDOMDoc.seriesNumber.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("InstanceNumber")) {
            this.srDOMDoc.instanceNumber.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("PrivateCreator")) {
            this.srDOMDoc.privateCreator.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ApplicationSpecificData")) {
            this.srDOMDoc.appSpecificData.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("MeasurementUnitsCodeSequence")) {
            this.inCodeSeq = false;
            this.unitCode = new SRCode(this.codeValue, this.schemeDesignator, this.schemeVersion, this.codeMeaning);
        } else if (qName.equalsIgnoreCase("RelationshipType")) {
            this.relationshipType = SRRelationshipType.getRelationshipType(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("VerifyingOrganization")) {
            this.verifOrg = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("VerificationDateTime")) {
            this.verifDateTime = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ObservationDateTime")) {
            if (this.contentSeqLevel >= 0) {
                this.obsDateTime = new SRDateTime(4235314);
                this.obsDateTime.setValue(this.charContent.toString());
            } else {
                this.srDOMDoc.observationDateTime.setValue(this.charContent.toString());
            }
        } else if (qName.startsWith("ValueType")) {
            if (this.contentSeqLevel >= 0) {
                this.valueType = SRValueType.getValueType(this.charContent.toString());
            } else {
                this.srDOMDoc.valueType.setValue(this.charContent.toString());
            }
        } else if (qName.equalsIgnoreCase("ConceptNameCodeSequence")) {
            this.inCodeSeq = false;
            if (this.contentSeqLevel >= 0) {
                this.conceptName = new SRCode(this.codeValue, this.schemeDesignator, this.schemeVersion, this.codeMeaning);
            } else {
                this.srDOMDoc.documentTitle.setValue(this.codeValue, this.schemeDesignator, this.schemeVersion, this.codeMeaning);
            }
        } else if (qName.equalsIgnoreCase("ContinuityOfContent")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("VerifyingObserverSequence")) {
            this.inVerifObsSeq = false;
        } else if (qName.equalsIgnoreCase("VerifyingObserverIdentificationCodeSequence")) {
            this.inVerifObsIdCodeSeq = false;
            this.verifObsIdCode = new SRCode(this.codeValue, this.schemeDesignator, this.schemeVersion, this.codeMeaning);
        } else if (qName.equalsIgnoreCase("VerifyingObserverName")) {
            this.verifObsName = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("DateTime")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("Date")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("Time")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("PersonName")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("UID")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("TemporalRangeType")) {
            this.temporalRangeType = SRTemporalRangeType.getTemporalRangeType(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ReferencedTimeOffsets")) {
            this.referencedTimeOffsets = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("TextValue")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ConceptCodeSequence")) {
            this.inCodeSeq = false;
            this.conceptCode = new SRCode(this.codeValue, this.schemeDesignator, this.schemeVersion, this.codeMeaning);
        } else if (qName.equalsIgnoreCase("MeasuredValueSequence")) {
            this.inMeasuredValueSeq = false;
        } else if (qName.equalsIgnoreCase("NumericValue")) {
            this.value = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("PredecessorDocumentsSequence")) {
            this.inPredecessorDocSeq = false;
        } else if (qName.equalsIgnoreCase("CurrentRequestedProcedureEvidenceSequence")) {
            this.inCurrentReqProcEvidenceSeq = false;
        } else if (qName.equalsIgnoreCase("CompletionFlag")) {
            this.srDOMDoc.completionFlag.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("CompletionFlagDescription")) {
            this.srDOMDoc.completionFlagDescription.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("VerificationFlag")) {
            this.srDOMDoc.verificationFlag.setValue(this.charContent.toString());
        } else if (qName.equalsIgnoreCase("ContentTemplateSequence")) {
            this.inContentTemplateSeq = false;
            if (this.mappingResource != null || this.templateIdentifier != null) {
                this.contentTempItem = new SRContentTemplateItem(this.mappingResource, this.templateIdentifier);
            }
            if (this.contentTempItem != null && this.contentSeqLevel < 0) {
                this.srDOMDoc.contentTemplateSeq.appendChild(this.contentTempItem);
            }
        } else if (qName.equalsIgnoreCase("IdenticalDocumentsSequence")) {
            this.inIdenticalDocSeq = false;
        } else if (qName.equalsIgnoreCase("ContentSequence")) {
            --this.contentSeqLevel;
            this.contentItem = this.contentItemStack.size() > 0 ? this.contentItemStack.pop() : null;
            this.topContentItem = this.contentItemStack.size() > 0 ? this.contentItemStack.peek() : null;
        } else if (qName.equalsIgnoreCase("TemplateIdentifier")) {
            this.templateIdentifier = this.charContent.toString();
        } else if (qName.equalsIgnoreCase("ReferencedContentItemIdentifier")) {
            this.referencedContentItemIdentifier = new SRString(4250483, this.charContent.toString());
        } else if (qName.equalsIgnoreCase("GraphicData")) {
            this.graphData = this.charContent.toString();
            if (this.contentItem != null && this.contentItem instanceof SRSCoordItem) {
                ((SRSCoordItem)this.contentItem).graphicData.setValue(this.graphData);
            }
        } else if (qName.equalsIgnoreCase("GraphicType")) {
            this.graphType = SRGraphicType.getGraphicType(this.charContent.toString());
            if (this.contentItem != null && this.contentItem instanceof SRSCoordItem) {
                ((SRSCoordItem)this.contentItem).graphicType.setValue(this.graphType.toString());
            }
        } else if (qName.equalsIgnoreCase("Item")) {
            --this.itemLevel;
            if (this.isContentItem()) {
                if (this.contentItem == null) {
                    SRContentItem contItem = this.createContentItem(false);
                    if (this.srDOMDoc.appSpecificData != null && !this.srDOMDoc.appSpecificData.getValue().equalsIgnoreCase("")) {
                        contItem.xmlTag.setAttribute("app", this.srDOMDoc.appSpecificData.getValue());
                    }
                    if (this.contentItemStack.size() > 0) {
                        this.topContentItem.contentSeq.appendChild(contItem);
                    } else {
                        this.srDOMDoc.contentSeq.appendChild(contItem);
                    }
                } else {
                    this.contentItem = null;
                }
            } else if (this.inOtherPatientIDsSeq) {
                IssuerOfPatientIDMacro issuerOfPatientIDMacro = new IssuerOfPatientIDMacro();
                issuerOfPatientIDMacro.setValue(this.issuerOfPatientID);
                PatientIDsItem patientIDsItem = new PatientIDsItem(this.patientID, issuerOfPatientIDMacro, PatientIDsItem.PatientIDType.valueOf(this.typeOfPatientID));
                this.srDOMDoc.otherPatientIDsSeq.appendChild(patientIDsItem);
            } else if (this.inVerifObsSeq && !this.inVerifObsIdCodeSeq) {
                SRVerifyingObsItem verifObs = new SRVerifyingObsItem(this.verifObsName, this.verifOrg, this.verifDateTime, this.verifObsIdCode);
                this.srDOMDoc.verifyingObserverSeq.appendChild(verifObs);
            } else if (this.inReferencedSOPSeq) {
                this.sopRefItem = new SRSOPRefItem(this.refSOPClassUID, this.refSOPInstanceUID);
            } else if (this.inReferencedSeriesSeq) {
                this.seriesRefItem = new SRSeriesRefItem(this.sopRefItem, this.seriesInstanceUID);
            } else if (this.inPredecessorDocSeq) {
                this.studyRefItem = new SRStudyRefItem(this.seriesRefItem, this.studyInstanceUID);
                this.srDOMDoc.predecessorDocumentsSeq.appendChild(this.studyRefItem);
            } else if (this.inCurrentReqProcEvidenceSeq) {
                this.studyRefItem = new SRStudyRefItem(this.seriesRefItem, this.studyInstanceUID);
                this.srDOMDoc.currentReqProcEvidenceSeq.appendChild(this.studyRefItem);
            } else if (this.inIdenticalDocSeq) {
                this.studyRefItem = new SRStudyRefItem(this.seriesRefItem, this.studyInstanceUID);
                this.srDOMDoc.identicalDocumentsSeq.appendChild(this.studyRefItem);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.charContent.delete(0, this.charContent.length());
        if (qName.equalsIgnoreCase("ReferencedSeriesSequence")) {
            this.inReferencedSeriesSeq = true;
            this.seriesRefItem = null;
            this.seriesInstanceUID = null;
        } else if (qName.equalsIgnoreCase("ReferencedSOPSequence")) {
            this.inReferencedSOPSeq = true;
            this.resetSOPReferenceFields();
        } else if (qName.equalsIgnoreCase("OtherPatientIDsSequence")) {
            this.inOtherPatientIDsSeq = true;
        } else if (qName.equalsIgnoreCase("MeasurementUnitsCodeSequence")) {
            this.inCodeSeq = true;
            this.resetCodeFields();
            this.unitCode = null;
        } else if (qName.equalsIgnoreCase("ConceptNameCodeSequence")) {
            this.inCodeSeq = true;
            this.resetCodeFields();
            this.conceptName = null;
        } else if (qName.equalsIgnoreCase("VerifyingObserverSequence")) {
            this.inVerifObsSeq = true;
            this.verifObsName = null;
            this.verifOrg = null;
            this.verifDateTime = null;
        } else if (qName.equalsIgnoreCase("VerifyingObserverIdentificationCodeSequence")) {
            this.inVerifObsIdCodeSeq = true;
            this.resetCodeFields();
        } else if (qName.equalsIgnoreCase("ConceptCodeSequence")) {
            this.inCodeSeq = true;
            this.resetCodeFields();
            this.conceptCode = null;
        } else if (qName.equalsIgnoreCase("MeasuredValueSequence")) {
            this.inMeasuredValueSeq = true;
        } else if (qName.equalsIgnoreCase("PredecessorDocumentsSequence")) {
            this.inPredecessorDocSeq = true;
            this.resetStudyRefFields();
        } else if (qName.equalsIgnoreCase("CurrentRequestedProcedureEvidenceSequence")) {
            this.inCurrentReqProcEvidenceSeq = true;
            this.resetStudyRefFields();
        } else if (qName.equalsIgnoreCase("ContentTemplateSequence")) {
            this.inContentTemplateSeq = true;
            this.contentTempItem = null;
            this.mappingResource = null;
            this.templateIdentifier = null;
        } else if (qName.equalsIgnoreCase("IdenticalDocumentsSequence")) {
            this.inIdenticalDocSeq = true;
            this.resetStudyRefFields();
        } else if (qName.equalsIgnoreCase("ContentSequence")) {
            ++this.contentSeqLevel;
            if (this.contentSeqLevel > 0) {
                SRContentItem contItem = this.createContentItem(true);
                if (this.srDOMDoc.appSpecificData != null && !this.srDOMDoc.appSpecificData.getValue().equalsIgnoreCase("")) {
                    contItem.xmlTag.setAttribute("app", this.srDOMDoc.appSpecificData.getValue());
                }
                if (this.contentItemStack.size() > 0) {
                    this.topContentItem.contentSeq.appendChild(contItem);
                } else {
                    this.srDOMDoc.contentSeq.appendChild(contItem);
                }
                this.contentItemStack.push(contItem);
                this.topContentItem = contItem;
            }
            SRCommon.logger.info("contentSeqLevel: " + this.contentSeqLevel + "\tcontentItemStack.size(): " + this.contentItemStack.size());
        } else if (qName.equalsIgnoreCase("Item")) {
            ++this.itemLevel;
            if (this.isContentItem()) {
                SRCommon.logger.info("\tid: " + attributes.getValue("id"));
                this.resetContentItemFields();
            }
        }
    }

    private boolean isContentItem() {
        return this.contentSeqLevel >= 0 && !this.inOtherPatientIDsSeq && !this.inCodeSeq && !this.inMeasuredValueSeq && !this.inContentTemplateSeq && !this.inVerifObsSeq && !this.inVerifObsIdCodeSeq && !this.inPredecessorDocSeq && !this.inCurrentReqProcEvidenceSeq && !this.inReferencedSeriesSeq && !this.inReferencedSOPSeq;
    }

    private void resetCodeFields() {
        this.codeValue = null;
        this.schemeDesignator = null;
        this.schemeVersion = null;
        this.codeMeaning = null;
    }

    private void resetStudyRefFields() {
        this.studyRefItem = null;
        this.studyInstanceUID = null;
    }

    private void resetSOPReferenceFields() {
        this.refSOPClassUID = null;
        this.refSOPInstanceUID = null;
    }

    private void resetContentItemFields() {
        this.relationshipType = null;
        this.obsDateTime = null;
        this.valueType = null;
        this.resetCodeFields();
        this.conceptName = null;
        this.value = null;
        this.conceptCode = null;
        this.unitCode = null;
        this.graphData = null;
        this.graphType = null;
        this.contentTempItem = null;
    }

    private SRContentItem createContentItem(boolean hasContentSeq) {
        SRContentItem contItem = null;
        SRCommon.logger.info("\tValueType: " + this.valueType);
        if (this.valueType == SRValueType.VT_CONTAINER) {
            contItem = new SRContainerItem(this.relationshipType, this.obsDateTime, this.conceptName, this.value, this.contentTempItem, hasContentSeq);
        } else if (this.valueType == SRValueType.VT_TEXT) {
            contItem = new SRTextItem(this.relationshipType, this.obsDateTime, this.conceptName, this.value, hasContentSeq);
        } else if (this.valueType == SRValueType.VT_CODE) {
            contItem = new SRCodeItem(this.relationshipType, this.obsDateTime, this.conceptName, this.conceptCode, hasContentSeq);
        } else if (this.valueType == SRValueType.VT_NUM) {
            contItem = new SRNumItem(this.relationshipType, this.obsDateTime, this.conceptName, this.unitCode, new Double(this.value), hasContentSeq);
        } else if (this.valueType == SRValueType.VT_PNAME) {
            contItem = new SRPNameItem(this.relationshipType, this.obsDateTime, this.conceptName, hasContentSeq);
            ((SRPNameItem)contItem).personName.setValue(this.value);
        } else if (this.valueType == SRValueType.VT_DATE) {
            contItem = new SRDateItem(this.relationshipType, this.obsDateTime, this.conceptName, hasContentSeq);
            ((SRDateItem)contItem).date.setValue(this.value);
        } else if (this.valueType == SRValueType.VT_TIME) {
            contItem = new SRTimeItem(this.relationshipType, this.obsDateTime, this.conceptName, hasContentSeq);
            ((SRTimeItem)contItem).time.setValue(this.value);
        } else if (this.valueType == SRValueType.VT_DATETIME) {
            contItem = new SRDateTimeItem(this.relationshipType, this.obsDateTime, this.conceptName, hasContentSeq);
            ((SRDateTimeItem)contItem).dateTime.setValue(this.value);
        } else {
            contItem = this.valueType == SRValueType.VT_UIDREF ? new SRUIDRefItem(this.relationshipType, this.obsDateTime, this.conceptName, this.value, hasContentSeq) : (this.valueType == SRValueType.VT_COMPOSITE ? new SRCompositeItem(this.relationshipType, this.obsDateTime, this.conceptName, this.refSOPClassUID, this.refSOPInstanceUID, hasContentSeq) : (this.valueType == SRValueType.VT_IMAGE ? new SRImageItem(this.relationshipType, this.obsDateTime, this.conceptName, this.refSOPClassUID, this.refSOPInstanceUID, this.refFrameNumber, null, null, hasContentSeq) : (this.valueType == SRValueType.VT_WAVEFORM ? new SRWaveformItem(this.relationshipType, this.obsDateTime, this.conceptName, this.refSOPClassUID, this.refSOPInstanceUID, null, hasContentSeq) : (this.valueType == SRValueType.VT_SCOORD ? new SRSCoordItem(this.relationshipType, this.obsDateTime, this.conceptName, this.graphData == null ? "0.0\\0.0" : this.graphData, this.graphType == null ? SRGraphicType.GT_POINT : this.graphType, hasContentSeq) : (this.valueType == SRValueType.VT_TCOORD ? new SRTCoordItem(this.relationshipType, this.obsDateTime, this.conceptName, this.temporalRangeType, this.referencedTimeOffsets, hasContentSeq) : new SRReferencedItem(this.relationshipType, this.referencedContentItemIdentifier))))));
        }
        return contItem;
    }
}

