/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public abstract class MXBeanMapping {
    private final Type javaType;
    private final OpenType<?> openType;
    private final Class<?> openClass;

    protected MXBeanMapping(Type javaType, OpenType<?> openType) {
        if (javaType == null || openType == null) {
            throw new NullPointerException("Null argument");
        }
        this.javaType = javaType;
        this.openType = openType;
        this.openClass = MXBeanMapping.makeOpenClass(javaType, openType);
    }

    public final Type getJavaType() {
        return this.javaType;
    }

    public final OpenType<?> getOpenType() {
        return this.openType;
    }

    public final Class<?> getOpenClass() {
        return this.openClass;
    }

    private static Class<?> makeOpenClass(Type javaType, OpenType<?> openType) {
        if (javaType instanceof Class && ((Class)javaType).isPrimitive()) {
            return (Class)javaType;
        }
        try {
            String className = openType.getClassName();
            return Class.forName(className, false, MXBeanMapping.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Object fromOpenValue(Object var1) throws InvalidObjectException;

    public abstract Object toOpenValue(Object var1) throws OpenDataException;

    public void checkReconstructible() throws InvalidObjectException {
    }
}

