/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static long negativeZeroFloatBits = Float.floatToRawIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToRawLongBits(-0.0);
    static double twoToTheDoubleScaleUp = Math.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = Math.powerOfTwoD(-512);

    private Math() {
    }

    public static double sin(double a) {
        return StrictMath.sin(a);
    }

    public static double cos(double a) {
        return StrictMath.cos(a);
    }

    public static double tan(double a) {
        return StrictMath.tan(a);
    }

    public static double asin(double a) {
        return StrictMath.asin(a);
    }

    public static double acos(double a) {
        return StrictMath.acos(a);
    }

    public static double atan(double a) {
        return StrictMath.atan(a);
    }

    public static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static double exp(double a) {
        return StrictMath.exp(a);
    }

    public static double log(double a) {
        return StrictMath.log(a);
    }

    public static double log10(double a) {
        return StrictMath.log10(a);
    }

    public static double sqrt(double a) {
        return StrictMath.sqrt(a);
    }

    public static double cbrt(double a) {
        return StrictMath.cbrt(a);
    }

    public static double IEEEremainder(double f1, double f2) {
        return StrictMath.IEEEremainder(f1, f2);
    }

    public static double ceil(double a) {
        return StrictMath.ceil(a);
    }

    public static double floor(double a) {
        return StrictMath.floor(a);
    }

    public static double rint(double a) {
        return StrictMath.rint(a);
    }

    public static double atan2(double y, double x) {
        return StrictMath.atan2(y, x);
    }

    public static double pow(double a, double b) {
        return StrictMath.pow(a, b);
    }

    public static int round(float a) {
        int intBits = Float.floatToRawIntBits(a);
        int biasedExp = (intBits & 0x7F800000) >> 23;
        int shift = 149 - biasedExp;
        if ((shift & 0xFFFFFFE0) == 0) {
            int r = intBits & 0x7FFFFF | 0x800000;
            if (intBits < 0) {
                r = -r;
            }
            return (r >> shift) + 1 >> 1;
        }
        return (int)a;
    }

    public static long round(double a) {
        long longBits = Double.doubleToRawLongBits(a);
        long biasedExp = (longBits & 0x7FF0000000000000L) >> 52;
        long shift = 1074L - biasedExp;
        if ((shift & 0xFFFFFFFFFFFFFFC0L) == 0L) {
            long r = longBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (longBits < 0L) {
                r = -r;
            }
            return (r >> (int)shift) + 1L >> 1;
        }
        return (long)a;
    }

    public static double random() {
        return RandomNumberGeneratorHolder.randomNumberGenerator.nextDouble();
    }

    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)r;
    }

    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int incrementExact(int a) {
        if (a == Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a + 1;
    }

    public static long incrementExact(long a) {
        if (a == Long.MAX_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a + 1L;
    }

    public static int decrementExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a - 1;
    }

    public static long decrementExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a - 1L;
    }

    public static int negateExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return -a;
    }

    public static long negateExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -a;
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        int r = x - Math.floorDiv(x, y) * y;
        return r;
    }

    public static long floorMod(long x, long y) {
        return x - Math.floorDiv(x, y) * y;
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    public static double abs(double a) {
        return a <= 0.0 ? 0.0 - a : a;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(a) == negativeZeroFloatBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(a) == negativeZeroDoubleBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(b) == negativeZeroFloatBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(b) == negativeZeroDoubleBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    public static double ulp(double d) {
        int exp = Math.getExponent(d);
        switch (exp) {
            case 1024: {
                return Math.abs(d);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        assert (exp <= 1023 && exp >= -1022);
        if ((exp -= 52) >= -1022) {
            return Math.powerOfTwoD(exp);
        }
        return Double.longBitsToDouble(1L << exp - -1074);
    }

    public static float ulp(float f) {
        int exp = Math.getExponent(f);
        switch (exp) {
            case 128: {
                return Math.abs(f);
            }
            case -127: {
                return Float.MIN_VALUE;
            }
        }
        assert (exp <= 127 && exp >= -126);
        if ((exp -= 23) >= -126) {
            return Math.powerOfTwoF(exp);
        }
        return Float.intBitsToFloat(1 << exp - -149);
    }

    public static double signum(double d) {
        return d == 0.0 || Double.isNaN(d) ? d : Math.copySign(1.0, d);
    }

    public static float signum(float f) {
        return f == 0.0f || Float.isNaN(f) ? f : Math.copySign(1.0f, f);
    }

    public static double sinh(double x) {
        return StrictMath.sinh(x);
    }

    public static double cosh(double x) {
        return StrictMath.cosh(x);
    }

    public static double tanh(double x) {
        return StrictMath.tanh(x);
    }

    public static double hypot(double x, double y) {
        return StrictMath.hypot(x, y);
    }

    public static double expm1(double x) {
        return StrictMath.expm1(x);
    }

    public static double log1p(double x) {
        return StrictMath.log1p(x);
    }

    public static double copySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(sign) & Long.MIN_VALUE | Double.doubleToRawLongBits(magnitude) & Long.MAX_VALUE);
    }

    public static float copySign(float magnitude, float sign) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(sign) & Integer.MIN_VALUE | Float.floatToRawIntBits(magnitude) & Integer.MAX_VALUE);
    }

    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static double nextAfter(double start, double direction) {
        if (Double.isNaN(start) || Double.isNaN(direction)) {
            return start + direction;
        }
        if (start == direction) {
            return direction;
        }
        long transducer = Double.doubleToRawLongBits(start + 0.0);
        if (direction > start) {
            transducer += transducer >= 0L ? 1L : -1L;
        } else {
            assert (direction < start);
            transducer = transducer > 0L ? --transducer : (transducer < 0L ? ++transducer : -9223372036854775807L);
        }
        return Double.longBitsToDouble(transducer);
    }

    public static float nextAfter(float start, double direction) {
        if (Float.isNaN(start) || Double.isNaN(direction)) {
            return start + (float)direction;
        }
        if ((double)start == direction) {
            return (float)direction;
        }
        int transducer = Float.floatToRawIntBits(start + 0.0f);
        if (direction > (double)start) {
            transducer += transducer >= 0 ? 1 : -1;
        } else {
            assert (direction < (double)start);
            transducer = transducer > 0 ? --transducer : (transducer < 0 ? ++transducer : -2147483647);
        }
        return Float.intBitsToFloat(transducer);
    }

    public static double nextUp(double d) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static float nextUp(float f) {
        if (Float.isNaN(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f += 0.0f) + (f >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static float nextDown(float f) {
        if (Float.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    public static double scalb(double d, int scaleFactor) {
        int MAX_SCALE = 2099;
        int exp_adjust = 0;
        int scale_increment = 0;
        double exp_delta = Double.NaN;
        if (scaleFactor < 0) {
            scaleFactor = Math.max(scaleFactor, -2099);
            scale_increment = -512;
            exp_delta = twoToTheDoubleScaleDown;
        } else {
            scaleFactor = Math.min(scaleFactor, 2099);
            scale_increment = 512;
            exp_delta = twoToTheDoubleScaleUp;
        }
        int t = scaleFactor >> 8 >>> 23;
        exp_adjust = (scaleFactor + t & 0x1FF) - t;
        d *= Math.powerOfTwoD(exp_adjust);
        scaleFactor -= exp_adjust;
        while (scaleFactor != 0) {
            d *= exp_delta;
            scaleFactor -= scale_increment;
        }
        return d;
    }

    public static float scalb(float f, int scaleFactor) {
        int MAX_SCALE = 278;
        scaleFactor = Math.max(Math.min(scaleFactor, 278), -278);
        return (float)((double)f * Math.powerOfTwoD(scaleFactor));
    }

    static double powerOfTwoD(int n) {
        assert (n >= -1022 && n <= 1023);
        return Double.longBitsToDouble((long)n + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n) {
        assert (n >= -126 && n <= 127);
        return Float.intBitsToFloat(n + 127 << 23 & 0x7F800000);
    }

    private static final class RandomNumberGeneratorHolder {
        static final Random randomNumberGenerator = new Random();

        private RandomNumberGeneratorHolder() {
        }
    }
}

