/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.util.Arrays;

abstract class DelegatingMethodHandle
extends MethodHandle {
    static final LambdaForm.NamedFunction NF_getTarget;

    protected DelegatingMethodHandle(MethodHandle target) {
        this(target.type(), target);
    }

    protected DelegatingMethodHandle(MethodType type, MethodHandle target) {
        super(type, DelegatingMethodHandle.chooseDelegatingForm(target));
    }

    protected DelegatingMethodHandle(MethodType type, LambdaForm form) {
        super(type, form);
    }

    protected abstract MethodHandle getTarget();

    @Override
    abstract MethodHandle asTypeUncached(MethodType var1);

    @Override
    MemberName internalMemberName() {
        return this.getTarget().internalMemberName();
    }

    @Override
    boolean isInvokeSpecial() {
        return this.getTarget().isInvokeSpecial();
    }

    @Override
    Class<?> internalCallerClass() {
        return this.getTarget().internalCallerClass();
    }

    @Override
    MethodHandle copyWith(MethodType mt, LambdaForm lf) {
        throw MethodHandleStatics.newIllegalArgumentException("do not use this");
    }

    @Override
    String internalProperties() {
        return "\n& Class=" + this.getClass().getSimpleName() + "\n& Target=" + this.getTarget().debugString();
    }

    @Override
    BoundMethodHandle rebind() {
        return this.getTarget().rebind();
    }

    private static LambdaForm chooseDelegatingForm(MethodHandle target) {
        if (target instanceof SimpleMethodHandle) {
            return target.internalForm();
        }
        return DelegatingMethodHandle.makeReinvokerForm(target, 8, DelegatingMethodHandle.class, NF_getTarget);
    }

    static LambdaForm makeReinvokerForm(MethodHandle target, int whichCache, Object constraint, LambdaForm.NamedFunction getTargetFn) {
        String debugString;
        switch (whichCache) {
            case 7: {
                debugString = "BMH.reinvoke";
                break;
            }
            case 8: {
                debugString = "MH.delegate";
                break;
            }
            default: {
                debugString = "MH.reinvoke";
            }
        }
        return DelegatingMethodHandle.makeReinvokerForm(target, whichCache, constraint, debugString, true, getTargetFn, null);
    }

    static LambdaForm makeReinvokerForm(MethodHandle target, int whichCache, Object constraint, String debugString, boolean forceInline, LambdaForm.NamedFunction getTargetFn, LambdaForm.NamedFunction preActionFn) {
        int ARG_LIMIT;
        LambdaForm form;
        boolean hasPreAction;
        MethodType mtype = target.type().basicType();
        boolean customized = whichCache < 0 || mtype.parameterSlotCount() > 253;
        boolean bl = hasPreAction = preActionFn != null;
        if (!customized && (form = mtype.form().cachedLambdaForm(whichCache)) != null) {
            return form;
        }
        boolean THIS_DMH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int PRE_ACTION = hasPreAction ? nameCursor++ : -1;
        int NEXT_MH = customized ? -1 : nameCursor++;
        int REINVOKE = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        assert (names.length == nameCursor);
        names[0] = names[0].withConstraint(constraint);
        if (hasPreAction) {
            names[PRE_ACTION] = new LambdaForm.Name(preActionFn, names[0]);
        }
        if (customized) {
            Object[] targetArgs = Arrays.copyOfRange(names, 1, ARG_LIMIT, Object[].class);
            names[REINVOKE] = new LambdaForm.Name(target, targetArgs);
        } else {
            names[NEXT_MH] = new LambdaForm.Name(getTargetFn, names[0]);
            Object[] targetArgs = Arrays.copyOfRange(names, 0, ARG_LIMIT, Object[].class);
            targetArgs[0] = names[NEXT_MH];
            names[REINVOKE] = new LambdaForm.Name(mtype, targetArgs);
        }
        form = new LambdaForm(debugString, ARG_LIMIT, names, forceInline);
        if (!customized) {
            form = mtype.form().setCachedLambdaForm(whichCache, form);
        }
        return form;
    }

    static {
        try {
            NF_getTarget = new LambdaForm.NamedFunction(DelegatingMethodHandle.class.getDeclaredMethod("getTarget", new Class[0]));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }
}

