/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;
import sun.reflect.misc.ReflectUtil;

class InvokerBytecodeGenerator {
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String MHI = "java/lang/invoke/MethodHandleImpl";
    private static final String LF = "java/lang/invoke/LambdaForm";
    private static final String LFN = "java/lang/invoke/LambdaForm$Name";
    private static final String CLS = "java/lang/Class";
    private static final String OBJ = "java/lang/Object";
    private static final String OBJARY = "[Ljava/lang/Object;";
    private static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
    private static final String LF_SIG = "Ljava/lang/invoke/LambdaForm;";
    private static final String LFN_SIG = "Ljava/lang/invoke/LambdaForm$Name;";
    private static final String LL_SIG = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String LLV_SIG = "(Ljava/lang/Object;Ljava/lang/Object;)V";
    private static final String CLL_SIG = "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String superName = "java/lang/Object";
    private final String className;
    private final String sourceFile;
    private final LambdaForm lambdaForm;
    private final String invokerName;
    private final MethodType invokerType;
    private final int[] localsMap;
    private final LambdaForm.BasicType[] localTypes;
    private final Class<?>[] localClasses;
    private ClassWriter cw;
    private MethodVisitor mv;
    private static final MemberName.Factory MEMBERNAME_FACTORY = MemberName.getFactory();
    private static final Class<?> HOST_CLASS = LambdaForm.class;
    private static final HashMap<String, Integer> DUMP_CLASS_FILES_COUNTERS;
    private static final File DUMP_CLASS_FILES_DIR;
    Map<Object, CpPatch> cpPatches = new HashMap<Object, CpPatch>();
    int cph = 0;
    private static Class<?>[] STATICALLY_INVOCABLE_PACKAGES;

    private InvokerBytecodeGenerator(LambdaForm lambdaForm, int localsMapSize, String className, String invokerName, MethodType invokerType) {
        if (invokerName.contains(".")) {
            int p = invokerName.indexOf(".");
            className = invokerName.substring(0, p);
            invokerName = invokerName.substring(p + 1);
        }
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            className = InvokerBytecodeGenerator.makeDumpableClassName(className);
        }
        this.className = "java/lang/invoke/LambdaForm$" + className;
        this.sourceFile = "LambdaForm$" + className;
        this.lambdaForm = lambdaForm;
        this.invokerName = invokerName;
        this.invokerType = invokerType;
        this.localsMap = new int[localsMapSize + 1];
        this.localTypes = new LambdaForm.BasicType[localsMapSize + 1];
        this.localClasses = new Class[localsMapSize + 1];
    }

    private InvokerBytecodeGenerator(String className, String invokerName, MethodType invokerType) {
        this(null, invokerType.parameterCount(), className, invokerName, invokerType);
        this.localTypes[this.localTypes.length - 1] = LambdaForm.BasicType.V_TYPE;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = invokerType.parameterSlotCount() - invokerType.parameterSlotDepth(i);
            if (i >= invokerType.parameterCount()) continue;
            this.localTypes[i] = LambdaForm.BasicType.basicType(invokerType.parameterType(i));
        }
    }

    private InvokerBytecodeGenerator(String className, LambdaForm form, MethodType invokerType) {
        this(form, form.names.length, className, form.debugName, invokerType);
        LambdaForm.Name[] names = form.names;
        int index = 0;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = index;
            if (i >= names.length) continue;
            LambdaForm.BasicType type = names[i].type();
            index += type.basicTypeSlots();
            this.localTypes[i] = type;
        }
    }

    static void maybeDump(final String className, final byte[] classFile) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        String dumpName = className;
                        File dumpFile = new File(DUMP_CLASS_FILES_DIR, dumpName + ".class");
                        System.out.println("dump: " + dumpFile);
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream file = new FileOutputStream(dumpFile);
                        file.write(classFile);
                        file.close();
                        return null;
                    }
                    catch (IOException ex) {
                        throw MethodHandleStatics.newInternalError(ex);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDumpableClassName(String className) {
        Integer ctr;
        HashMap<String, Integer> hashMap = DUMP_CLASS_FILES_COUNTERS;
        synchronized (hashMap) {
            ctr = DUMP_CLASS_FILES_COUNTERS.get(className);
            if (ctr == null) {
                ctr = 0;
            }
            DUMP_CLASS_FILES_COUNTERS.put(className, ctr + 1);
        }
        String sfx = ctr.toString();
        while (sfx.length() < 3) {
            sfx = "0" + sfx;
        }
        className = className + sfx;
        return className;
    }

    String constantPlaceholder(Object arg) {
        String cpPlaceholder = "CONSTANT_PLACEHOLDER_" + this.cph++;
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            cpPlaceholder = cpPlaceholder + " <<" + InvokerBytecodeGenerator.debugString(arg) + ">>";
        }
        if (this.cpPatches.containsKey(cpPlaceholder)) {
            throw new InternalError("observed CP placeholder twice: " + cpPlaceholder);
        }
        int index = this.cw.newConst(cpPlaceholder);
        this.cpPatches.put(cpPlaceholder, new CpPatch(index, cpPlaceholder, arg));
        return cpPlaceholder;
    }

    Object[] cpPatches(byte[] classFile) {
        int size = InvokerBytecodeGenerator.getConstantPoolSize(classFile);
        Object[] res = new Object[size];
        for (CpPatch p : this.cpPatches.values()) {
            if (p.index >= size) {
                throw new InternalError("in cpool[" + size + "]: " + p + "\n" + Arrays.toString(Arrays.copyOf(classFile, 20)));
            }
            res[p.index] = p.value;
        }
        return res;
    }

    private static String debugString(Object arg) {
        if (arg instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)arg;
            MemberName member = mh.internalMemberName();
            if (member != null) {
                return member.toString();
            }
            return mh.debugString();
        }
        return arg.toString();
    }

    private static int getConstantPoolSize(byte[] classFile) {
        return (classFile[8] & 0xFF) << 8 | classFile[9] & 0xFF;
    }

    private MemberName loadMethod(byte[] classFile) {
        Class<?> invokerClass = InvokerBytecodeGenerator.loadAndInitializeInvokerClass(classFile, this.cpPatches(classFile));
        return InvokerBytecodeGenerator.resolveInvokerMember(invokerClass, this.invokerName, this.invokerType);
    }

    private static Class<?> loadAndInitializeInvokerClass(byte[] classBytes, Object[] patches) {
        Class<?> invokerClass = MethodHandleStatics.UNSAFE.defineAnonymousClass(HOST_CLASS, classBytes, patches);
        MethodHandleStatics.UNSAFE.ensureClassInitialized(invokerClass);
        return invokerClass;
    }

    private static MemberName resolveInvokerMember(Class<?> invokerClass, String name, MethodType type) {
        MemberName member = new MemberName(invokerClass, name, type, 6);
        try {
            member = MEMBERNAME_FACTORY.resolveOrFail((byte)6, member, HOST_CLASS, ReflectiveOperationException.class);
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        return member;
    }

    private void classFilePrologue() {
        boolean NOT_ACC_PUBLIC = false;
        this.cw = new ClassWriter(3);
        this.cw.visit(52, 48, this.className, null, "java/lang/Object", null);
        this.cw.visitSource(this.sourceFile, null);
        String invokerDesc = this.invokerType.toMethodDescriptorString();
        this.mv = this.cw.visitMethod(8, this.invokerName, invokerDesc, null, null);
    }

    private void classFileEpilogue() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void emitConst(Object con) {
        long x;
        if (con == null) {
            this.mv.visitInsn(1);
            return;
        }
        if (con instanceof Integer) {
            this.emitIconstInsn((Integer)con);
            return;
        }
        if (con instanceof Long && (x = ((Long)con).longValue()) == (long)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(133);
            return;
        }
        if (con instanceof Float && (x = ((Float)con).floatValue()) == (float)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(134);
            return;
        }
        if (con instanceof Double && (x = ((Double)con).doubleValue()) == (double)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(135);
            return;
        }
        if (con instanceof Boolean) {
            this.emitIconstInsn((Boolean)con != false ? 1 : 0);
            return;
        }
        this.mv.visitLdcInsn(con);
    }

    private void emitIconstInsn(int i) {
        int opcode;
        switch (i) {
            case 0: {
                opcode = 3;
                break;
            }
            case 1: {
                opcode = 4;
                break;
            }
            case 2: {
                opcode = 5;
                break;
            }
            case 3: {
                opcode = 6;
                break;
            }
            case 4: {
                opcode = 7;
                break;
            }
            case 5: {
                opcode = 8;
                break;
            }
            default: {
                if (i == (byte)i) {
                    this.mv.visitIntInsn(16, i & 0xFF);
                } else if (i == (short)i) {
                    this.mv.visitIntInsn(17, (char)i);
                } else {
                    this.mv.visitLdcInsn(i);
                }
                return;
            }
        }
        this.mv.visitInsn(opcode);
    }

    private void emitLoadInsn(LambdaForm.BasicType type, int index) {
        int opcode = this.loadInsnOpcode(type);
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private int loadInsnOpcode(LambdaForm.BasicType type) throws InternalError {
        switch (type) {
            case I_TYPE: {
                return 21;
            }
            case J_TYPE: {
                return 22;
            }
            case F_TYPE: {
                return 23;
            }
            case D_TYPE: {
                return 24;
            }
            case L_TYPE: {
                return 25;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)type));
    }

    private void emitAloadInsn(int index) {
        this.emitLoadInsn(LambdaForm.BasicType.L_TYPE, index);
    }

    private void emitStoreInsn(LambdaForm.BasicType type, int index) {
        int opcode = this.storeInsnOpcode(type);
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private int storeInsnOpcode(LambdaForm.BasicType type) throws InternalError {
        switch (type) {
            case I_TYPE: {
                return 54;
            }
            case J_TYPE: {
                return 55;
            }
            case F_TYPE: {
                return 56;
            }
            case D_TYPE: {
                return 57;
            }
            case L_TYPE: {
                return 58;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)type));
    }

    private void emitAstoreInsn(int index) {
        this.emitStoreInsn(LambdaForm.BasicType.L_TYPE, index);
    }

    private byte arrayTypeCode(Wrapper elementType) {
        switch (elementType) {
            case BOOLEAN: {
                return 4;
            }
            case BYTE: {
                return 8;
            }
            case CHAR: {
                return 5;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case OBJECT: {
                return 0;
            }
        }
        throw new InternalError();
    }

    private int arrayInsnOpcode(byte tcode, int aaop) throws InternalError {
        int xas;
        assert (aaop == 83 || aaop == 50);
        switch (tcode) {
            case 4: {
                xas = 84;
                break;
            }
            case 8: {
                xas = 84;
                break;
            }
            case 5: {
                xas = 85;
                break;
            }
            case 9: {
                xas = 86;
                break;
            }
            case 10: {
                xas = 79;
                break;
            }
            case 11: {
                xas = 80;
                break;
            }
            case 6: {
                xas = 81;
                break;
            }
            case 7: {
                xas = 82;
                break;
            }
            case 0: {
                xas = 83;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return xas - 83 + aaop;
    }

    private void freeFrameLocal(int oldFrameLocal) {
        int i = this.indexForFrameLocal(oldFrameLocal);
        if (i < 0) {
            return;
        }
        LambdaForm.BasicType type = this.localTypes[i];
        int newFrameLocal = this.makeLocalTemp(type);
        this.mv.visitVarInsn(this.loadInsnOpcode(type), oldFrameLocal);
        this.mv.visitVarInsn(this.storeInsnOpcode(type), newFrameLocal);
        assert (this.localsMap[i] == oldFrameLocal);
        this.localsMap[i] = newFrameLocal;
        assert (this.indexForFrameLocal(oldFrameLocal) < 0);
    }

    private int indexForFrameLocal(int frameLocal) {
        for (int i = 0; i < this.localsMap.length; ++i) {
            if (this.localsMap[i] != frameLocal || this.localTypes[i] == LambdaForm.BasicType.V_TYPE) continue;
            return i;
        }
        return -1;
    }

    private int makeLocalTemp(LambdaForm.BasicType type) {
        int frameLocal = this.localsMap[this.localsMap.length - 1];
        this.localsMap[this.localsMap.length - 1] = frameLocal + type.basicTypeSlots();
        return frameLocal;
    }

    private void emitBoxing(Wrapper wrapper) {
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = "valueOf";
        String desc = "(" + wrapper.basicTypeChar() + ")L" + owner + ";";
        this.mv.visitMethodInsn(184, owner, name, desc, false);
    }

    private void emitUnboxing(Wrapper wrapper) {
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = wrapper.primitiveSimpleName() + "Value";
        String desc = "()" + wrapper.basicTypeChar();
        this.emitReferenceCast(wrapper.wrapperType(), null);
        this.mv.visitMethodInsn(182, owner, name, desc, false);
    }

    private void emitImplicitConversion(LambdaForm.BasicType ptype, Class<?> pclass, Object arg) {
        assert (LambdaForm.BasicType.basicType(pclass) == ptype);
        if (pclass == ptype.basicTypeClass() && ptype != LambdaForm.BasicType.L_TYPE) {
            return;
        }
        switch (ptype) {
            case L_TYPE: {
                if (VerifyType.isNullConversion(Object.class, pclass, false)) {
                    if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                        this.emitReferenceCast(Object.class, arg);
                    }
                    return;
                }
                this.emitReferenceCast(pclass, arg);
                return;
            }
            case I_TYPE: {
                if (!VerifyType.isNullConversion(Integer.TYPE, pclass, false)) {
                    this.emitPrimCast(ptype.basicTypeWrapper(), Wrapper.forPrimitiveType(pclass));
                }
                return;
            }
        }
        throw MethodHandleStatics.newInternalError("bad implicit conversion: tc=" + (Object)((Object)ptype) + ": " + pclass);
    }

    private boolean assertStaticType(Class<?> cls, LambdaForm.Name n) {
        int local = n.index();
        Class<?> aclass = this.localClasses[local];
        if (aclass != null && (aclass == cls || cls.isAssignableFrom(aclass))) {
            return true;
        }
        if (aclass == null || aclass.isAssignableFrom(cls)) {
            this.localClasses[local] = cls;
        }
        return false;
    }

    private void emitReferenceCast(Class<?> cls, Object arg) {
        LambdaForm.Name writeBack = null;
        if (arg instanceof LambdaForm.Name) {
            LambdaForm.Name n = (LambdaForm.Name)arg;
            if (this.assertStaticType(cls, n)) {
                return;
            }
            if (this.lambdaForm.useCount(n) > 1) {
                writeBack = n;
            }
        }
        if (InvokerBytecodeGenerator.isStaticallyNameable(cls)) {
            String sig = InvokerBytecodeGenerator.getInternalName(cls);
            this.mv.visitTypeInsn(192, sig);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(cls));
            this.mv.visitTypeInsn(192, CLS);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(184, MHI, "castReference", CLL_SIG, false);
            if (Object[].class.isAssignableFrom(cls)) {
                this.mv.visitTypeInsn(192, OBJARY);
            } else if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                this.mv.visitTypeInsn(192, "java/lang/Object");
            }
        }
        if (writeBack != null) {
            this.mv.visitInsn(89);
            this.emitAstoreInsn(writeBack.index());
        }
    }

    private void emitReturnInsn(LambdaForm.BasicType type) {
        int opcode;
        switch (type) {
            case I_TYPE: {
                opcode = 172;
                break;
            }
            case J_TYPE: {
                opcode = 173;
                break;
            }
            case F_TYPE: {
                opcode = 174;
                break;
            }
            case D_TYPE: {
                opcode = 175;
                break;
            }
            case L_TYPE: {
                opcode = 176;
                break;
            }
            case V_TYPE: {
                opcode = 177;
                break;
            }
            default: {
                throw new InternalError("unknown return type: " + (Object)((Object)type));
            }
        }
        this.mv.visitInsn(opcode);
    }

    private static String getInternalName(Class<?> c) {
        if (c == Object.class) {
            return "java/lang/Object";
        }
        if (c == Object[].class) {
            return OBJARY;
        }
        if (c == Class.class) {
            return CLS;
        }
        if (c == MethodHandle.class) {
            return MH;
        }
        assert (VerifyAccess.isTypeVisible(c, Object.class)) : c.getName();
        return c.getName().replace('.', '/');
    }

    static MemberName generateCustomizedCode(LambdaForm form, MethodType invokerType) {
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("MH", form, invokerType);
        return g.loadMethod(g.generateCustomizedCodeBytes());
    }

    private boolean checkActualReceiver() {
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, this.localsMap[0]);
        this.mv.visitMethodInsn(184, MHI, "assertSame", LLV_SIG, false);
        return true;
    }

    private byte[] generateCustomizedCodeBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Compiled;", true);
        if (this.lambdaForm.forceInline) {
            this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        } else {
            this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        }
        if (this.lambdaForm.customized != null) {
            this.mv.visitLdcInsn(this.constantPlaceholder(this.lambdaForm.customized));
            this.mv.visitTypeInsn(192, MH);
            assert (this.checkActualReceiver());
            this.mv.visitVarInsn(58, this.localsMap[0]);
        }
        LambdaForm.Name onStack = null;
        block10: for (int i = this.lambdaForm.arity; i < this.lambdaForm.names.length; ++i) {
            MemberName member;
            LambdaForm.Name name = this.lambdaForm.names[i];
            this.emitStoreResult(onStack);
            onStack = name;
            MethodHandleImpl.Intrinsic intr = name.function.intrinsicName();
            switch (intr) {
                case SELECT_ALTERNATIVE: {
                    assert (this.isSelectAlternative(i));
                    if (MethodHandleStatics.PROFILE_GWT) {
                        assert (name.arguments[0] instanceof LambdaForm.Name && this.nameRefersTo((LambdaForm.Name)name.arguments[0], MethodHandleImpl.class, "profileBoolean"));
                        this.mv.visitAnnotation("Ljava/lang/invoke/InjectedProfile;", true);
                    }
                    onStack = this.emitSelectAlternative(name, this.lambdaForm.names[i + 1]);
                    ++i;
                    continue block10;
                }
                case GUARD_WITH_CATCH: {
                    assert (this.isGuardWithCatch(i));
                    onStack = this.emitGuardWithCatch(i);
                    i += 2;
                    continue block10;
                }
                case NEW_ARRAY: {
                    Class<?> rtype = name.function.methodType().returnType();
                    if (!InvokerBytecodeGenerator.isStaticallyNameable(rtype)) break;
                    this.emitNewArray(name);
                    continue block10;
                }
                case ARRAY_LOAD: {
                    this.emitArrayLoad(name);
                    continue block10;
                }
                case ARRAY_STORE: {
                    this.emitArrayStore(name);
                    continue block10;
                }
                case IDENTITY: {
                    assert (name.arguments.length == 1);
                    this.emitPushArguments(name);
                    continue block10;
                }
                case ZERO: {
                    assert (name.arguments.length == 0);
                    this.emitConst(name.type.basicTypeWrapper().zero());
                    continue block10;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw MethodHandleStatics.newInternalError("Unknown intrinsic: " + (Object)((Object)intr));
                }
            }
            if (InvokerBytecodeGenerator.isStaticallyInvocable(member = name.function.member())) {
                this.emitStaticInvoke(member, name);
                continue;
            }
            this.emitInvoke(name);
        }
        this.emitReturn(onStack);
        this.classFileEpilogue();
        this.bogusMethod(this.lambdaForm);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    void emitArrayLoad(LambdaForm.Name name) {
        this.emitArrayOp(name, 50);
    }

    void emitArrayStore(LambdaForm.Name name) {
        this.emitArrayOp(name, 83);
    }

    void emitArrayOp(LambdaForm.Name name, int arrayOpcode) {
        assert (arrayOpcode == 50 || arrayOpcode == 83);
        Class<?> elementType = name.function.methodType().parameterType(0).getComponentType();
        assert (elementType != null);
        this.emitPushArguments(name);
        if (elementType.isPrimitive()) {
            Wrapper w = Wrapper.forPrimitiveType(elementType);
            arrayOpcode = this.arrayInsnOpcode(this.arrayTypeCode(w), arrayOpcode);
        }
        this.mv.visitInsn(arrayOpcode);
    }

    void emitInvoke(LambdaForm.Name name) {
        assert (!this.isLinkerMethodInvoke(name));
        MethodHandle target = name.function.resolvedHandle;
        assert (target != null) : name.exprString();
        this.mv.visitLdcInsn(this.constantPlaceholder(target));
        this.emitReferenceCast(MethodHandle.class, target);
        this.emitPushArguments(name);
        MethodType type = name.function.methodType();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString(), false);
    }

    static boolean isStaticallyInvocable(LambdaForm.Name name) {
        return InvokerBytecodeGenerator.isStaticallyInvocable(name.function.member());
    }

    static boolean isStaticallyInvocable(MemberName member) {
        if (member == null) {
            return false;
        }
        if (member.isConstructor()) {
            return false;
        }
        Class<?> cls = member.getDeclaringClass();
        if (cls.isArray() || cls.isPrimitive()) {
            return false;
        }
        if (cls.isAnonymousClass() || cls.isLocalClass()) {
            return false;
        }
        if (cls.getClassLoader() != MethodHandle.class.getClassLoader()) {
            return false;
        }
        if (ReflectUtil.isVMAnonymousClass(cls)) {
            return false;
        }
        MethodType mtype = member.getMethodOrFieldType();
        if (!InvokerBytecodeGenerator.isStaticallyNameable(mtype.returnType())) {
            return false;
        }
        for (Class<?> ptype : mtype.parameterArray()) {
            if (InvokerBytecodeGenerator.isStaticallyNameable(ptype)) continue;
            return false;
        }
        if (!member.isPrivate() && VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        return member.isPublic() && InvokerBytecodeGenerator.isStaticallyNameable(cls);
    }

    static boolean isStaticallyNameable(Class<?> cls) {
        if (cls == Object.class) {
            return true;
        }
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.isPrimitive()) {
            return true;
        }
        if (ReflectUtil.isVMAnonymousClass(cls)) {
            return false;
        }
        if (cls.getClassLoader() != Object.class.getClassLoader()) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        for (Class<?> pkgcls : STATICALLY_INVOCABLE_PACKAGES) {
            if (!VerifyAccess.isSamePackage(pkgcls, cls)) continue;
            return true;
        }
        return false;
    }

    void emitStaticInvoke(LambdaForm.Name name) {
        this.emitStaticInvoke(name.function.member(), name);
    }

    void emitStaticInvoke(MemberName member, LambdaForm.Name name) {
        assert (member.equals(name.function.member()));
        Class<?> defc = member.getDeclaringClass();
        String cname = InvokerBytecodeGenerator.getInternalName(defc);
        String mname = member.getName();
        byte refKind = member.getReferenceKind();
        if (refKind == 7) {
            assert (member.canBeStaticallyBound()) : member;
            refKind = 5;
        }
        if (member.getDeclaringClass().isInterface() && refKind == 5) {
            refKind = 9;
        }
        this.emitPushArguments(name);
        if (member.isMethod()) {
            String mtype = member.getMethodType().toMethodDescriptorString();
            this.mv.visitMethodInsn(this.refKindOpcode(refKind), cname, mname, mtype, member.getDeclaringClass().isInterface());
        } else {
            String mtype = MethodType.toFieldDescriptorString(member.getFieldType());
            this.mv.visitFieldInsn(this.refKindOpcode(refKind), cname, mname, mtype);
        }
        if (name.type == LambdaForm.BasicType.L_TYPE) {
            Class<?> rtype = member.getInvocationType().returnType();
            assert (!rtype.isPrimitive());
            if (rtype != Object.class && !rtype.isInterface()) {
                this.assertStaticType(rtype, name);
            }
        }
    }

    void emitNewArray(LambdaForm.Name name) throws InternalError {
        Class<?> rtype = name.function.methodType().returnType();
        if (name.arguments.length == 0) {
            Object emptyArray;
            try {
                emptyArray = name.function.resolvedHandle.invoke();
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            assert (Array.getLength(emptyArray) == 0);
            assert (emptyArray.getClass() == rtype);
            this.mv.visitLdcInsn(this.constantPlaceholder(emptyArray));
            this.emitReferenceCast(rtype, emptyArray);
            return;
        }
        Class<?> arrayElementType = rtype.getComponentType();
        assert (arrayElementType != null);
        this.emitIconstInsn(name.arguments.length);
        int xas = 83;
        if (!arrayElementType.isPrimitive()) {
            this.mv.visitTypeInsn(189, InvokerBytecodeGenerator.getInternalName(arrayElementType));
        } else {
            byte tc = this.arrayTypeCode(Wrapper.forPrimitiveType(arrayElementType));
            xas = this.arrayInsnOpcode(tc, xas);
            this.mv.visitIntInsn(188, tc);
        }
        for (int i = 0; i < name.arguments.length; ++i) {
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitPushArgument(name, i);
            this.mv.visitInsn(xas);
        }
        this.assertStaticType(rtype, name);
    }

    int refKindOpcode(byte refKind) {
        switch (refKind) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 1: {
                return 180;
            }
            case 3: {
                return 181;
            }
            case 2: {
                return 178;
            }
            case 4: {
                return 179;
            }
        }
        throw new InternalError("refKind=" + refKind);
    }

    private boolean memberRefersTo(MemberName member, Class<?> declaringClass, String name) {
        return member != null && member.getDeclaringClass() == declaringClass && member.getName().equals(name);
    }

    private boolean nameRefersTo(LambdaForm.Name name, Class<?> declaringClass, String methodName) {
        return name.function != null && this.memberRefersTo(name.function.member(), declaringClass, methodName);
    }

    private boolean isInvokeBasic(LambdaForm.Name name) {
        if (name.function == null) {
            return false;
        }
        if (name.arguments.length < 1) {
            return false;
        }
        MemberName member = name.function.member();
        return this.memberRefersTo(member, MethodHandle.class, "invokeBasic") && !member.isPublic() && !member.isStatic();
    }

    private boolean isLinkerMethodInvoke(LambdaForm.Name name) {
        if (name.function == null) {
            return false;
        }
        if (name.arguments.length < 1) {
            return false;
        }
        MemberName member = name.function.member();
        return member != null && member.getDeclaringClass() == MethodHandle.class && !member.isPublic() && member.isStatic() && member.getName().startsWith("linkTo");
    }

    private boolean isSelectAlternative(int pos) {
        if (pos + 1 >= this.lambdaForm.names.length) {
            return false;
        }
        LambdaForm.Name name0 = this.lambdaForm.names[pos];
        LambdaForm.Name name1 = this.lambdaForm.names[pos + 1];
        return this.nameRefersTo(name0, MethodHandleImpl.class, "selectAlternative") && this.isInvokeBasic(name1) && name1.lastUseIndex(name0) == 0 && this.lambdaForm.lastUseIndex(name0) == pos + 1;
    }

    private boolean isGuardWithCatch(int pos) {
        if (pos + 2 >= this.lambdaForm.names.length) {
            return false;
        }
        LambdaForm.Name name0 = this.lambdaForm.names[pos];
        LambdaForm.Name name1 = this.lambdaForm.names[pos + 1];
        LambdaForm.Name name2 = this.lambdaForm.names[pos + 2];
        return this.nameRefersTo(name1, MethodHandleImpl.class, "guardWithCatch") && this.isInvokeBasic(name0) && this.isInvokeBasic(name2) && name1.lastUseIndex(name0) == 3 && this.lambdaForm.lastUseIndex(name0) == pos + 1 && name2.lastUseIndex(name1) == 1 && this.lambdaForm.lastUseIndex(name1) == pos + 2;
    }

    private LambdaForm.Name emitSelectAlternative(LambdaForm.Name selectAlternativeName, LambdaForm.Name invokeBasicName) {
        assert (InvokerBytecodeGenerator.isStaticallyInvocable(invokeBasicName));
        LambdaForm.Name receiver = (LambdaForm.Name)invokeBasicName.arguments[0];
        Label L_fallback = new Label();
        Label L_done = new Label();
        this.emitPushArgument(selectAlternativeName, 0);
        this.mv.visitJumpInsn(153, L_fallback);
        Class[] preForkClasses = (Class[])this.localClasses.clone();
        this.emitPushArgument(selectAlternativeName, 1);
        this.emitAstoreInsn(receiver.index());
        this.emitStaticInvoke(invokeBasicName);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_fallback);
        System.arraycopy(preForkClasses, 0, this.localClasses, 0, preForkClasses.length);
        this.emitPushArgument(selectAlternativeName, 2);
        this.emitAstoreInsn(receiver.index());
        this.emitStaticInvoke(invokeBasicName);
        this.mv.visitLabel(L_done);
        System.arraycopy(preForkClasses, 0, this.localClasses, 0, preForkClasses.length);
        return invokeBasicName;
    }

    private LambdaForm.Name emitGuardWithCatch(int pos) {
        LambdaForm.Name args = this.lambdaForm.names[pos];
        LambdaForm.Name invoker = this.lambdaForm.names[pos + 1];
        LambdaForm.Name result = this.lambdaForm.names[pos + 2];
        Label L_startBlock = new Label();
        Label L_endBlock = new Label();
        Label L_handler = new Label();
        Label L_done = new Label();
        Class<?> returnType = result.function.resolvedHandle.type().returnType();
        MethodType type = args.function.resolvedHandle.type().dropParameterTypes(0, 1).changeReturnType(returnType);
        this.mv.visitTryCatchBlock(L_startBlock, L_endBlock, L_handler, "java/lang/Throwable");
        this.mv.visitLabel(L_startBlock);
        this.emitPushArgument(invoker, 0);
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString(), false);
        this.mv.visitLabel(L_endBlock);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_handler);
        this.mv.visitInsn(89);
        this.emitPushArgument(invoker, 1);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, CLS, "isInstance", "(Ljava/lang/Object;)Z", false);
        Label L_rethrow = new Label();
        this.mv.visitJumpInsn(153, L_rethrow);
        this.emitPushArgument(invoker, 2);
        this.mv.visitInsn(95);
        this.emitPushArguments(args, 1);
        MethodType catcherType = type.insertParameterTypes(0, Throwable.class);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", catcherType.basicType().toMethodDescriptorString(), false);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_rethrow);
        this.mv.visitInsn(191);
        this.mv.visitLabel(L_done);
        return result;
    }

    private void emitPushArguments(LambdaForm.Name args) {
        this.emitPushArguments(args, 0);
    }

    private void emitPushArguments(LambdaForm.Name args, int start) {
        for (int i = start; i < args.arguments.length; ++i) {
            this.emitPushArgument(args, i);
        }
    }

    private void emitPushArgument(LambdaForm.Name name, int paramIndex) {
        Object arg = name.arguments[paramIndex];
        Class<?> ptype = name.function.methodType().parameterType(paramIndex);
        this.emitPushArgument(ptype, arg);
    }

    private void emitPushArgument(Class<?> ptype, Object arg) {
        LambdaForm.BasicType bptype = LambdaForm.BasicType.basicType(ptype);
        if (arg instanceof LambdaForm.Name) {
            LambdaForm.Name n = (LambdaForm.Name)arg;
            this.emitLoadInsn(n.type, n.index());
            this.emitImplicitConversion(n.type, ptype, n);
        } else if ((arg == null || arg instanceof String) && bptype == LambdaForm.BasicType.L_TYPE) {
            this.emitConst(arg);
        } else if (Wrapper.isWrapperType(arg.getClass()) && bptype != LambdaForm.BasicType.L_TYPE) {
            this.emitConst(arg);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(arg));
            this.emitImplicitConversion(LambdaForm.BasicType.L_TYPE, ptype, arg);
        }
    }

    private void emitStoreResult(LambdaForm.Name name) {
        if (name != null && name.type != LambdaForm.BasicType.V_TYPE) {
            this.emitStoreInsn(name.type, name.index());
        }
    }

    private void emitReturn(LambdaForm.Name onStack) {
        Class<?> rclass = this.invokerType.returnType();
        LambdaForm.BasicType rtype = this.lambdaForm.returnType();
        assert (rtype == LambdaForm.BasicType.basicType(rclass));
        if (rtype == LambdaForm.BasicType.V_TYPE) {
            this.mv.visitInsn(177);
        } else {
            LambdaForm.Name rn = this.lambdaForm.names[this.lambdaForm.result];
            if (rn != onStack) {
                this.emitLoadInsn(rtype, this.lambdaForm.result);
            }
            this.emitImplicitConversion(rtype, rclass, rn);
            this.emitReturnInsn(rtype);
        }
    }

    private void emitPrimCast(Wrapper from, Wrapper to) {
        if (from == to) {
            return;
        }
        if (from.isSubwordOrInt()) {
            this.emitI2X(to);
        } else if (to.isSubwordOrInt()) {
            this.emitX2I(from);
            if (to.bitWidth() < 32) {
                this.emitI2X(to);
            }
        } else {
            boolean error = false;
            block0 : switch (from) {
                case LONG: {
                    switch (to) {
                        case FLOAT: {
                            this.mv.visitInsn(137);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(138);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case FLOAT: {
                    switch (to) {
                        case LONG: {
                            this.mv.visitInsn(140);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(141);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case DOUBLE: {
                    switch (to) {
                        case LONG: {
                            this.mv.visitInsn(143);
                            break block0;
                        }
                        case FLOAT: {
                            this.mv.visitInsn(144);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                default: {
                    error = true;
                }
            }
            if (error) {
                throw new IllegalStateException("unhandled prim cast: " + (Object)((Object)from) + "2" + (Object)((Object)to));
            }
        }
    }

    private void emitI2X(Wrapper type) {
        switch (type) {
            case BYTE: {
                this.mv.visitInsn(145);
                break;
            }
            case SHORT: {
                this.mv.visitInsn(147);
                break;
            }
            case CHAR: {
                this.mv.visitInsn(146);
                break;
            }
            case INT: {
                break;
            }
            case LONG: {
                this.mv.visitInsn(133);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(134);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(135);
                break;
            }
            case BOOLEAN: {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)type));
            }
        }
    }

    private void emitX2I(Wrapper type) {
        switch (type) {
            case LONG: {
                this.mv.visitInsn(136);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(139);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(142);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)type));
            }
        }
    }

    static MemberName generateLambdaFormInterpreterEntryPoint(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        String name = "interpret_" + LambdaForm.signatureReturn(sig).basicTypeChar();
        MethodType type = LambdaForm.signatureType(sig);
        type = type.changeParameterType(0, MethodHandle.class);
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("LFI", name, type);
        return g.loadMethod(g.generateLambdaFormInterpreterEntryPointBytes());
    }

    private byte[] generateLambdaFormInterpreterEntryPointBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        this.emitIconstInsn(this.invokerType.parameterCount());
        this.mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < this.invokerType.parameterCount(); ++i) {
            Class<?> ptype = this.invokerType.parameterType(i);
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitLoadInsn(LambdaForm.BasicType.basicType(ptype), i);
            if (ptype.isPrimitive()) {
                this.emitBoxing(Wrapper.forPrimitiveType(ptype));
            }
            this.mv.visitInsn(83);
        }
        this.emitAloadInsn(0);
        this.mv.visitFieldInsn(180, MH, "form", LF_SIG);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, LF, "interpretWithArguments", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
        Class<?> rtype = this.invokerType.returnType();
        if (rtype.isPrimitive() && rtype != Void.TYPE) {
            this.emitUnboxing(Wrapper.forPrimitiveType(rtype));
        }
        this.emitReturnInsn(LambdaForm.BasicType.basicType(rtype));
        this.classFileEpilogue();
        this.bogusMethod(this.invokerType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    static MemberName generateNamedFunctionInvoker(MethodTypeForm typeForm) {
        MethodType invokerType = LambdaForm.NamedFunction.INVOKER_METHOD_TYPE;
        String invokerName = "invoke_" + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(typeForm.erasedType()));
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("NFI", invokerName, invokerType);
        return g.loadMethod(g.generateNamedFunctionInvokerImpl(typeForm));
    }

    private byte[] generateNamedFunctionInvokerImpl(MethodTypeForm typeForm) {
        Wrapper dstWrapper;
        MethodType dstType = typeForm.erasedType();
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        this.emitAloadInsn(0);
        for (int i = 0; i < dstType.parameterCount(); ++i) {
            this.emitAloadInsn(1);
            this.emitIconstInsn(i);
            this.mv.visitInsn(50);
            Class<?> dptype = dstType.parameterType(i);
            if (!dptype.isPrimitive()) continue;
            Class<?> sptype = dstType.basicType().wrap().parameterType(i);
            dstWrapper = Wrapper.forBasicType(dptype);
            Wrapper srcWrapper = dstWrapper.isSubwordOrInt() ? Wrapper.INT : dstWrapper;
            this.emitUnboxing(srcWrapper);
            this.emitPrimCast(srcWrapper, dstWrapper);
        }
        String targetDesc = dstType.basicType().toMethodDescriptorString();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", targetDesc, false);
        Class<?> rtype = dstType.returnType();
        if (rtype != Void.TYPE && rtype.isPrimitive()) {
            Wrapper srcWrapper = Wrapper.forBasicType(rtype);
            dstWrapper = srcWrapper.isSubwordOrInt() ? Wrapper.INT : srcWrapper;
            this.emitPrimCast(srcWrapper, dstWrapper);
            this.emitBoxing(dstWrapper);
        }
        if (rtype == Void.TYPE) {
            this.mv.visitInsn(1);
        }
        this.emitReturnInsn(LambdaForm.BasicType.L_TYPE);
        this.classFileEpilogue();
        this.bogusMethod(dstType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    private void bogusMethod(Object ... os) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            this.mv = this.cw.visitMethod(8, "dummy", "()V", null, null);
            for (Object o : os) {
                this.mv.visitLdcInsn(o.toString());
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(177);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
        }
    }

    static {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            DUMP_CLASS_FILES_COUNTERS = new HashMap();
            try {
                File dumpDir = new File("DUMP_CLASS_FILES");
                if (!dumpDir.exists()) {
                    dumpDir.mkdirs();
                }
                DUMP_CLASS_FILES_DIR = dumpDir;
                System.out.println("Dumping class files to " + DUMP_CLASS_FILES_DIR + "/...");
            }
            catch (Exception e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        } else {
            DUMP_CLASS_FILES_COUNTERS = null;
            DUMP_CLASS_FILES_DIR = null;
        }
        STATICALLY_INVOCABLE_PACKAGES = new Class[]{Object.class, Arrays.class, Unsafe.class};
    }

    class CpPatch {
        final int index;
        final String placeholder;
        final Object value;

        CpPatch(int index, String placeholder, Object value) {
            this.index = index;
            this.placeholder = placeholder;
            this.value = value;
        }

        public String toString() {
            return "CpPatch/index=" + this.index + ",placeholder=" + this.placeholder + ",value=" + this.value;
        }
    }
}

