/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    int size() {
        return this.size;
    }

    void add(TimerTask task) {
        if (this.size + 1 == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, 2 * this.queue.length);
        }
        this.queue[++this.size] = task;
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    TimerTask get(int i) {
        return this.queue[i];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void quickRemove(int i) {
        assert (i <= this.size);
        this.queue[i] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    void rescheduleMin(long newTime) {
        this.queue[1].nextExecutionTime = newTime;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int k) {
        while (k > 1) {
            int j = k >> 1;
            if (this.queue[j].nextExecutionTime <= this.queue[k].nextExecutionTime) break;
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[k] = tmp;
            k = j;
        }
    }

    private void fixDown(int k) {
        int j;
        while ((j = k << 1) <= this.size && j > 0) {
            if (j < this.size && this.queue[j].nextExecutionTime > this.queue[j + 1].nextExecutionTime) {
                ++j;
            }
            if (this.queue[k].nextExecutionTime <= this.queue[j].nextExecutionTime) break;
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[k] = tmp;
            k = j;
        }
    }

    void heapify() {
        for (int i = this.size / 2; i >= 1; --i) {
            this.fixDown(i);
        }
    }
}

