/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuBarUI";
    private transient SingleSelectionModel selectionModel;
    private boolean paintBorder = true;
    private Insets margin = null;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public JMenuBar() {
        this.setFocusTraversalKeysEnabled(false);
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public void setUI(MenuBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        SingleSelectionModel oldValue = this.selectionModel;
        this.selectionModel = model;
        this.firePropertyChange("selectionModel", oldValue, this.selectionModel);
    }

    public JMenu add(JMenu c) {
        super.add(c);
        return c;
    }

    public JMenu getMenu(int index) {
        Component c = this.getComponentAtIndex(index);
        if (c instanceof JMenu) {
            return (JMenu)c;
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public void setHelpMenu(JMenu menu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    @Transient
    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() not yet implemented.");
    }

    @Deprecated
    public Component getComponentAtIndex(int i) {
        if (i < 0 || i >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(i);
    }

    public int getComponentIndex(Component c) {
        int ncomponents = this.getComponentCount();
        Component[] component = this.getComponents();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = component[i];
            if (comp != c) continue;
            return i;
        }
        return -1;
    }

    public void setSelected(Component sel) {
        SingleSelectionModel model = this.getSelectionModel();
        int index = this.getComponentIndex(sel);
        model.setSelectedIndex(index);
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean b) {
        boolean oldValue = this.paintBorder;
        this.paintBorder = b;
        this.firePropertyChange("borderPainted", oldValue, this.paintBorder);
        if (b != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    public void setMargin(Insets m) {
        Insets old = this.margin;
        this.margin = m;
        this.firePropertyChange("margin", old, m);
        if (old == null || !old.equals(m)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    @Override
    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
    }

    @Override
    public MenuElement[] getSubElements() {
        int i;
        Vector<MenuElement> tmp = new Vector<MenuElement>();
        int c = this.getComponentCount();
        for (i = 0; i < c; ++i) {
            Component m = this.getComponent(i);
            if (!(m instanceof MenuElement)) continue;
            tmp.addElement((MenuElement)((Object)m));
        }
        MenuElement[] result = new MenuElement[tmp.size()];
        c = tmp.size();
        for (i = 0; i < c; ++i) {
            result[i] = (MenuElement)tmp.elementAt(i);
        }
        return result;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    protected String paramString() {
        String paintBorderString = this.paintBorder ? "true" : "false";
        String marginString = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",margin=" + marginString + ",paintBorder=" + paintBorderString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean retValue = super.processKeyBinding(ks, e, condition, pressed);
        if (!retValue) {
            MenuElement[] subElements;
            for (MenuElement subElement : subElements = this.getSubElements()) {
                if (!JMenuBar.processBindingForKeyStrokeRecursive(subElement, ks, e, condition, pressed)) continue;
                return true;
            }
        }
        return retValue;
    }

    static boolean processBindingForKeyStrokeRecursive(MenuElement elem, KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        MenuElement[] subElements;
        if (elem == null) {
            return false;
        }
        Component c = elem.getComponent();
        if (!c.isVisible() && !(c instanceof JPopupMenu) || !c.isEnabled()) {
            return false;
        }
        if (c != null && c instanceof JComponent && ((JComponent)c).processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        for (MenuElement subElement : subElements = elem.getSubElements()) {
            if (!JMenuBar.processBindingForKeyStrokeRecursive(subElement, ks, e, condition, pressed)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardManager.getCurrentManager().registerMenuBar(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getCurrentManager().unregisterMenuBar(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
        Object[] kvData = new Object[4];
        int n = 0;
        if (this.selectionModel instanceof Serializable) {
            kvData[n++] = "selectionModel";
            kvData[n++] = this.selectionModel;
        }
        s.writeObject(kvData);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object[] kvData = (Object[])s.readObject();
        for (int i = 0; i < kvData.length && kvData[i] != null; i += 2) {
            if (!kvData[i].equals("selectionModel")) continue;
            this.selectionModel = (SingleSelectionModel)kvData[i + 1];
        }
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            if (JMenuBar.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (JMenuBar.this.isSelected()) {
                if (i != 0) {
                    return null;
                }
                int j = JMenuBar.this.getSelectionModel().getSelectedIndex();
                if (JMenuBar.this.getComponentAtIndex(j) instanceof Accessible) {
                    return (Accessible)((Object)JMenuBar.this.getComponentAtIndex(j));
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return i == JMenuBar.this.getSelectionModel().getSelectedIndex();
        }

        @Override
        public void addAccessibleSelection(int i) {
            JMenu menu;
            int j = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (i == j) {
                return;
            }
            if (j >= 0 && j < JMenuBar.this.getMenuCount() && (menu = JMenuBar.this.getMenu(j)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(i);
            menu = JMenuBar.this.getMenu(i);
            if (menu != null) {
                MenuElement[] me = new MenuElement[]{JMenuBar.this, menu, menu.getPopupMenu()};
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (i >= 0 && i < JMenuBar.this.getMenuCount()) {
                JMenu menu = JMenuBar.this.getMenu(i);
                if (menu != null) {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
                JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            JMenu menu;
            int i = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (i >= 0 && i < JMenuBar.this.getMenuCount() && (menu = JMenuBar.this.getMenu(i)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }
}

