/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ClientPropertyKey;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.OptionPaneUI;

public class JOptionPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "OptionPaneUI";
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final String ICON_PROPERTY = "icon";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String VALUE_PROPERTY = "value";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    protected transient Icon icon;
    protected transient Object message;
    protected transient Object[] options;
    protected transient Object initialValue;
    protected int messageType;
    protected int optionType;
    protected transient Object value;
    protected transient Object[] selectionValues;
    protected transient Object inputValue;
    protected transient Object initialSelectionValue;
    protected boolean wantsInput;
    private static final Object sharedFrameKey = JOptionPane.class;

    public static String showInputDialog(Object message) throws HeadlessException {
        return JOptionPane.showInputDialog(null, message);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        return JOptionPane.showInputDialog(null, message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message) throws HeadlessException {
        return JOptionPane.showInputDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.inputDialogTitle", parentComponent), 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return (String)JOptionPane.showInputDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.inputDialogTitle", parentComponent), 3, null, null, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return (String)JOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public static void showMessageDialog(Component parentComponent, Object message) throws HeadlessException {
        JOptionPane.showMessageDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.messageDialogTitle", parentComponent), 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) throws HeadlessException {
        JOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return JOptionPane.showConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public JDialog createDialog(Component parentComponent, String title) throws HeadlessException {
        int style = JOptionPane.styleFromMessageType(this.getMessageType());
        return this.createDialog(parentComponent, title, style);
    }

    public JDialog createDialog(String title) throws HeadlessException {
        int style = JOptionPane.styleFromMessageType(this.getMessageType());
        JDialog dialog = new JDialog((Dialog)null, title, true);
        this.initDialog(dialog, style, null);
        return dialog;
    }

    private JDialog createDialog(Component parentComponent, String title, int style) throws HeadlessException {
        Window window = JOptionPane.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        if (window instanceof SwingUtilities.SharedOwnerFrame) {
            WindowListener ownerShutdownListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            dialog.addWindowListener(ownerShutdownListener);
        }
        this.initDialog(dialog, style, parentComponent);
        return dialog;
    }

    private void initDialog(final JDialog dialog, int style, Component parentComponent) {
        boolean supportsWindowDecorations;
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(style);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == JOptionPane.this && event.getPropertyName().equals(JOptionPane.VALUE_PROPERTY) && event.getNewValue() != null && event.getNewValue() != UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        };
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                JOptionPane.this.setValue(null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JOptionPane.this.removePropertyChangeListener(listener);
                dialog.getContentPane().removeAll();
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    JOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                JOptionPane.this.setValue(UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(listener);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message) {
        JOptionPane.showInternalMessageDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.messageDialogTitle", parentComponent), 1);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane.showInternalMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        JOptionPane.showInternalOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message) {
        return JOptionPane.showInternalConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        return JOptionPane.showInternalOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null);
    }

    public static int showInternalOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.putClientProperty((Object)ClientPropertyKey.PopupFactory_FORCE_HEAVYWEIGHT_POPUP, Boolean.TRUE);
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        pane.setInitialValue(initialValue);
        JInternalFrame dialog = pane.createInternalFrame(parentComponent, title);
        pane.selectInitialValue();
        dialog.setVisible(true);
        if (dialog.isVisible() && !dialog.isShowing()) {
            for (Container parent = dialog.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        try {
            Method method = AccessController.doPrivileged(new ModalPrivilegedAction(Container.class, "startLWModal"));
            if (method != null) {
                method.invoke(dialog, null);
            }
        }
        catch (IllegalAccessException method) {
        }
        catch (IllegalArgumentException method) {
        }
        catch (InvocationTargetException method) {
            // empty catch block
        }
        if (parentComponent instanceof JInternalFrame) {
            try {
                ((JInternalFrame)parentComponent).setSelected(true);
            }
            catch (PropertyVetoException method) {
                // empty catch block
            }
        }
        Object selectedValue = pane.getValue();
        if (fo != null && fo.isShowing()) {
            fo.requestFocus();
        }
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static String showInternalInputDialog(Component parentComponent, Object message) {
        return JOptionPane.showInternalInputDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.inputDialogTitle", parentComponent), 3);
    }

    public static String showInternalInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return (String)JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInternalInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        Object value;
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.putClientProperty((Object)ClientPropertyKey.PopupFactory_FORCE_HEAVYWEIGHT_POPUP, Boolean.TRUE);
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        JInternalFrame dialog = pane.createInternalFrame(parentComponent, title);
        pane.selectInitialValue();
        dialog.setVisible(true);
        if (dialog.isVisible() && !dialog.isShowing()) {
            for (Container parent = dialog.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        try {
            Method method = AccessController.doPrivileged(new ModalPrivilegedAction(Container.class, "startLWModal"));
            if (method != null) {
                method.invoke(dialog, null);
            }
        }
        catch (IllegalAccessException method) {
        }
        catch (IllegalArgumentException method) {
        }
        catch (InvocationTargetException method) {
            // empty catch block
        }
        if (parentComponent instanceof JInternalFrame) {
            try {
                ((JInternalFrame)parentComponent).setSelected(true);
            }
            catch (PropertyVetoException method) {
                // empty catch block
            }
        }
        if (fo != null && fo.isShowing()) {
            fo.requestFocus();
        }
        if ((value = pane.getInputValue()) == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public JInternalFrame createInternalFrame(Component parentComponent, String title) {
        Container parent = JOptionPane.getDesktopPaneForComponent(parentComponent);
        if (parent == null && (parentComponent == null || (parent = parentComponent.getParent()) == null)) {
            throw new RuntimeException("JOptionPane: parentComponent does not have a valid parent");
        }
        final JInternalFrame iFrame = new JInternalFrame(title, false, true, false, false);
        iFrame.putClientProperty("JInternalFrame.frameType", "optionDialog");
        iFrame.putClientProperty("JInternalFrame.messageType", this.getMessageType());
        iFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                if (JOptionPane.this.getValue() == UNINITIALIZED_VALUE) {
                    JOptionPane.this.setValue(null);
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (iFrame.isVisible() && event.getSource() == JOptionPane.this && event.getPropertyName().equals(JOptionPane.VALUE_PROPERTY)) {
                    try {
                        Method method = AccessController.doPrivileged(new ModalPrivilegedAction(Container.class, "stopLWModal"));
                        if (method != null) {
                            method.invoke(iFrame, null);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    try {
                        iFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    iFrame.setVisible(false);
                }
            }
        });
        iFrame.getContentPane().add((Component)this, "Center");
        if (parent instanceof JDesktopPane) {
            parent.add((Component)iFrame, JLayeredPane.MODAL_LAYER);
        } else {
            parent.add((Component)iFrame, "Center");
        }
        Dimension iFrameSize = iFrame.getPreferredSize();
        Dimension rootSize = parent.getSize();
        Dimension parentSize = parentComponent.getSize();
        iFrame.setBounds((rootSize.width - iFrameSize.width) / 2, (rootSize.height - iFrameSize.height) / 2, iFrameSize.width, iFrameSize.height);
        Point iFrameCoord = SwingUtilities.convertPoint(parentComponent, 0, 0, parent);
        int x = (parentSize.width - iFrameSize.width) / 2 + iFrameCoord.x;
        int y = (parentSize.height - iFrameSize.height) / 2 + iFrameCoord.y;
        int ovrx = x + iFrameSize.width - rootSize.width;
        int ovry = y + iFrameSize.height - rootSize.height;
        x = Math.max(ovrx > 0 ? x - ovrx : x, 0);
        y = Math.max(ovry > 0 ? y - ovry : y, 0);
        iFrame.setBounds(x, y, iFrameSize.width, iFrameSize.height);
        parent.validate();
        try {
            iFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return iFrame;
    }

    public static Frame getFrameForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return JOptionPane.getFrameForComponent(parentComponent.getParent());
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JOptionPane.getWindowForComponent(parentComponent.getParent());
    }

    public static JDesktopPane getDesktopPaneForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof JDesktopPane) {
            return (JDesktopPane)parentComponent;
        }
        return JOptionPane.getDesktopPaneForComponent(parentComponent.getParent());
    }

    public static void setRootFrame(Frame newRootFrame) {
        if (newRootFrame != null) {
            SwingUtilities.appContextPut(sharedFrameKey, newRootFrame);
        } else {
            SwingUtilities.appContextRemove(sharedFrameKey);
        }
    }

    public static Frame getRootFrame() throws HeadlessException {
        Frame sharedFrame = (Frame)SwingUtilities.appContextGet(sharedFrameKey);
        if (sharedFrame == null) {
            sharedFrame = SwingUtilities.getSharedOwnerFrame();
            SwingUtilities.appContextPut(sharedFrameKey, sharedFrame);
        }
        return sharedFrame;
    }

    public JOptionPane() {
        this("JOptionPane message");
    }

    public JOptionPane(Object message) {
        this(message, -1);
    }

    public JOptionPane(Object message, int messageType) {
        this(message, messageType, -1);
    }

    public JOptionPane(Object message, int messageType, int optionType) {
        this(message, messageType, optionType, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon) {
        this(message, messageType, optionType, icon, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        this(message, messageType, optionType, icon, options, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        this.message = message;
        this.options = options;
        this.initialValue = initialValue;
        this.icon = icon;
        this.setMessageType(messageType);
        this.setOptionType(optionType);
        this.value = UNINITIALIZED_VALUE;
        this.inputValue = UNINITIALIZED_VALUE;
        this.updateUI();
    }

    public void setUI(OptionPaneUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.invalidate();
        }
    }

    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setMessage(Object newMessage) {
        Object oldMessage = this.message;
        this.message = newMessage;
        this.firePropertyChange(MESSAGE_PROPERTY, oldMessage, this.message);
    }

    public Object getMessage() {
        return this.message;
    }

    public void setIcon(Icon newIcon) {
        Icon oldIcon = this.icon;
        this.icon = newIcon;
        this.firePropertyChange(ICON_PROPERTY, oldIcon, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        this.firePropertyChange(VALUE_PROPERTY, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setOptions(Object[] newOptions) {
        Object[] oldOptions = this.options;
        this.options = newOptions;
        this.firePropertyChange(OPTIONS_PROPERTY, oldOptions, this.options);
    }

    public Object[] getOptions() {
        if (this.options != null) {
            int optionCount = this.options.length;
            Object[] retOptions = new Object[optionCount];
            System.arraycopy(this.options, 0, retOptions, 0, optionCount);
            return retOptions;
        }
        return this.options;
    }

    public void setInitialValue(Object newInitialValue) {
        Object oldIV = this.initialValue;
        this.initialValue = newInitialValue;
        this.firePropertyChange(INITIAL_VALUE_PROPERTY, oldIV, this.initialValue);
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setMessageType(int newType) {
        if (newType != 0 && newType != 1 && newType != 2 && newType != 3 && newType != -1) {
            throw new RuntimeException("JOptionPane: type must be one of JOptionPane.ERROR_MESSAGE, JOptionPane.INFORMATION_MESSAGE, JOptionPane.WARNING_MESSAGE, JOptionPane.QUESTION_MESSAGE or JOptionPane.PLAIN_MESSAGE");
        }
        int oldType = this.messageType;
        this.messageType = newType;
        this.firePropertyChange(MESSAGE_TYPE_PROPERTY, oldType, this.messageType);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setOptionType(int newType) {
        if (newType != -1 && newType != 0 && newType != 1 && newType != 2) {
            throw new RuntimeException("JOptionPane: option type must be one of JOptionPane.DEFAULT_OPTION, JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_CANCEL_OPTION or JOptionPane.OK_CANCEL_OPTION");
        }
        int oldType = this.optionType;
        this.optionType = newType;
        this.firePropertyChange(OPTION_TYPE_PROPERTY, oldType, this.optionType);
    }

    public int getOptionType() {
        return this.optionType;
    }

    public void setSelectionValues(Object[] newValues) {
        Object[] oldValues = this.selectionValues;
        this.selectionValues = newValues;
        this.firePropertyChange(SELECTION_VALUES_PROPERTY, oldValues, newValues);
        if (this.selectionValues != null) {
            this.setWantsInput(true);
        }
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public void setInitialSelectionValue(Object newValue) {
        Object oldValue = this.initialSelectionValue;
        this.initialSelectionValue = newValue;
        this.firePropertyChange(INITIAL_SELECTION_VALUE_PROPERTY, oldValue, newValue);
    }

    public Object getInitialSelectionValue() {
        return this.initialSelectionValue;
    }

    public void setInputValue(Object newValue) {
        Object oldValue = this.inputValue;
        this.inputValue = newValue;
        this.firePropertyChange(INPUT_VALUE_PROPERTY, oldValue, newValue);
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public void setWantsInput(boolean newValue) {
        boolean oldValue = this.wantsInput;
        this.wantsInput = newValue;
        this.firePropertyChange(WANTS_INPUT_PROPERTY, oldValue, newValue);
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    public void selectInitialValue() {
        OptionPaneUI ui = this.getUI();
        if (ui != null) {
            ui.selectInitialValue(this);
        }
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int counter;
        int maxCounter;
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.icon != null && this.icon instanceof Serializable) {
            values.addElement(ICON_PROPERTY);
            values.addElement(this.icon);
        }
        if (this.message != null && this.message instanceof Serializable) {
            values.addElement(MESSAGE_PROPERTY);
            values.addElement(this.message);
        }
        if (this.options != null) {
            Vector<Object> serOptions = new Vector<Object>();
            maxCounter = this.options.length;
            for (counter = 0; counter < maxCounter; ++counter) {
                if (!(this.options[counter] instanceof Serializable)) continue;
                serOptions.addElement(this.options[counter]);
            }
            if (serOptions.size() > 0) {
                int optionCount = serOptions.size();
                Object[] arrayOptions = new Object[optionCount];
                serOptions.copyInto(arrayOptions);
                values.addElement(OPTIONS_PROPERTY);
                values.addElement(arrayOptions);
            }
        }
        if (this.initialValue != null && this.initialValue instanceof Serializable) {
            values.addElement(INITIAL_VALUE_PROPERTY);
            values.addElement(this.initialValue);
        }
        if (this.value != null && this.value instanceof Serializable) {
            values.addElement(VALUE_PROPERTY);
            values.addElement(this.value);
        }
        if (this.selectionValues != null) {
            boolean serialize = true;
            maxCounter = this.selectionValues.length;
            for (counter = 0; counter < maxCounter; ++counter) {
                if (this.selectionValues[counter] == null || this.selectionValues[counter] instanceof Serializable) continue;
                serialize = false;
                break;
            }
            if (serialize) {
                values.addElement(SELECTION_VALUES_PROPERTY);
                values.addElement(this.selectionValues);
            }
        }
        if (this.inputValue != null && this.inputValue instanceof Serializable) {
            values.addElement(INPUT_VALUE_PROPERTY);
            values.addElement(this.inputValue);
        }
        if (this.initialSelectionValue != null && this.initialSelectionValue instanceof Serializable) {
            values.addElement(INITIAL_SELECTION_VALUE_PROPERTY);
            values.addElement(this.initialSelectionValue);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(ICON_PROPERTY)) {
            this.icon = (Icon)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(MESSAGE_PROPERTY)) {
            this.message = values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(OPTIONS_PROPERTY)) {
            this.options = (Object[])values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(INITIAL_VALUE_PROPERTY)) {
            this.initialValue = values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(VALUE_PROPERTY)) {
            this.value = values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(SELECTION_VALUES_PROPERTY)) {
            this.selectionValues = (Object[])values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(INPUT_VALUE_PROPERTY)) {
            this.inputValue = values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(INITIAL_SELECTION_VALUE_PROPERTY)) {
            this.initialSelectionValue = values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String messageString;
        String iconString = this.icon != null ? this.icon.toString() : "";
        String initialValueString = this.initialValue != null ? this.initialValue.toString() : "";
        String string = messageString = this.message != null ? this.message.toString() : "";
        String messageTypeString = this.messageType == 0 ? "ERROR_MESSAGE" : (this.messageType == 1 ? "INFORMATION_MESSAGE" : (this.messageType == 2 ? "WARNING_MESSAGE" : (this.messageType == 3 ? "QUESTION_MESSAGE" : (this.messageType == -1 ? "PLAIN_MESSAGE" : ""))));
        String optionTypeString = this.optionType == -1 ? "DEFAULT_OPTION" : (this.optionType == 0 ? "YES_NO_OPTION" : (this.optionType == 1 ? "YES_NO_CANCEL_OPTION" : (this.optionType == 2 ? "OK_CANCEL_OPTION" : "")));
        String wantsInputString = this.wantsInput ? "true" : "false";
        return super.paramString() + ",icon=" + iconString + ",initialValue=" + initialValueString + ",message=" + messageString + ",messageType=" + messageTypeString + ",optionType=" + optionTypeString + ",wantsInput=" + wantsInputString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJOptionPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJOptionPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJOptionPane() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            switch (JOptionPane.this.messageType) {
                case 0: 
                case 1: 
                case 2: {
                    return AccessibleRole.ALERT;
                }
            }
            return AccessibleRole.OPTION_PANE;
        }
    }

    private static class ModalPrivilegedAction
    implements PrivilegedAction<Method> {
        private Class<?> clazz;
        private String methodName;

        public ModalPrivilegedAction(Class<?> clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        @Override
        public Method run() {
            AccessibleObject method = null;
            try {
                method = this.clazz.getDeclaredMethod(this.methodName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
    }
}

